/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.common.configuration.util;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.models.common.configuration.Common_ConfigurationFactory;
import org.eclipse.hyades.models.common.configuration.util.ICategory;
import org.eclipse.hyades.models.common.configuration.util.ICategoryEnumeration;

public class Common_ConfigurationCategoryUtil {
    public static final String DB_VER = "DB_VER";
    public static final String DB = "DB";
    public static final String DISP_DEPTH = "DISP_DEPTH";
    public static final String DISP_HEIGHT = "DISP_HEIGHT";
    public static final String DISP_WIDTH = "DISP_WIDTH";
    public static final String DISP_NUM = "DISP_NUM";
    public static final String SVC_PAC = "SVC_PAC";
    public static final String WBR_TYPE = "WBR_TYPE";
    public static final String WBR_VER = "WBR_VER";
    public static final String HNAME = "HNAME";
    public static final String WIN_DOM = "WIN_DOM";
    public static final String USR_NAME = "USR_NAME";
    public static final String MIN_VER = "MIN_VER";
    public static final String MAJ_VER = "MAJ_VER";
    public static final String OS = "OS";
    public static final String MEM_SZ = "MEM_SZ";
    public static final String PROC_TYPE = "PROC_TYPE";
    public static final String PROC_SPD = "PROC_SPD";
    public static final String PROC_NUM = "PROC_NUM";
    public static final String PASSWD = "PASSWD";
    public static final String CLSPATH = "CLASSPATH";
    public static final String ROOTDIR = "ROOTDIR";
    private ArrayList categories = new ArrayList(100);
    private ArrayList categoryNames = null;
    private ArrayList categoryDisplayNames = null;
    private ArrayList enumerations = null;
    private HashMap nameCategoryMap = null;
    private HashMap categoryEnumerationMap = null;
    private static final Common_ConfigurationCategoryUtil instance = new Common_ConfigurationCategoryUtil();

    public static Common_ConfigurationCategoryUtil getInstance() {
        return instance;
    }

    protected Common_ConfigurationCategoryUtil() {
        int i;
        this.categories.add(Common_ConfigurationFactory.eINSTANCE.createHyadesBrowserTypeCategory());
        this.categories.add(Common_ConfigurationFactory.eINSTANCE.createHyadesBrowserVersionCategory());
        this.categories.add(Common_ConfigurationFactory.eINSTANCE.createHyadesDatabaseCategory());
        this.categories.add(Common_ConfigurationFactory.eINSTANCE.createHyadesDatabaseVersionCategory());
        this.categories.add(Common_ConfigurationFactory.eINSTANCE.createHyadesDisplayColorDepthCategory());
        this.categories.add(Common_ConfigurationFactory.eINSTANCE.createHyadesDisplayHeightCategory());
        this.categories.add(Common_ConfigurationFactory.eINSTANCE.createHyadesDisplayNumberCategory());
        this.categories.add(Common_ConfigurationFactory.eINSTANCE.createHyadesDisplayWidthCategory());
        this.categories.add(Common_ConfigurationFactory.eINSTANCE.createHyadesHostnameCategory());
        this.categories.add(Common_ConfigurationFactory.eINSTANCE.createHyadesMajorVersionCategory());
        this.categories.add(Common_ConfigurationFactory.eINSTANCE.createHyadesMemorySizeCategory());
        this.categories.add(Common_ConfigurationFactory.eINSTANCE.createHyadesMinorVersionCategory());
        this.categories.add(Common_ConfigurationFactory.eINSTANCE.createHyadesOperatingSystemCategory());
        this.categories.add(Common_ConfigurationFactory.eINSTANCE.createHyadesProcessorNumberCategory());
        this.categories.add(Common_ConfigurationFactory.eINSTANCE.createHyadesProcessorSpeedCategory());
        this.categories.add(Common_ConfigurationFactory.eINSTANCE.createHyadesProcessorTypeCategory());
        this.categories.add(Common_ConfigurationFactory.eINSTANCE.createHyadesServicePackCategory());
        this.categories.add(Common_ConfigurationFactory.eINSTANCE.createHyadesUsernameCategory());
        this.categories.add(Common_ConfigurationFactory.eINSTANCE.createHyadesWindowsDomainCategory());
        this.categories.add(Common_ConfigurationFactory.eINSTANCE.createHyadesPasswordCategory());
        this.categories.add(Common_ConfigurationFactory.eINSTANCE.createHyadesClasspathCategory());
        this.categories.add(Common_ConfigurationFactory.eINSTANCE.createHyadesRootDirectroyCategory());
        this.enumerations = new ArrayList(100);
        this.enumerations.add(Common_ConfigurationFactory.eINSTANCE.createHyadesBrowserEnumeration());
        this.enumerations.add(Common_ConfigurationFactory.eINSTANCE.createHyadesDatabaseEnumeration());
        this.enumerations.add(Common_ConfigurationFactory.eINSTANCE.createHyadesDisplayColorDepthEnumeration());
        this.enumerations.add(Common_ConfigurationFactory.eINSTANCE.createHyadesDisplayHeightEnumeration());
        this.enumerations.add(Common_ConfigurationFactory.eINSTANCE.createHyadesDisplayWidthEnumeration());
        this.enumerations.add(Common_ConfigurationFactory.eINSTANCE.createHyadesOperatingSystemEnumeration());
        this.enumerations.add(Common_ConfigurationFactory.eINSTANCE.createHyadesProcessorTypeEnumeration());
        this.enumerations.add(Common_ConfigurationFactory.eINSTANCE.createHyadesServicePackEnumeration());
        this.nameCategoryMap = new HashMap(100);
        this.categoryDisplayNames = new ArrayList(100);
        this.categoryNames = new ArrayList(100);
        for (i = 0; i < this.categories.size(); ++i) {
            ICategory category = (ICategory)this.categories.get(i);
            String name = category.getName();
            String displayName = category.getDisplayName();
            this.nameCategoryMap.put(name, category);
            this.categoryNames.add(name);
            this.categoryDisplayNames.add(displayName);
        }
        this.categoryEnumerationMap = new HashMap(100);
        for (i = 0; i < this.enumerations.size(); ++i) {
            ICategoryEnumeration enumeration = (ICategoryEnumeration)this.enumerations.get(i);
            ICategory category = enumeration.getICategory();
            ArrayList<ICategoryEnumeration> enumerationList = new ArrayList<ICategoryEnumeration>(5);
            enumerationList.add(enumeration);
            if (category == null) continue;
            this.categoryEnumerationMap.put(category.getName(), enumerationList);
        }
        this.addCategoriesFromExtensionPoint();
        this.addCategoryEnumerationsFromExtensionPoint();
    }

    private void addCategoriesFromExtensionPoint() {
        IExtensionPoint extensionPoint = Platform.getPluginRegistry().getExtensionPoint("org.eclipse.hyades.models.common.categoryExtensions");
        if (extensionPoint != null) {
            try {
                IConfigurationElement[] extensionPoints = extensionPoint.getConfigurationElements();
                for (int i = 0; i < extensionPoints.length; ++i) {
                    ICategory category = (ICategory)extensionPoints[i].createExecutableExtension("categoryClass");
                    if (this.nameCategoryMap.containsKey(category.getName()) || category == null || category.getName() == null || category.getDisplayName() == null || this.nameCategoryMap.containsKey(category.getName())) continue;
                    this.categories.add(category);
                    this.categoryNames.add(category.getName());
                    this.categoryDisplayNames.add(category.getDisplayName());
                    this.nameCategoryMap.put(category.getName(), category);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void addCategoryEnumerationsFromExtensionPoint() {
        IExtensionPoint extensionPoint = Platform.getPluginRegistry().getExtensionPoint("org.eclipse.hyades.models.common.categoryEnumerationExtensions");
        if (extensionPoint != null) {
            try {
                IConfigurationElement[] extensionPoints = extensionPoint.getConfigurationElements();
                for (int i = 0; i < extensionPoints.length; ++i) {
                    ICategory category;
                    ICategoryEnumeration enumeration = (ICategoryEnumeration)extensionPoints[i].createExecutableExtension("enumeration");
                    if (enumeration == null || enumeration.getIEnumerationValues() == null || (category = enumeration.getICategory()) == null || !this.nameCategoryMap.containsKey(category.getName())) continue;
                    this.enumerations.add(enumeration);
                    if (this.categoryEnumerationMap.containsKey(category.getName())) {
                        ArrayList enumerationsList = (ArrayList)this.categoryEnumerationMap.get(category.getName());
                        enumerationsList.add(enumeration);
                        continue;
                    }
                    ArrayList<ICategoryEnumeration> enumerationList = new ArrayList<ICategoryEnumeration>(5);
                    enumerationList.add(enumeration);
                    this.categoryEnumerationMap.put(category.getName(), enumerationList);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public ICategory[] getCategories() {
        ICategory[] categories = new ICategory[this.categories.size()];
        for (int i = 0; i < this.categories.size(); ++i) {
            categories[i] = (ICategory)this.categories.get(i);
        }
        return categories;
    }

    public ICategoryEnumeration[] getEnumerations() {
        ICategoryEnumeration[] enumerations = new ICategoryEnumeration[this.enumerations.size()];
        for (int i = 0; i < this.enumerations.size(); ++i) {
            enumerations[i] = (ICategoryEnumeration)this.enumerations.get(i);
        }
        return enumerations;
    }

    public String[] getCategoryNames() {
        String[] names = new String[this.categoryNames.size()];
        for (int i = 0; i < this.categoryNames.size(); ++i) {
            names[i] = (String)this.categoryNames.get(i);
        }
        return names;
    }

    public String[] getCategoryDisplayNames() {
        String[] displayNames = new String[this.categoryDisplayNames.size()];
        for (int i = 0; i < this.categoryDisplayNames.size(); ++i) {
            displayNames[i] = (String)this.categoryDisplayNames.get(i);
        }
        return displayNames;
    }

    public ICategory getCategory(String categoryName) {
        return (ICategory)this.nameCategoryMap.get(categoryName);
    }

    public ICategoryEnumeration[] getCategoryEnumeration(ICategory category) {
        if (category == null) {
            return null;
        }
        ArrayList enumerationList = (ArrayList)this.categoryEnumerationMap.get(category.getName());
        if (enumerationList == null) {
            return null;
        }
        ICategoryEnumeration[] returnArray = new ICategoryEnumeration[enumerationList.size()];
        for (int i = 0; i < enumerationList.size(); ++i) {
            returnArray[i] = (ICategoryEnumeration)enumerationList.get(i);
        }
        return returnArray;
    }

    public ICategoryEnumeration[] getCategoryEnumeration(String categoryName) {
        ICategory category = null;
        if (this.nameCategoryMap != null) {
            category = (ICategory)this.nameCategoryMap.get(categoryName);
        }
        return this.getCategoryEnumeration(category);
    }
}

