/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.common.facades.behavioral.test;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.hyades.models.common.facades.behavioral.IAction;
import org.eclipse.hyades.models.common.facades.behavioral.IAnnotation;
import org.eclipse.hyades.models.common.facades.behavioral.IBlock;
import org.eclipse.hyades.models.common.facades.behavioral.ICondition;
import org.eclipse.hyades.models.common.facades.behavioral.IDecision;
import org.eclipse.hyades.models.common.facades.behavioral.IImplementor;
import org.eclipse.hyades.models.common.facades.behavioral.ILoop;
import org.eclipse.hyades.models.common.facades.behavioral.IMethod;
import org.eclipse.hyades.models.common.facades.behavioral.IProperty;
import org.eclipse.hyades.models.common.facades.behavioral.ISystemUnderTest;
import org.eclipse.hyades.models.common.facades.behavioral.ITargetInvocation;
import org.eclipse.hyades.models.common.facades.behavioral.ITest;
import org.eclipse.hyades.models.common.facades.behavioral.ITestCase;
import org.eclipse.hyades.models.common.facades.behavioral.ITestComponent;
import org.eclipse.hyades.models.common.facades.behavioral.ITestComponentInvocation;
import org.eclipse.hyades.models.common.facades.behavioral.ITestInvocation;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.models.common.facades.behavioral.IVerificationPoint;
import org.eclipse.hyades.models.common.facades.behavioral.impl.FacadeResourceFactoryImpl;
import org.eclipse.hyades.models.common.facades.behavioral.impl.HyadesFactory;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofileFactory;
import org.eclipse.hyades.models.common.testprofile.impl.TPFBehaviorImpl;
import org.eclipse.hyades.models.common.testprofile.impl.TPFTestSuiteImpl;

public class ValidateFacadeImpl
extends TestCase {
    Resource suite1Resource = null;
    String xmiFile = "TempEMFFile.testsuite";
    Resource suite2Resource = null;
    String xmiFile2 = "TempEMFFile2.testsuite";

    public ValidateFacadeImpl(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite junitTestSuite = new TestSuite("EMF Facade Impl Validation");
        junitTestSuite.addTest((Test)new ValidateFacadeImpl("testTestComponentBehaviorRemoval"));
        junitTestSuite.addTest((Test)new ValidateFacadeImpl("testTestSuiteCreation"));
        junitTestSuite.addTest((Test)new ValidateFacadeImpl("testTestSuiteModification"));
        junitTestSuite.addTest((Test)new ValidateFacadeImpl("testTestSUTRemoval"));
        junitTestSuite.addTest((Test)new ValidateFacadeImpl("testAddActions"));
        junitTestSuite.addTest((Test)new ValidateFacadeImpl("testRemoveActions"));
        junitTestSuite.addTest((Test)new ValidateFacadeImpl("testAddTargetInvocation"));
        junitTestSuite.addTest((Test)new ValidateFacadeImpl("testRemoveTargetInvocation"));
        junitTestSuite.addTest((Test)new ValidateFacadeImpl("testAddTestInvocation"));
        junitTestSuite.addTest((Test)new ValidateFacadeImpl("testRemoveTestInvocation"));
        junitTestSuite.addTest((Test)new ValidateFacadeImpl("testAddDecision"));
        junitTestSuite.addTest((Test)new ValidateFacadeImpl("testRemoveDecision"));
        junitTestSuite.addTest((Test)new ValidateFacadeImpl("testAddLoop"));
        junitTestSuite.addTest((Test)new ValidateFacadeImpl("testRemoveLoop"));
        junitTestSuite.addTest((Test)new ValidateFacadeImpl("testAddProperties"));
        junitTestSuite.addTest((Test)new ValidateFacadeImpl("testAddTestCases"));
        junitTestSuite.addTest((Test)new ValidateFacadeImpl("testRemoveTestCases"));
        junitTestSuite.addTest((Test)new ValidateFacadeImpl("testAddMethod"));
        junitTestSuite.addTest((Test)new ValidateFacadeImpl("testRemoveMethod"));
        junitTestSuite.addTest((Test)new ValidateFacadeImpl("testAddProperties"));
        junitTestSuite.addTest((Test)new ValidateFacadeImpl("testRemoveProperties"));
        junitTestSuite.addTest((Test)new ValidateFacadeImpl("testAddExternalImplementor"));
        junitTestSuite.addTest((Test)new ValidateFacadeImpl("testChangeImplementorType"));
        junitTestSuite.addTest((Test)new ValidateFacadeImpl("testGetObjectByID"));
        junitTestSuite.addTest((Test)new ValidateFacadeImpl("testGetTestSuiteFromObject"));
        junitTestSuite.addTest((Test)new ValidateFacadeImpl("testAddTestInvocationException"));
        junitTestSuite.addTest((Test)new ValidateFacadeImpl("testAddMethodToTest"));
        junitTestSuite.addTest((Test)new ValidateFacadeImpl("testTestComponentCreation"));
        junitTestSuite.addTest((Test)new ValidateFacadeImpl("testTestComponentInvocation"));
        junitTestSuite.addTest((Test)new ValidateFacadeImpl("testRemoveAnnotations"));
        junitTestSuite.addTest((Test)new ValidateFacadeImpl("testPutAnnotations"));
        junitTestSuite.addTest((Test)new ValidateFacadeImpl("testGetAnnotations"));
        return junitTestSuite;
    }

    public void setUp() {
        Map m;
        Resource.Factory.Registry reg;
        URI fileURI;
        File file;
        ResourceSetImpl resourceSet;
        if (this.suite1Resource == null) {
            resourceSet = new ResourceSetImpl();
            file = new File(this.xmiFile);
            fileURI = URI.createFileURI((String)file.getAbsolutePath());
            reg = Resource.Factory.Registry.INSTANCE;
            m = reg.getExtensionToFactoryMap();
            m.put("testsuite", new FacadeResourceFactoryImpl());
            resourceSet.getResourceFactoryRegistry();
            this.suite1Resource = resourceSet.createResource(fileURI);
        }
        if (this.suite2Resource == null) {
            resourceSet = new ResourceSetImpl();
            file = new File(this.xmiFile2);
            fileURI = URI.createFileURI((String)file.getAbsolutePath());
            reg = Resource.Factory.Registry.INSTANCE;
            m = reg.getExtensionToFactoryMap();
            m.put("testsuite", new FacadeResourceFactoryImpl());
            resourceSet.getResourceFactoryRegistry();
            this.suite2Resource = resourceSet.createResource(fileURI);
        }
    }

    public void tearDown() {
    }

    public void testTestSuiteCreation() {
        ITestSuite testSuite = this.createTestSuite(this.suite1Resource);
        ITestCase testCase = this.createTestCase();
        testCase.setName("Test Case 1");
        testCase.setDescription("A simple test case");
        IImplementor implementor = this.createImplementor(testSuite, false);
        implementor.setName("Test Driver 1");
        implementor.setDescription("A test driver");
        implementor.setLocation("main");
        implementor.setResource("C:\\temp\\testDriver1.java");
        ISystemUnderTest systemUnderTest = this.createSystemUnderTest();
        systemUnderTest.setName("System Under Test 1");
        systemUnderTest.setDescription("A generic system under test");
        systemUnderTest.setLocation("");
        systemUnderTest.setResource("C:\\temp\\systemUnderTest1.java");
        ITestComponent testComponent = this.createTestComponent(testSuite);
        testComponent.setName("Stub 1");
        testComponent.setDescription("A sample stub");
        List implementors = testComponent.getImplementors();
        IImplementor testComponentImplementor = this.createImplementor(testComponent, "implementor1", false);
        testSuite.setName("Test Suite 1");
        testSuite.setDescription("A simple Test Suite with one of everythiing");
        testSuite.getITestCases().add(0, testCase);
        testSuite.getISystemsUnderTest().add(0, systemUnderTest);
        testSuite.getITestComponents().add(0, testComponent);
        ValidateFacadeImpl.assertEquals((String)"Test Suite 1", (String)testSuite.getName());
        ValidateFacadeImpl.assertEquals((String)"A simple Test Suite with one of everythiing", (String)testSuite.getDescription());
        ValidateFacadeImpl.assertEquals((Object)testCase, testSuite.getITestCases().get(0));
        ValidateFacadeImpl.assertEquals((Object)testComponent, testSuite.getITestComponents().get(0));
        ValidateFacadeImpl.assertEquals((Object)systemUnderTest, testSuite.getISystemsUnderTest().get(0));
        ValidateFacadeImpl.assertEquals((Object)implementor, (Object)testSuite.getImplementor());
        this.save(testSuite);
        ITestSuite reloadedTestSuite = (ITestSuite)this.load();
        ValidateFacadeImpl.assertEquals((String)"Test Suite 1", (String)reloadedTestSuite.getName());
        ValidateFacadeImpl.assertEquals((String)"A simple Test Suite with one of everythiing", (String)reloadedTestSuite.getDescription());
        ValidateFacadeImpl.assertEquals((String)"Test Case 1", (String)((ITestCase)reloadedTestSuite.getITestCases().get(0)).getName());
        ValidateFacadeImpl.assertEquals((String)"A simple test case", (String)((ITestCase)reloadedTestSuite.getITestCases().get(0)).getDescription());
        ValidateFacadeImpl.assertEquals((Object)reloadedTestSuite, (Object)((ITestCase)reloadedTestSuite.getITestCases().get(0)).getOwner());
        ValidateFacadeImpl.assertEquals((String)"Stub 1", (String)((ITestComponent)reloadedTestSuite.getITestComponents().get(0)).getName());
        ValidateFacadeImpl.assertEquals((String)"A sample stub", (String)((ITestComponent)reloadedTestSuite.getITestComponents().get(0)).getDescription());
        ValidateFacadeImpl.assertEquals((Object)reloadedTestSuite, (Object)((ITestComponent)reloadedTestSuite.getITestComponents().get(0)).getOwner());
        ValidateFacadeImpl.assertEquals((String)"System Under Test 1", (String)((ISystemUnderTest)reloadedTestSuite.getISystemsUnderTest().get(0)).getName());
        ValidateFacadeImpl.assertEquals((String)"A generic system under test", (String)((ISystemUnderTest)reloadedTestSuite.getISystemsUnderTest().get(0)).getDescription());
        ValidateFacadeImpl.assertEquals((String)"C:\\temp\\systemUnderTest1.java", (String)((ISystemUnderTest)reloadedTestSuite.getISystemsUnderTest().get(0)).getResource());
        ValidateFacadeImpl.assertEquals((String)"", (String)((ISystemUnderTest)reloadedTestSuite.getISystemsUnderTest().get(0)).getLocation());
        ValidateFacadeImpl.assertEquals((Object)reloadedTestSuite, (Object)((ISystemUnderTest)reloadedTestSuite.getISystemsUnderTest().get(0)).getOwner());
        ValidateFacadeImpl.assertEquals((String)"Test Driver 1", (String)reloadedTestSuite.getImplementor().getName());
        ValidateFacadeImpl.assertEquals((String)"A test driver", (String)reloadedTestSuite.getImplementor().getDescription());
        ValidateFacadeImpl.assertEquals((String)"C:\\temp\\testDriver1.java", (String)reloadedTestSuite.getImplementor().getResource());
        ValidateFacadeImpl.assertEquals((String)"main", (String)reloadedTestSuite.getImplementor().getLocation());
        ValidateFacadeImpl.assertEquals((Object)reloadedTestSuite, (Object)reloadedTestSuite.getImplementor().getOwner());
    }

    public void testTestSUTRemoval() {
        this.createSimpleTestSuite();
        ITestSuite testSuite = (ITestSuite)this.load();
        testSuite.getISystemsUnderTest().remove(0);
        ValidateFacadeImpl.assertEquals((int)1, (int)((TPFBehaviorImpl)testSuite.getImplementor()).getInteraction().getLifelines().size());
        this.save(testSuite);
        ITestSuite reloadedTestSuite = (ITestSuite)this.load();
        ValidateFacadeImpl.assertEquals((int)0, (int)reloadedTestSuite.getISystemsUnderTest().size());
    }

    public void testTestSuiteModification() {
        this.createSimpleTestSuite();
        ITestSuite testSuite = (ITestSuite)this.load();
        testSuite.setName("Changed Test Suite");
        testSuite.setDescription("A changed Test Suite");
        ISystemUnderTest systemUnderTest2 = this.createSystemUnderTest();
        ISystemUnderTest systemUnderTest3 = this.createSystemUnderTest();
        systemUnderTest2.setName("System Under Test 2");
        systemUnderTest2.setDescription("A generic system under test");
        systemUnderTest2.setLocation("");
        systemUnderTest2.setResource("C:\\temp\\systemUnderTest2.java");
        systemUnderTest3.setName("System Under Test 3");
        systemUnderTest3.setDescription("A generic system under test");
        systemUnderTest3.setLocation("");
        systemUnderTest3.setResource("C:\\temp\\systemUnderTest3.java");
        Vector<ISystemUnderTest> someSUTs = new Vector<ISystemUnderTest>();
        someSUTs.add(systemUnderTest2);
        someSUTs.add(systemUnderTest3);
        testSuite.getISystemsUnderTest().addAll(someSUTs);
        this.save(testSuite);
        ITestComponent newStub = this.createTestComponent(testSuite);
        newStub.setName("Stub 2");
        newStub.setDescription("A second stub");
        newStub.setLocation("");
        newStub.setResource("c:\\temp\\stub2.java");
        testSuite.getITestComponents().add(newStub);
        ValidateFacadeImpl.assertEquals((String)"Changed Test Suite", (String)testSuite.getName());
        ValidateFacadeImpl.assertEquals((String)"A changed Test Suite", (String)testSuite.getDescription());
        ValidateFacadeImpl.assertEquals((int)3, (int)testSuite.getISystemsUnderTest().size());
        ValidateFacadeImpl.assertEquals((Object)systemUnderTest2, testSuite.getISystemsUnderTest().get(1));
        ValidateFacadeImpl.assertEquals((Object)systemUnderTest3, testSuite.getISystemsUnderTest().get(2));
        ValidateFacadeImpl.assertEquals((String)"System Under Test 2", (String)((ISystemUnderTest)testSuite.getISystemsUnderTest().get(1)).getName());
        ValidateFacadeImpl.assertEquals((Object)newStub, testSuite.getITestComponents().get(1));
        this.save(testSuite);
        ITestSuite reloadedTestSuite = (ITestSuite)this.load();
        ValidateFacadeImpl.assertEquals((String)"Changed Test Suite", (String)reloadedTestSuite.getName());
        ValidateFacadeImpl.assertEquals((String)"A changed Test Suite", (String)reloadedTestSuite.getDescription());
        ValidateFacadeImpl.assertEquals((String)"System Under Test 2", (String)((ISystemUnderTest)reloadedTestSuite.getISystemsUnderTest().get(1)).getName());
        ValidateFacadeImpl.assertEquals((String)"A generic system under test", (String)((ISystemUnderTest)reloadedTestSuite.getISystemsUnderTest().get(1)).getDescription());
        ValidateFacadeImpl.assertEquals((String)"C:\\temp\\systemUnderTest2.java", (String)((ISystemUnderTest)reloadedTestSuite.getISystemsUnderTest().get(1)).getResource());
        ValidateFacadeImpl.assertEquals((String)"", (String)((ISystemUnderTest)reloadedTestSuite.getISystemsUnderTest().get(1)).getLocation());
        ValidateFacadeImpl.assertEquals((Object)reloadedTestSuite, (Object)((ISystemUnderTest)reloadedTestSuite.getISystemsUnderTest().get(1)).getOwner());
        ValidateFacadeImpl.assertEquals((String)"System Under Test 3", (String)((ISystemUnderTest)reloadedTestSuite.getISystemsUnderTest().get(2)).getName());
        ValidateFacadeImpl.assertEquals((String)"A generic system under test", (String)((ISystemUnderTest)reloadedTestSuite.getISystemsUnderTest().get(2)).getDescription());
        ValidateFacadeImpl.assertEquals((String)"C:\\temp\\systemUnderTest3.java", (String)((ISystemUnderTest)reloadedTestSuite.getISystemsUnderTest().get(2)).getResource());
        ValidateFacadeImpl.assertEquals((String)"", (String)((ISystemUnderTest)reloadedTestSuite.getISystemsUnderTest().get(2)).getLocation());
        ValidateFacadeImpl.assertEquals((Object)reloadedTestSuite, (Object)((ISystemUnderTest)reloadedTestSuite.getISystemsUnderTest().get(2)).getOwner());
        ValidateFacadeImpl.assertEquals((String)"Stub 2", (String)((ITestComponent)reloadedTestSuite.getITestComponents().get(1)).getName());
        ValidateFacadeImpl.assertEquals((String)"A second stub", (String)((ITestComponent)reloadedTestSuite.getITestComponents().get(1)).getDescription());
        ValidateFacadeImpl.assertEquals((Object)reloadedTestSuite, (Object)((ITestComponent)reloadedTestSuite.getITestComponents().get(1)).getOwner());
        Vector removedSUTs = new Vector();
        removedSUTs.add(reloadedTestSuite.getISystemsUnderTest().get(0));
        removedSUTs.add(reloadedTestSuite.getISystemsUnderTest().get(1));
        reloadedTestSuite.getISystemsUnderTest().removeAll(removedSUTs);
        ValidateFacadeImpl.assertEquals((String)"System Under Test 3", (String)((ISystemUnderTest)reloadedTestSuite.getISystemsUnderTest().get(0)).getName());
        ValidateFacadeImpl.assertEquals((String)"A generic system under test", (String)((ISystemUnderTest)reloadedTestSuite.getISystemsUnderTest().get(0)).getDescription());
        ValidateFacadeImpl.assertEquals((String)"C:\\temp\\systemUnderTest3.java", (String)((ISystemUnderTest)reloadedTestSuite.getISystemsUnderTest().get(0)).getResource());
        ValidateFacadeImpl.assertEquals((String)"", (String)((ISystemUnderTest)reloadedTestSuite.getISystemsUnderTest().get(0)).getLocation());
        ValidateFacadeImpl.assertEquals((Object)reloadedTestSuite, (Object)((ISystemUnderTest)reloadedTestSuite.getISystemsUnderTest().get(0)).getOwner());
    }

    public void testAddActions() {
        this.createSimpleTestSuite();
        ITestSuite testSuite = (ITestSuite)this.load();
        IImplementor implementor = testSuite.getImplementor();
        IBlock block = implementor.getBlock();
        ISystemUnderTest systemUnderTest = (ISystemUnderTest)testSuite.getISystemsUnderTest().get(0);
        systemUnderTest.setDescription("An SUT with operations");
        systemUnderTest.setLocation("main");
        Vector<IAction> actions = new Vector<IAction>();
        IMethod method = this.createMethod();
        method.setName("method1");
        method.setDescription("Pick me!  Pick me!!");
        systemUnderTest.getMethods().add(method);
        ITargetInvocation targetInvocation = this.createTargetInvocation(method);
        targetInvocation.setName("Target Invocation 1");
        targetInvocation.setDescription("A simple target invocation");
        targetInvocation.setSynchronous(true);
        ITestSuite testSuite2 = this.createTestSuite(this.suite2Resource);
        IImplementor implementor2 = this.createImplementor(testSuite2, false);
        testSuite2.setName("Invokable Test Suite");
        testSuite2.setDescription("A TestSuite to be invoked");
        this.save(testSuite2);
        ITestInvocation testInvocation = this.createTestInvocation(testSuite2);
        testInvocation.setName("Test Invocation 1");
        testInvocation.setDescription("A simple test invocation");
        testInvocation.setSynchronous(true);
        IVerificationPoint actionVP = this.createVerificationPoint();
        actionVP.setName("VP 1");
        actionVP.setDescription("A generic VP");
        actions.add(targetInvocation);
        actions.add(testInvocation);
        actions.add(actionVP);
        block.getActions().addAll(actions);
        ValidateFacadeImpl.assertEquals((int)3, (int)block.getActions().size());
        ValidateFacadeImpl.assertEquals((Object)targetInvocation, block.getActions().get(0));
        ValidateFacadeImpl.assertEquals((Object)testInvocation, block.getActions().get(1));
        ValidateFacadeImpl.assertEquals((Object)actionVP, block.getActions().get(2));
        this.save(testSuite);
        ITestSuite reloadedTestSuite = (ITestSuite)this.load();
        IBlock tempBlock = reloadedTestSuite.getImplementor().getBlock();
        ValidateFacadeImpl.assertEquals((int)3, (int)tempBlock.getActions().size());
        ValidateFacadeImpl.assertEquals((String)"Target Invocation 1", (String)((ITargetInvocation)tempBlock.getActions().get(0)).getName());
        ValidateFacadeImpl.assertEquals((String)"method1", (String)((ITargetInvocation)tempBlock.getActions().get(0)).getInvocation().getName());
        ValidateFacadeImpl.assertEquals((boolean)true, (boolean)((ITargetInvocation)tempBlock.getActions().get(0)).isSynchronous());
        ValidateFacadeImpl.assertEquals((String)"Test Invocation 1", (String)((ITestInvocation)tempBlock.getActions().get(1)).getName());
        ValidateFacadeImpl.assertEquals((String)"A simple test invocation", (String)((ITestInvocation)tempBlock.getActions().get(1)).getDescription());
        ValidateFacadeImpl.assertEquals((boolean)true, (boolean)((ITestInvocation)tempBlock.getActions().get(1)).isSynchronous());
        ValidateFacadeImpl.assertEquals((String)"Invokable Test Suite", (String)((ITestInvocation)tempBlock.getActions().get(1)).getInvokedTest().getName());
        ValidateFacadeImpl.assertEquals((String)"VP 1", (String)((IVerificationPoint)tempBlock.getActions().get(2)).getName());
        ValidateFacadeImpl.assertEquals((String)"A generic VP", (String)((IVerificationPoint)tempBlock.getActions().get(2)).getDescription());
    }

    public void testRemoveActions() {
        this.testAddActions();
        ITestSuite testSuite = (ITestSuite)this.load();
        IImplementor implementor = testSuite.getImplementor();
        IBlock block = implementor.getBlock();
        IAction action1 = (IAction)block.getActions().get(0);
        IAction action2 = (IAction)block.getActions().get(1);
        Vector<IAction> actions = new Vector<IAction>();
        actions.add(action1);
        actions.add(action2);
        block.getActions().removeAll(actions);
        ValidateFacadeImpl.assertEquals((int)1, (int)block.getActions().size());
        ValidateFacadeImpl.assertTrue((boolean)(block.getActions().get(0) instanceof IVerificationPoint));
        this.save(testSuite);
        ITestSuite reloadedTestSuite = (ITestSuite)this.load();
        IBlock tempBlock = reloadedTestSuite.getImplementor().getBlock();
        ValidateFacadeImpl.assertEquals((int)1, (int)tempBlock.getActions().size());
        ValidateFacadeImpl.assertEquals((String)"VP 1", (String)((IVerificationPoint)tempBlock.getActions().get(0)).getName());
        ValidateFacadeImpl.assertEquals((String)"A generic VP", (String)((IVerificationPoint)tempBlock.getActions().get(0)).getDescription());
    }

    public void testAddTargetInvocation() {
        this.createSimpleTestSuite();
        ITestSuite testSuite = (ITestSuite)this.load();
        IImplementor implementor = testSuite.getImplementor();
        IBlock block = implementor.getBlock();
        ISystemUnderTest systemUnderTest = (ISystemUnderTest)testSuite.getISystemsUnderTest().get(0);
        systemUnderTest.setDescription("An SUT with operations");
        systemUnderTest.setLocation("main");
        IMethod method = this.createMethod();
        method.setName("method1");
        method.setDescription("Pick me!  Pick me!!");
        systemUnderTest.getMethods().add(method);
        ITargetInvocation targetInvocation = this.createTargetInvocation(method);
        targetInvocation.setName("Target Invocation 1");
        targetInvocation.setDescription("A simple target invocation");
        targetInvocation.setSynchronous(true);
        block.getActions().add(0, targetInvocation);
        ValidateFacadeImpl.assertEquals((Object)targetInvocation, block.getActions().get(0));
        this.save(testSuite);
        ITestSuite reloadedTestSuite = (ITestSuite)this.load();
        IImplementor tempImplementor = reloadedTestSuite.getImplementor();
        IAction tempAction = (IAction)tempImplementor.getBlock().getActions().get(0);
        ValidateFacadeImpl.assertEquals((String)"Target Invocation 1", (String)tempAction.getName());
        ValidateFacadeImpl.assertEquals((String)"method1", (String)((ITargetInvocation)tempAction).getInvocation().getName());
        ValidateFacadeImpl.assertEquals((boolean)true, (boolean)((ITargetInvocation)tempAction).isSynchronous());
    }

    public void testRemoveTargetInvocation() {
        this.testAddTargetInvocation();
        ITestSuite testSuite = (ITestSuite)this.load();
        IImplementor implementor = testSuite.getImplementor();
        IBlock block = implementor.getBlock();
        block.getActions().remove(0);
        this.save(testSuite);
        ITestSuite reloadedTestSuite = (ITestSuite)this.load();
        IImplementor tempImplementor = reloadedTestSuite.getImplementor();
        ValidateFacadeImpl.assertEquals((int)0, (int)tempImplementor.getBlock().getActions().size());
    }

    public void testAddTestInvocation() {
        this.createSimpleTestSuite();
        ITestSuite testSuite = (ITestSuite)this.load();
        IImplementor implementor = testSuite.getImplementor();
        IBlock block = implementor.getBlock();
        ITestSuite testSuite2 = this.createTestSuite(this.suite2Resource);
        IImplementor implementor2 = this.createImplementor(testSuite2, false);
        testSuite2.setName("Invokable Test Suite");
        testSuite2.setDescription("A TestSuite to be invoked");
        this.save(testSuite2);
        ITestInvocation testInvocation = this.createTestInvocation(testSuite2);
        testInvocation.setName("Test Invocation 1");
        testInvocation.setDescription("A simple test invocation");
        testInvocation.setSynchronous(true);
        block.getActions().add(0, testInvocation);
        ValidateFacadeImpl.assertEquals((Object)testInvocation, (Object)((ITestInvocation)testSuite.getImplementor().getBlock().getActions().get(0)));
        this.save(testSuite);
        ITestSuite reloadedTestSuite = (ITestSuite)this.load();
        IImplementor tempImplementor = reloadedTestSuite.getImplementor();
        IAction tempAction = (IAction)tempImplementor.getBlock().getActions().get(0);
        ValidateFacadeImpl.assertEquals((String)"Test Invocation 1", (String)tempAction.getName());
        ValidateFacadeImpl.assertEquals((String)"A simple test invocation", (String)tempAction.getDescription());
        ValidateFacadeImpl.assertEquals((boolean)true, (boolean)((ITestInvocation)tempAction).isSynchronous());
        ValidateFacadeImpl.assertEquals((String)"Invokable Test Suite", (String)((ITestInvocation)tempAction).getInvokedTest().getName());
    }

    public void testRemoveTestInvocation() {
        this.testAddTestInvocation();
        ITestSuite testSuite = (ITestSuite)this.load();
        IImplementor implementor = testSuite.getImplementor();
        IBlock block = implementor.getBlock();
        block.getActions().remove(0);
        ValidateFacadeImpl.assertEquals((int)0, (int)block.getActions().size());
        this.save(testSuite);
        ITestSuite reloadedTestSuite = (ITestSuite)this.load();
        ValidateFacadeImpl.assertEquals((int)0, (int)reloadedTestSuite.getImplementor().getBlock().getActions().size());
    }

    public void testAddDecision() {
        this.createSimpleTestSuite();
        ITestSuite testSuite = (ITestSuite)this.load();
        IImplementor implementor = testSuite.getImplementor();
        IBlock block = implementor.getBlock();
        Vector<IAction> failureBlockActions = new Vector<IAction>();
        ITestSuite testSuite2 = this.createTestSuite(this.suite2Resource);
        IImplementor implementor2 = this.createImplementor(testSuite2, false);
        testSuite2.setName("Invokable Test Suite");
        testSuite2.setDescription("A TestSuite to be invoked");
        this.save(testSuite2);
        IVerificationPoint actionVP = this.createVerificationPoint();
        actionVP.setName("VP 1");
        actionVP.setDescription("A generic VP");
        ISystemUnderTest systemUnderTest = (ISystemUnderTest)testSuite.getISystemsUnderTest().get(0);
        IMethod method = this.createMethod();
        method.setName("method1");
        method.setDescription("Pick me!  Pick me!!");
        systemUnderTest.getMethods().add(method);
        ITargetInvocation actionTargetInvocation = this.createTargetInvocation(method);
        actionTargetInvocation.setName("Target Invocation 1");
        actionTargetInvocation.setDescription("A simple target invocation");
        ITestInvocation actionTestInvocation = this.createTestInvocation(testSuite2);
        actionTestInvocation.setName("Test Invocation 1");
        actionTestInvocation.setDescription("A simple test invocation");
        IDecision decision = this.createDecision();
        block.getActions().add(decision);
        ICondition condition = decision.getCondition();
        condition.setConstraint("i>5");
        condition.setName("Condition 1");
        condition.setDescription("Less than 5");
        decision.getSuccessBlock().getActions().add(actionTestInvocation);
        decision.getSuccessBlock().getActions().add(actionVP);
        IDecision nestedDecision = this.createDecision();
        nestedDecision.setName("Nested Decision");
        failureBlockActions.add(actionTargetInvocation);
        failureBlockActions.add(nestedDecision);
        decision.getFailureBlock().getActions().addAll(failureBlockActions);
        IImplementor tempImplementor = testSuite.getImplementor();
        IAction tempAction = (IAction)tempImplementor.getBlock().getActions().get(0);
        ValidateFacadeImpl.assertEquals((Object)decision, (Object)tempAction);
        ValidateFacadeImpl.assertEquals((String)"i>5", (String)((IDecision)tempAction).getCondition().getConstraint());
        ValidateFacadeImpl.assertEquals((int)2, (int)((IDecision)tempAction).getSuccessBlock().getActions().size());
        ValidateFacadeImpl.assertEquals((int)2, (int)((IDecision)tempAction).getFailureBlock().getActions().size());
        ValidateFacadeImpl.assertEquals((Object)testSuite2, (Object)((ITestInvocation)((IDecision)tempAction).getSuccessBlock().getActions().get(0)).getInvokedTest());
        ValidateFacadeImpl.assertEquals((Object)actionTestInvocation, ((IDecision)tempAction).getSuccessBlock().getActions().get(0));
        ValidateFacadeImpl.assertEquals((Object)actionVP, ((IDecision)tempAction).getSuccessBlock().getActions().get(1));
        ValidateFacadeImpl.assertEquals((Object)actionTargetInvocation, ((IDecision)tempAction).getFailureBlock().getActions().get(0));
        ValidateFacadeImpl.assertEquals((Object)nestedDecision, ((IDecision)tempAction).getFailureBlock().getActions().get(1));
        this.save(testSuite);
        ITestSuite reloadedTestSuite = (ITestSuite)this.load();
        tempImplementor = reloadedTestSuite.getImplementor();
        tempAction = (IAction)tempImplementor.getBlock().getActions().get(0);
        IDecision tempDecision = (IDecision)tempAction;
        ValidateFacadeImpl.assertEquals((String)"i>5", (String)tempDecision.getCondition().getConstraint());
        ValidateFacadeImpl.assertEquals((int)2, (int)tempDecision.getSuccessBlock().getActions().size());
        ValidateFacadeImpl.assertEquals((int)2, (int)tempDecision.getFailureBlock().getActions().size());
        ValidateFacadeImpl.assertEquals((String)"Test Invocation 1", (String)((ITestInvocation)tempDecision.getSuccessBlock().getActions().get(0)).getName());
        ValidateFacadeImpl.assertEquals((String)"A simple test invocation", (String)((ITestInvocation)tempDecision.getSuccessBlock().getActions().get(0)).getDescription());
        ValidateFacadeImpl.assertEquals((String)testSuite2.getName(), (String)((ITestInvocation)tempDecision.getSuccessBlock().getActions().get(0)).getInvokedTest().getName());
        ValidateFacadeImpl.assertEquals((String)"VP 1", (String)((IVerificationPoint)tempDecision.getSuccessBlock().getActions().get(1)).getName());
        ValidateFacadeImpl.assertEquals((String)"A generic VP", (String)((IVerificationPoint)tempDecision.getSuccessBlock().getActions().get(1)).getDescription());
        ValidateFacadeImpl.assertEquals((String)"Target Invocation 1", (String)((ITargetInvocation)tempDecision.getFailureBlock().getActions().get(0)).getName());
        ValidateFacadeImpl.assertEquals((String)"A simple target invocation", (String)((ITargetInvocation)tempDecision.getFailureBlock().getActions().get(0)).getDescription());
        ValidateFacadeImpl.assertEquals((String)"Nested Decision", (String)((IDecision)tempDecision.getFailureBlock().getActions().get(1)).getName());
    }

    public void testRemoveDecision() {
        this.testAddDecision();
        ITestSuite testSuite = (ITestSuite)this.load();
        IImplementor implementor = testSuite.getImplementor();
        IBlock block = implementor.getBlock();
        IDecision decision = (IDecision)block.getActions().get(0);
        decision.getFailureBlock().getActions().remove(1);
        ValidateFacadeImpl.assertEquals((int)1, (int)decision.getFailureBlock().getActions().size());
        ValidateFacadeImpl.assertTrue((!(decision.getFailureBlock().getActions().get(0) instanceof IDecision) ? 1 : 0) != 0);
        Vector removedActions = new Vector();
        removedActions.add(decision.getSuccessBlock().getActions().get(0));
        decision.getSuccessBlock().getActions().removeAll(removedActions);
        ValidateFacadeImpl.assertEquals((int)1, (int)decision.getSuccessBlock().getActions().size());
        ValidateFacadeImpl.assertTrue((boolean)(decision.getSuccessBlock().getActions().get(0) instanceof IVerificationPoint));
        block.getActions().remove(0);
        ValidateFacadeImpl.assertEquals((int)0, (int)block.getActions().size());
        this.save(testSuite);
        ITestSuite reloadedTestSuite = (ITestSuite)this.load();
        ValidateFacadeImpl.assertEquals((int)0, (int)reloadedTestSuite.getImplementor().getBlock().getActions().size());
    }

    public void testAddLoop() {
        this.createSimpleTestSuite();
        ITestSuite testSuite = (ITestSuite)this.load();
        IImplementor implementor = testSuite.getImplementor();
        IBlock block = implementor.getBlock();
        Vector<IAction> someLoopActions = new Vector<IAction>();
        ITestSuite testSuite2 = this.createTestSuite(this.suite2Resource);
        IImplementor implementor2 = this.createImplementor(testSuite2, false);
        testSuite2.setName("Invokable Test Suite");
        testSuite2.setDescription("A TestSuite to be invoked");
        this.save(testSuite2);
        IVerificationPoint actionVP = this.createVerificationPoint();
        actionVP.setName("VP 1");
        actionVP.setDescription("A generic VP");
        ITestInvocation actionTestInvocation = this.createTestInvocation(testSuite2);
        actionTestInvocation.setName("Test Invocation 1");
        actionTestInvocation.setDescription("A simple test invocation");
        ILoop loop = this.createLoop();
        block.getActions().add(loop);
        someLoopActions.add(actionTestInvocation);
        someLoopActions.add(actionVP);
        loop.getBlock().getActions().addAll(someLoopActions);
        loop.getCondition().setConstraint("int i = 0; i < 5; i++");
        ILoop nestedLoop = this.createLoop();
        nestedLoop.setName("Nested Loop");
        nestedLoop.getCondition().setConstraint("true");
        loop.getBlock().getActions().add(nestedLoop);
        IImplementor tempImplementor = testSuite.getImplementor();
        IAction tempAction = (IAction)tempImplementor.getBlock().getActions().get(0);
        ValidateFacadeImpl.assertEquals((Object)loop, (Object)tempAction);
        ValidateFacadeImpl.assertEquals((String)"int i = 0; i < 5; i++", (String)((ILoop)tempAction).getCondition().getConstraint());
        ValidateFacadeImpl.assertEquals((int)3, (int)((ILoop)tempAction).getBlock().getActions().size());
        ValidateFacadeImpl.assertEquals((Object)testSuite2, (Object)((ITestInvocation)((ILoop)tempAction).getBlock().getActions().get(0)).getInvokedTest());
        ValidateFacadeImpl.assertEquals((Object)actionTestInvocation, ((ILoop)tempAction).getBlock().getActions().get(0));
        ValidateFacadeImpl.assertEquals((Object)actionVP, ((ILoop)tempAction).getBlock().getActions().get(1));
        ValidateFacadeImpl.assertEquals((Object)nestedLoop, ((ILoop)tempAction).getBlock().getActions().get(2));
        this.save(testSuite);
        ITestSuite reloadedTestSuite = (ITestSuite)this.load();
        tempImplementor = reloadedTestSuite.getImplementor();
        tempAction = (IAction)tempImplementor.getBlock().getActions().get(0);
        ILoop tempLoop = (ILoop)tempAction;
        ValidateFacadeImpl.assertEquals((String)"int i = 0; i < 5; i++", (String)tempLoop.getCondition().getConstraint());
        ValidateFacadeImpl.assertEquals((int)3, (int)tempLoop.getBlock().getActions().size());
        ValidateFacadeImpl.assertEquals((String)"Test Invocation 1", (String)((ITestInvocation)tempLoop.getBlock().getActions().get(0)).getName());
        ValidateFacadeImpl.assertEquals((String)"A simple test invocation", (String)((ITestInvocation)tempLoop.getBlock().getActions().get(0)).getDescription());
        ValidateFacadeImpl.assertEquals((String)testSuite2.getName(), (String)((ITestInvocation)tempLoop.getBlock().getActions().get(0)).getInvokedTest().getName());
        ValidateFacadeImpl.assertEquals((String)"VP 1", (String)((IVerificationPoint)tempLoop.getBlock().getActions().get(1)).getName());
        ValidateFacadeImpl.assertEquals((String)"A generic VP", (String)((IVerificationPoint)tempLoop.getBlock().getActions().get(1)).getDescription());
        ValidateFacadeImpl.assertEquals((String)"Nested Loop", (String)((ILoop)tempLoop.getBlock().getActions().get(2)).getName());
    }

    public void testRemoveLoop() {
        this.testAddLoop();
        ITestSuite testSuite = (ITestSuite)this.load();
        IImplementor implementor = testSuite.getImplementor();
        IBlock block = implementor.getBlock();
        ILoop loop = (ILoop)block.getActions().get(0);
        loop.getBlock().getActions().remove(2);
        ValidateFacadeImpl.assertEquals((int)2, (int)loop.getBlock().getActions().size());
        ValidateFacadeImpl.assertTrue((!(loop.getBlock().getActions().get(0) instanceof ILoop) ? 1 : 0) != 0);
        ValidateFacadeImpl.assertTrue((!(loop.getBlock().getActions().get(1) instanceof ILoop) ? 1 : 0) != 0);
        Vector removedActions = new Vector();
        removedActions.add(loop.getBlock().getActions().get(0));
        removedActions.add(loop.getBlock().getActions().get(1));
        loop.getBlock().getActions().removeAll(removedActions);
        ValidateFacadeImpl.assertEquals((int)0, (int)loop.getBlock().getActions().size());
        block.getActions().remove(0);
        ValidateFacadeImpl.assertEquals((int)0, (int)block.getActions().size());
        this.save(testSuite);
        ITestSuite reloadedTestSuite = (ITestSuite)this.load();
        ValidateFacadeImpl.assertEquals((int)0, (int)reloadedTestSuite.getImplementor().getBlock().getActions().size());
    }

    public void testAddProperties() {
        this.createSimpleTestSuite();
        ITestSuite testSuite = (ITestSuite)this.load();
        IImplementor implementor = testSuite.getImplementor();
        IBlock block = implementor.getBlock();
        IVerificationPoint actionVP = this.createVerificationPoint();
        actionVP.setName("VP 1");
        actionVP.setDescription("A generic VP");
        IProperty property1 = this.createProperty();
        property1.setName("prop1");
        property1.setDescription("The frist property");
        property1.setValue("foo");
        IProperty property2 = this.createProperty();
        property2.setName("Prop2");
        property2.setDescription("The second property");
        property2.setValue("bar");
        actionVP.getActionProperties().getProperties().add(0, property1);
        actionVP.getActionProperties().getProperties().add(1, property2);
        block.getActions().add(actionVP);
        ValidateFacadeImpl.assertEquals((Object)property1, (Object)((IAction)block.getActions().get(0)).getActionProperties().getPropertyByName("prop1"));
        ValidateFacadeImpl.assertEquals((Object)property2, (Object)((IProperty)((IAction)block.getActions().get(0)).getActionProperties().getProperties().get(1)));
        this.save(testSuite);
        ITestSuite reloadedTestSuite = (ITestSuite)this.load();
        IImplementor tempImplementor = reloadedTestSuite.getImplementor();
        IAction tempAction = (IAction)tempImplementor.getBlock().getActions().get(0);
        ValidateFacadeImpl.assertEquals((String)"foo", (String)tempAction.getActionProperties().getPropertyByName("prop1").getValue());
        ValidateFacadeImpl.assertEquals((String)"bar", (String)((IProperty)tempAction.getActionProperties().getProperties().get(1)).getValue());
    }

    public void testRemoveProperties() {
        this.testAddProperties();
        ITestSuite testSuite = (ITestSuite)this.load();
        IImplementor implementor = testSuite.getImplementor();
        IBlock block = implementor.getBlock();
        IAction action = (IAction)block.getActions().get(0);
        action.getActionProperties().getProperties().remove(0);
        ValidateFacadeImpl.assertEquals((int)1, (int)action.getActionProperties().getProperties().size());
        ValidateFacadeImpl.assertEquals((String)"bar", (String)action.getActionProperties().getPropertyByName("Prop2").getValue());
        this.save(testSuite);
        ITestSuite reloadedTestSuite = (ITestSuite)this.load();
        IImplementor tempImplementor = reloadedTestSuite.getImplementor();
        IAction tempAction = (IAction)tempImplementor.getBlock().getActions().get(0);
        ValidateFacadeImpl.assertEquals((int)1, (int)tempAction.getActionProperties().getProperties().size());
        ValidateFacadeImpl.assertEquals((String)"bar", (String)tempAction.getActionProperties().getPropertyByName("Prop2").getValue());
        ValidateFacadeImpl.assertEquals((String)"bar", (String)((IProperty)tempAction.getActionProperties().getProperties().get(0)).getValue());
    }

    public void testAddExternalImplementor() {
        this.createBlankTestSuite();
        ITestSuite testSuite = (ITestSuite)this.load();
        IImplementor externalImplementor = this.createImplementor(testSuite, true);
        externalImplementor.setName("An External Implementor");
        externalImplementor.setLocation("main");
        externalImplementor.setResource("ExternalImplementor.java");
        ValidateFacadeImpl.assertEquals((boolean)true, (boolean)externalImplementor.isExternalImplementor());
        ValidateFacadeImpl.assertEquals((Object)externalImplementor, (Object)testSuite.getImplementor());
        this.save(testSuite);
        ITestSuite reloadedTestSuite = (ITestSuite)this.load();
        ValidateFacadeImpl.assertNotNull((Object)testSuite.getImplementor());
        IImplementor tempImplementor = reloadedTestSuite.getImplementor();
        ValidateFacadeImpl.assertEquals((boolean)true, (boolean)tempImplementor.isExternalImplementor());
        ValidateFacadeImpl.assertEquals((String)"main", (String)tempImplementor.getLocation());
        ValidateFacadeImpl.assertNull((Object)tempImplementor.getBlock());
    }

    public void testChangeImplementorType() {
        this.testAddExternalImplementor();
        ITestSuite testSuite = (ITestSuite)this.load();
        IImplementor modeledImplementor = this.createImplementor(testSuite, false);
        modeledImplementor.setName("An Modeled Implementor");
        modeledImplementor.setLocation("main");
        modeledImplementor.setResource("ModeledImplementor.java");
        ValidateFacadeImpl.assertEquals((boolean)false, (boolean)modeledImplementor.isExternalImplementor());
        ValidateFacadeImpl.assertEquals((Object)modeledImplementor, (Object)testSuite.getImplementor());
        this.save(testSuite);
        ITestSuite reloadedTestSuite = (ITestSuite)this.load();
        ValidateFacadeImpl.assertNotNull((Object)testSuite.getImplementor());
        IImplementor tempImplementor = reloadedTestSuite.getImplementor();
        ValidateFacadeImpl.assertEquals((boolean)false, (boolean)tempImplementor.isExternalImplementor());
        ValidateFacadeImpl.assertEquals((String)"main", (String)tempImplementor.getLocation());
        ValidateFacadeImpl.assertNotNull((Object)tempImplementor.getBlock());
        ValidateFacadeImpl.assertEquals((int)0, (int)tempImplementor.getBlock().getActions().size());
    }

    public void testAddTestCases() {
        ITestSuite testSuite = this.createBlankTestSuite();
        ITestCase testCase1 = this.createTestCase();
        testCase1.setName("TestCase1");
        testCase1.setDescription("A Test Case to test the get Method");
        ITestCase testCase2 = this.createTestCase();
        testCase2.setName("TestCase2");
        testCase2.setDescription("A Test Case to test the put Method");
        ITestCase testCase3 = this.createTestCase();
        testCase3.setName("TestCase3");
        testCase3.setDescription("A Test Case to test the get Method");
        ITestCase testCase4 = this.createTestCase();
        testCase4.setName("TestCase4");
        testCase4.setDescription("A Test Case to test the put Method");
        Vector<ITestCase> testCaseCollection = new Vector<ITestCase>();
        testCaseCollection.add(testCase3);
        testCaseCollection.add(testCase4);
        List testCases = testSuite.getITestCases();
        testCases.add(testCase1);
        testCases.add(testCase2);
        testCases.addAll(testCaseCollection);
        IImplementor tc1Implementor = this.createImplementor(testCase1, false);
        tc1Implementor.setName("TestCase1Implementor");
        tc1Implementor.setDescription("An Implementor for test case 1");
        tc1Implementor.setResource("TestCase1.java");
        tc1Implementor.setLocation("main");
        IImplementor tc2Implementor = this.createImplementor(testCase2, false);
        tc2Implementor.setName("TestCase2Implementor");
        tc2Implementor.setDescription("An Implementor for test case 2");
        tc2Implementor.setResource("TestCase2.java");
        tc2Implementor.setLocation("main");
        ISystemUnderTest systemUnderTest = this.createSystemUnderTest();
        systemUnderTest.setName("SUT1");
        systemUnderTest.setDescription("A system under test");
        systemUnderTest.setResource("SystemUnderTest1.java");
        systemUnderTest.setLocation("main");
        List systemsUnderTest = testSuite.getISystemsUnderTest();
        systemsUnderTest.add(systemUnderTest);
        IBlock block1 = tc1Implementor.getBlock();
        List tc1Actions = block1.getActions();
        IBlock block2 = tc2Implementor.getBlock();
        List tc2Actions = block2.getActions();
        IMethod method1 = this.createMethod();
        method1.setName("method1");
        method1.setDescription("The first method");
        systemUnderTest.getMethods().add(method1);
        IMethod method2 = this.createMethod();
        method2.setName("method2");
        method2.setDescription("The second method");
        systemUnderTest.getMethods().add(method2);
        ITargetInvocation method1TargetInvocation = this.createTargetInvocation(method1);
        method1TargetInvocation.setName("Invocation of method1");
        method1TargetInvocation.setDescription("A invocation of the first method");
        ITargetInvocation method2TargetInvocation = this.createTargetInvocation(method2);
        method2TargetInvocation.setName("Invocation of method2");
        method2TargetInvocation.setDescription("A invocation of the second method");
        tc1Actions.add(method1TargetInvocation);
        tc2Actions.add(method2TargetInvocation);
        ValidateFacadeImpl.assertEquals((int)4, (int)testSuite.getITestCases().size());
        ValidateFacadeImpl.assertEquals((int)1, (int)testSuite.getISystemsUnderTest().size());
        ValidateFacadeImpl.assertEquals((Object)testCase1, (Object)((ITestCase)testSuite.getITestCases().get(0)));
        ValidateFacadeImpl.assertEquals((Object)testCase2, (Object)((ITestCase)testSuite.getITestCases().get(1)));
        ValidateFacadeImpl.assertEquals((Object)testCase3, (Object)((ITestCase)testSuite.getITestCases().get(2)));
        ValidateFacadeImpl.assertEquals((Object)testCase4, (Object)((ITestCase)testSuite.getITestCases().get(3)));
        ValidateFacadeImpl.assertEquals((Object)systemUnderTest, (Object)((ISystemUnderTest)testSuite.getISystemsUnderTest().get(0)));
        ValidateFacadeImpl.assertEquals((Object)tc1Implementor, (Object)((ITestCase)testSuite.getITestCases().get(0)).getImplementor());
        ValidateFacadeImpl.assertEquals((Object)tc2Implementor, (Object)((ITestCase)testSuite.getITestCases().get(1)).getImplementor());
        ValidateFacadeImpl.assertEquals((int)2, (int)((ISystemUnderTest)testSuite.getISystemsUnderTest().get(0)).getMethods().size());
        ValidateFacadeImpl.assertEquals((Object)method1, (Object)((IMethod)((ISystemUnderTest)testSuite.getISystemsUnderTest().get(0)).getMethods().get(0)));
        ValidateFacadeImpl.assertEquals((Object)method2, (Object)((IMethod)((ISystemUnderTest)testSuite.getISystemsUnderTest().get(0)).getMethods().get(1)));
        ValidateFacadeImpl.assertEquals((int)1, (int)((ITestCase)testSuite.getITestCases().get(0)).getImplementor().getBlock().getActions().size());
        ValidateFacadeImpl.assertEquals((int)1, (int)((ITestCase)testSuite.getITestCases().get(1)).getImplementor().getBlock().getActions().size());
        ValidateFacadeImpl.assertEquals((Object)method1TargetInvocation, (Object)((ITargetInvocation)((ITestCase)testSuite.getITestCases().get(0)).getImplementor().getBlock().getActions().get(0)));
        ValidateFacadeImpl.assertEquals((Object)method2TargetInvocation, (Object)((ITargetInvocation)((ITestCase)testSuite.getITestCases().get(1)).getImplementor().getBlock().getActions().get(0)));
        this.save(testSuite);
        ITestSuite reloadedTestSuite = (ITestSuite)this.load();
        ValidateFacadeImpl.assertEquals((int)4, (int)reloadedTestSuite.getITestCases().size());
        ValidateFacadeImpl.assertEquals((int)1, (int)reloadedTestSuite.getISystemsUnderTest().size());
        ITestCase tempTestCase1 = (ITestCase)testSuite.getITestCases().get(0);
        ITestCase tempTestCase2 = (ITestCase)testSuite.getITestCases().get(1);
        ITestCase tempTestCase3 = (ITestCase)testSuite.getITestCases().get(2);
        ITestCase tempTestCase4 = (ITestCase)testSuite.getITestCases().get(3);
        ValidateFacadeImpl.assertEquals((String)"TestCase1", (String)tempTestCase1.getName());
        ValidateFacadeImpl.assertEquals((String)"TestCase2", (String)tempTestCase2.getName());
        ValidateFacadeImpl.assertEquals((String)"TestCase3", (String)tempTestCase3.getName());
        ValidateFacadeImpl.assertEquals((String)"TestCase4", (String)tempTestCase4.getName());
        ValidateFacadeImpl.assertEquals((String)"TestCase1Implementor", (String)tempTestCase1.getImplementor().getName());
        ValidateFacadeImpl.assertEquals((String)"TestCase2Implementor", (String)tempTestCase2.getImplementor().getName());
        ValidateFacadeImpl.assertEquals((int)1, (int)tempTestCase1.getImplementor().getBlock().getActions().size());
        ValidateFacadeImpl.assertEquals((int)1, (int)tempTestCase2.getImplementor().getBlock().getActions().size());
        ITargetInvocation tempM1TargetInvocation = (ITargetInvocation)tempTestCase1.getImplementor().getBlock().getActions().get(0);
        ITargetInvocation tempM2TargetInvocation = (ITargetInvocation)tempTestCase2.getImplementor().getBlock().getActions().get(0);
        ValidateFacadeImpl.assertEquals((String)"Invocation of method1", (String)tempM1TargetInvocation.getName());
        ValidateFacadeImpl.assertEquals((String)"Invocation of method2", (String)tempM2TargetInvocation.getName());
        ValidateFacadeImpl.assertEquals((String)"SUT1", (String)tempM1TargetInvocation.getTarget().getName());
        ValidateFacadeImpl.assertEquals((String)"SUT1", (String)tempM2TargetInvocation.getTarget().getName());
        ISystemUnderTest tempSystemUnderTest = (ISystemUnderTest)reloadedTestSuite.getISystemsUnderTest().get(0);
        ValidateFacadeImpl.assertEquals((int)2, (int)tempSystemUnderTest.getMethods().size());
        ValidateFacadeImpl.assertEquals((String)"method1", (String)((IMethod)tempSystemUnderTest.getMethods().get(0)).getName());
        ValidateFacadeImpl.assertEquals((String)"method2", (String)((IMethod)tempSystemUnderTest.getMethods().get(1)).getName());
    }

    public void testRemoveTestCases() {
        this.testAddTestCases();
        ITestSuite testSuite = (ITestSuite)this.load();
        testSuite.getITestCases().remove(0);
        ValidateFacadeImpl.assertEquals((int)3, (int)testSuite.getITestCases().size());
        ValidateFacadeImpl.assertEquals((int)1, (int)testSuite.getISystemsUnderTest().size());
        ITestCase tempTestCase1 = (ITestCase)testSuite.getITestCases().get(0);
        ValidateFacadeImpl.assertEquals((String)"TestCase2", (String)tempTestCase1.getName());
        ValidateFacadeImpl.assertEquals((String)"TestCase2Implementor", (String)tempTestCase1.getImplementor().getName());
        ValidateFacadeImpl.assertEquals((int)1, (int)tempTestCase1.getImplementor().getBlock().getActions().size());
        ITargetInvocation tempM1TargetInvocation = (ITargetInvocation)tempTestCase1.getImplementor().getBlock().getActions().get(0);
        ValidateFacadeImpl.assertEquals((String)"Invocation of method2", (String)tempM1TargetInvocation.getName());
        ValidateFacadeImpl.assertEquals((String)"SUT1", (String)tempM1TargetInvocation.getTarget().getName());
        ISystemUnderTest tempSystemUnderTest = (ISystemUnderTest)testSuite.getISystemsUnderTest().get(0);
        ValidateFacadeImpl.assertEquals((int)2, (int)tempSystemUnderTest.getMethods().size());
        ValidateFacadeImpl.assertEquals((String)"method1", (String)((IMethod)tempSystemUnderTest.getMethods().get(0)).getName());
        ValidateFacadeImpl.assertEquals((String)"method2", (String)((IMethod)tempSystemUnderTest.getMethods().get(1)).getName());
        Vector testCaseCollection = new Vector();
        testCaseCollection.add(testSuite.getITestCases().get(1));
        testCaseCollection.add(testSuite.getITestCases().get(2));
        testSuite.getITestCases().removeAll(testCaseCollection);
        ValidateFacadeImpl.assertEquals((int)1, (int)testSuite.getITestCases().size());
        this.save(testSuite);
        ITestSuite reloadedTestSuite = (ITestSuite)this.load();
        ValidateFacadeImpl.assertEquals((int)1, (int)reloadedTestSuite.getITestCases().size());
        ValidateFacadeImpl.assertEquals((int)1, (int)reloadedTestSuite.getISystemsUnderTest().size());
        tempTestCase1 = (ITestCase)reloadedTestSuite.getITestCases().get(0);
        ValidateFacadeImpl.assertEquals((String)"TestCase2", (String)tempTestCase1.getName());
        ValidateFacadeImpl.assertEquals((String)"TestCase2Implementor", (String)tempTestCase1.getImplementor().getName());
        ValidateFacadeImpl.assertEquals((int)1, (int)tempTestCase1.getImplementor().getBlock().getActions().size());
        tempM1TargetInvocation = (ITargetInvocation)tempTestCase1.getImplementor().getBlock().getActions().get(0);
        ValidateFacadeImpl.assertEquals((String)"Invocation of method2", (String)tempM1TargetInvocation.getName());
        ValidateFacadeImpl.assertEquals((String)"SUT1", (String)tempM1TargetInvocation.getTarget().getName());
        tempSystemUnderTest = (ISystemUnderTest)reloadedTestSuite.getISystemsUnderTest().get(0);
        ValidateFacadeImpl.assertEquals((int)2, (int)tempSystemUnderTest.getMethods().size());
        ValidateFacadeImpl.assertEquals((String)"method1", (String)((IMethod)tempSystemUnderTest.getMethods().get(0)).getName());
        ValidateFacadeImpl.assertEquals((String)"method2", (String)((IMethod)tempSystemUnderTest.getMethods().get(1)).getName());
    }

    public void testAddMethod() {
        this.createSimpleTestSuite();
        ITestSuite testSuite = (ITestSuite)this.load();
        IImplementor implementor = testSuite.getImplementor();
        IBlock block = implementor.getBlock();
        ISystemUnderTest systemUnderTest = (ISystemUnderTest)testSuite.getISystemsUnderTest().get(0);
        systemUnderTest.setDescription("An SUT with operations");
        systemUnderTest.setLocation("main");
        IMethod method = this.createMethod();
        method.setName("method1");
        method.setDescription("Pick me!  Pick me!!");
        systemUnderTest.getMethods().add(method);
        ValidateFacadeImpl.assertEquals((Object)method, (Object)((IMethod)systemUnderTest.getMethods().get(0)));
        this.save(testSuite);
        ITestSuite reloadedTestSuite = (ITestSuite)this.load();
        ValidateFacadeImpl.assertEquals((int)1, (int)reloadedTestSuite.getISystemsUnderTest().size());
        ISystemUnderTest tempSystemUnderTest = (ISystemUnderTest)reloadedTestSuite.getISystemsUnderTest().get(0);
        ValidateFacadeImpl.assertEquals((int)1, (int)tempSystemUnderTest.getMethods().size());
        IMethod tempMethod = (IMethod)tempSystemUnderTest.getMethods().get(0);
        ValidateFacadeImpl.assertEquals((String)"method1", (String)tempMethod.getName());
    }

    public void testRemoveMethod() {
        ITestSuite testSuite = this.createSimpleTestSuite();
        this.testAddMethod();
        testSuite = (ITestSuite)this.load();
        ISystemUnderTest systemUnderTest = (ISystemUnderTest)testSuite.getISystemsUnderTest().get(0);
        systemUnderTest.getMethods().remove(0);
        ValidateFacadeImpl.assertEquals((int)0, (int)systemUnderTest.getMethods().size());
        this.save(testSuite);
        ITestSuite reloadedTestSuite = (ITestSuite)this.load();
        ValidateFacadeImpl.assertEquals((int)1, (int)reloadedTestSuite.getISystemsUnderTest().size());
        ISystemUnderTest tempSystemUnderTest = (ISystemUnderTest)reloadedTestSuite.getISystemsUnderTest().get(0);
        ValidateFacadeImpl.assertEquals((int)0, (int)tempSystemUnderTest.getMethods().size());
    }

    public void testGetObjectByID() {
        this.createSimpleTestSuite();
        ITestSuite testSuite = (ITestSuite)this.load();
        ISystemUnderTest systemUnderTest = this.createSystemUnderTest();
        systemUnderTest.setName("System Under Test 2");
        systemUnderTest.setDescription("A generic system under test");
        systemUnderTest.setLocation("");
        systemUnderTest.setResource("C:\\temp\\systemUnderTest2.java");
        String sutID = systemUnderTest.getId();
        ValidateFacadeImpl.assertNull((Object)HyadesFactory.INSTANCE.getObjectByID(testSuite, sutID));
        testSuite.getISystemsUnderTest().add(systemUnderTest);
        ValidateFacadeImpl.assertEquals((Object)systemUnderTest, (Object)HyadesFactory.INSTANCE.getObjectByID(testSuite, sutID));
        this.save(testSuite);
        ITestSuite reloadedTestSuite = (ITestSuite)this.load();
        ValidateFacadeImpl.assertEquals((String)"System Under Test 2", (String)((ISystemUnderTest)HyadesFactory.INSTANCE.getObjectByID(reloadedTestSuite, sutID)).getName());
        TPFTestSuiteImpl externalTestSuite = (TPFTestSuiteImpl)Common_TestprofileFactory.eINSTANCE.createTPFTestSuite();
        externalTestSuite.setName("External Test Suite");
        TPFBehaviorImpl externalBehavior = (TPFBehaviorImpl)Common_TestprofileFactory.eINSTANCE.createTPFBehavior();
        externalBehavior.setName(externalTestSuite.getName() + "_behavior");
        externalTestSuite.setBehavior(externalBehavior);
        String behaviorID = externalBehavior.getId();
        this.suite2Resource.getContents().add((Object)externalTestSuite);
        this.save(externalTestSuite);
        testSuite.getIReferencedSuites().add(externalTestSuite);
        this.save(testSuite);
        reloadedTestSuite = (ITestSuite)this.load();
        ValidateFacadeImpl.assertEquals((String)"System Under Test 2", (String)((ISystemUnderTest)HyadesFactory.INSTANCE.getObjectByID(reloadedTestSuite, sutID)).getName());
        ValidateFacadeImpl.assertEquals((String)"External Test Suite_behavior", (String)((IImplementor)HyadesFactory.INSTANCE.getObjectByID(reloadedTestSuite, behaviorID)).getName());
    }

    public void testGetTestSuiteFromObject() {
        this.createSimpleTestSuite();
        ITestSuite testSuite = (ITestSuite)this.load();
        Object object = testSuite.getITestCases().get(0);
        ITestSuite returnedTestSuite = HyadesFactory.INSTANCE.getTestSuiteFromObject(object);
        ValidateFacadeImpl.assertEquals((Object)testSuite, (Object)returnedTestSuite);
        object = new Object();
        try {
            returnedTestSuite = HyadesFactory.INSTANCE.getTestSuiteFromObject(object);
            ValidateFacadeImpl.assertTrue((boolean)false);
        }
        catch (Exception e) {
            ValidateFacadeImpl.assertTrue((boolean)(e instanceof IllegalArgumentException));
        }
        object = this.createSystemUnderTest();
        returnedTestSuite = HyadesFactory.INSTANCE.getTestSuiteFromObject(object);
        ValidateFacadeImpl.assertEquals(null, (Object)returnedTestSuite);
    }

    public void testAddTestInvocationException() {
        this.createSimpleTestSuite();
        ITestSuite testSuite = (ITestSuite)this.load();
        IImplementor implementor = testSuite.getImplementor();
        IBlock block = implementor.getBlock();
        ITestSuite testSuite2 = this.createTestSuite(this.suite2Resource);
        testSuite2.setName("Invokable Test Suite");
        testSuite2.setDescription("A TestSuite to be invoked");
        this.save(testSuite2);
        ITestInvocation testInvocation = null;
        try {
            testInvocation = this.createTestInvocation(testSuite2);
            ValidateFacadeImpl.assertTrue((boolean)false);
        }
        catch (Exception e) {
            ValidateFacadeImpl.assertTrue((boolean)(e instanceof IllegalArgumentException));
            ValidateFacadeImpl.assertEquals((String)"Invoked test must have an implementor.", (String)e.getMessage());
        }
    }

    public void testAddMethodToTest() {
        this.createSimpleTestSuite();
        ITestSuite testSuite = (ITestSuite)this.load();
        IImplementor implementor = testSuite.getImplementor();
        ValidateFacadeImpl.assertNotNull((Object)implementor.getMethods());
        ValidateFacadeImpl.assertEquals((int)0, (int)implementor.getMethods().size());
        IBlock block = implementor.getBlock();
        ISystemUnderTest systemUnderTest = (ISystemUnderTest)testSuite.getISystemsUnderTest().get(0);
        systemUnderTest.setDescription("An SUT with operations");
        systemUnderTest.setLocation("main");
        IMethod method1 = this.createMethod();
        method1.setName("method1");
        method1.setDescription("Pick me!  Pick me!!");
        systemUnderTest.getMethods().add(method1);
        IMethod method2 = this.createMethod();
        method2.setName("method2");
        method2.setDescription("Pick me!  Pick me!!");
        ITargetInvocation targetInvocation = this.createTargetInvocation(method1);
        targetInvocation.setName("Target Invocation 1");
        targetInvocation.setDescription("A simple target invocation");
        targetInvocation.setSynchronous(true);
        block.getActions().add(0, targetInvocation);
        ValidateFacadeImpl.assertEquals((int)0, (int)implementor.getMethods().size());
        implementor.getMethods().add(method2);
        ValidateFacadeImpl.assertEquals((int)1, (int)implementor.getMethods().size());
        ValidateFacadeImpl.assertEquals((Object)method2, implementor.getMethods().get(0));
        this.save(testSuite);
        ITestSuite reloadedTestSuite = (ITestSuite)this.load();
        ValidateFacadeImpl.assertEquals((int)1, (int)reloadedTestSuite.getImplementor().getMethods().size());
        ValidateFacadeImpl.assertEquals((String)"method2", (String)((IMethod)reloadedTestSuite.getImplementor().getMethods().get(0)).getName());
    }

    public void testTestComponentCreation() {
        ITestSuite testSuite = this.createTestSuite(this.suite1Resource);
        IImplementor implementor = this.createImplementor(testSuite, false);
        implementor.setName("Test Driver 1");
        implementor.setDescription("A test driver");
        implementor.setLocation("main");
        implementor.setResource("C:\\temp\\testDriver1.java");
        ITestComponent testComponent = this.createTestComponent(testSuite);
        testComponent.setName("Test Component 1");
        testComponent.setDescription("A sample test component");
        IImplementor testComponentImplementor = this.createImplementor(testComponent, "implementor1", false);
        testSuite.setName("Test Suite 1");
        testSuite.setDescription("A simple Test Suite with one of everythiing");
        testSuite.getITestComponents().add(0, testComponent);
        ValidateFacadeImpl.assertEquals((String)"Test Suite 1", (String)testSuite.getName());
        ValidateFacadeImpl.assertEquals((String)"A simple Test Suite with one of everythiing", (String)testSuite.getDescription());
        ValidateFacadeImpl.assertEquals((Object)testComponent, testSuite.getITestComponents().get(0));
        ValidateFacadeImpl.assertEquals((Object)implementor, (Object)testSuite.getImplementor());
        this.save(testSuite);
        ITestSuite reloadedTestSuite = (ITestSuite)this.load();
        ValidateFacadeImpl.assertEquals((String)"Test Suite 1", (String)reloadedTestSuite.getName());
        ValidateFacadeImpl.assertEquals((String)"A simple Test Suite with one of everythiing", (String)reloadedTestSuite.getDescription());
        ValidateFacadeImpl.assertEquals((String)"Test Component 1", (String)((ITestComponent)reloadedTestSuite.getITestComponents().get(0)).getName());
        ValidateFacadeImpl.assertEquals((String)"A sample test component", (String)((ITestComponent)reloadedTestSuite.getITestComponents().get(0)).getDescription());
        ValidateFacadeImpl.assertEquals((Object)reloadedTestSuite, (Object)((ITestComponent)reloadedTestSuite.getITestComponents().get(0)).getOwner());
        ValidateFacadeImpl.assertEquals((String)"Test Driver 1", (String)reloadedTestSuite.getImplementor().getName());
        ValidateFacadeImpl.assertEquals((String)"A test driver", (String)reloadedTestSuite.getImplementor().getDescription());
        ValidateFacadeImpl.assertEquals((String)"C:\\temp\\testDriver1.java", (String)reloadedTestSuite.getImplementor().getResource());
        ValidateFacadeImpl.assertEquals((String)"main", (String)reloadedTestSuite.getImplementor().getLocation());
        ValidateFacadeImpl.assertEquals((Object)reloadedTestSuite, (Object)reloadedTestSuite.getImplementor().getOwner());
    }

    public void testTestComponentBehaviorRemoval() {
        ITestSuite testSuite = this.createTestSuite(this.suite1Resource);
        IImplementor implementor = this.createImplementor(testSuite, false);
        implementor.setName("Test Driver 1");
        implementor.setDescription("A test driver");
        implementor.setLocation("main");
        implementor.setResource("C:\\temp\\testDriver1.java");
        ITestComponent testComponent = this.createTestComponent(testSuite);
        testComponent.setName("Test Component 1");
        testComponent.setDescription("A sample test component");
        IImplementor testComponentImplementor = this.createImplementor(testComponent, "implementor1", false);
        IImplementor testComponentImplementor2 = this.createImplementor(testComponent, "implementor2", false);
        testSuite.setName("Test Suite 1");
        testSuite.setDescription("A simple Test Suite with one of everythiing");
        testSuite.getITestComponents().add(0, testComponent);
        this.save(testSuite);
        ITestSuite reloadedTestSuite = (ITestSuite)this.load();
        testComponent.getImplementors().remove(1);
        this.save(testSuite);
        reloadedTestSuite = (ITestSuite)this.load();
    }

    public void testTestComponentInvocation() {
        ITestSuite testSuite = this.createTestSuite(this.suite1Resource);
        IImplementor implementor = this.createImplementor(testSuite, false);
        implementor.setName("Test Driver 1");
        implementor.setDescription("A test driver");
        implementor.setLocation("main");
        implementor.setResource("C:\\temp\\testDriver1.java");
        ITestComponent testComponent = this.createTestComponent(testSuite);
        testComponent.setName("Stub 1");
        testComponent.setDescription("A sample stub");
        IImplementor testComponentImplementor = this.createImplementor(testComponent, "implementor1", false);
        IBlock componentBlock = testComponentImplementor.getBlock();
        testSuite.setName("Test Suite 1");
        testSuite.setDescription("A simple Test Suite with one of everythiing");
        testSuite.getITestComponents().add(0, testComponent);
        IBlock block = implementor.getBlock();
        List actions = block.getActions();
        ITestComponentInvocation invocation = this.createTestComponentInvocation(testComponent, "implementor1");
        actions.add(invocation);
        this.save(testSuite);
    }

    public void testPutAnnotations() {
        ITestSuite testSuite = this.createSimpleTestSuite();
        IImplementor implementor = testSuite.getImplementor();
        IBlock block = implementor.getBlock();
        List actions = block.getActions();
        ITestInvocation invocation = this.createTestInvocation(testSuite);
        actions.add(invocation);
        File attachment1 = null;
        File attachment2 = null;
        try {
            attachment1 = File.createTempFile("firstAttachment", ".jpg");
            attachment2 = File.createTempFile("secondAttachment", ".bmp");
        }
        catch (IOException ex) {
            ValidateFacadeImpl.fail((String)"Unable to create temporary files for attachements");
        }
        URI uri1 = URI.createFileURI((String)attachment1.getAbsolutePath());
        URI uri2 = URI.createFileURI((String)attachment2.getAbsolutePath());
        IAnnotation annotation1 = HyadesFactory.INSTANCE.createAnnotation();
        IAnnotation annotation2 = HyadesFactory.INSTANCE.createAnnotation();
        List annotations = invocation.getActionAnnotations();
        annotations.add(annotation1);
        annotations.add(annotation2);
        try {
            annotation1.putFileAnnotation(uri1);
            annotation2.putFileAnnotation(uri2);
            this.save(testSuite);
            this.suite1Resource.unload();
        }
        catch (IOException ex) {
            ValidateFacadeImpl.fail((String)("Unable to put uris " + uri1.toFileString() + " and " + uri2.toFileString() + " into annotations " + annotation1.toString() + " and " + annotation2.toString()));
        }
    }

    public void testGetAnnotations() {
        ITestSuite testSuite = (ITestSuite)this.load();
        IImplementor implementor = testSuite.getImplementor();
        ITestInvocation invocation = (ITestInvocation)implementor.getBlock().getActions().get(0);
        List annotations = invocation.getActionAnnotations();
        IAnnotation annotation = (IAnnotation)annotations.get(0);
        try {
            URI uri = annotation.getFileAnnotation();
            File file = new File(uri.toFileString());
            ValidateFacadeImpl.assertTrue((String)("Annotation file does not exist " + file.getAbsolutePath()), (boolean)file.exists());
        }
        catch (Exception ex) {
            ValidateFacadeImpl.fail((String)ex.toString());
        }
        this.suite1Resource.unload();
    }

    public void testRemoveAnnotations() {
        ITestSuite testSuite = this.createSimpleTestSuite();
        IImplementor implementor = testSuite.getImplementor();
        IBlock block = implementor.getBlock();
        List actions = block.getActions();
        ITestInvocation invocation = this.createTestInvocation(testSuite);
        actions.add(invocation);
        File attachment1 = null;
        File attachment2 = null;
        try {
            attachment1 = File.createTempFile("firstAttachment", ".jpg");
            attachment2 = File.createTempFile("secondAttachment", ".bmp");
        }
        catch (IOException ex) {
            ValidateFacadeImpl.fail((String)"Unable to create temporary files for attachements");
        }
        URI uri1 = URI.createFileURI((String)attachment1.getAbsolutePath());
        URI uri2 = URI.createFileURI((String)attachment2.getAbsolutePath());
        IAnnotation annotation1 = HyadesFactory.INSTANCE.createAnnotation();
        IAnnotation annotation2 = HyadesFactory.INSTANCE.createAnnotation();
        List annotations = invocation.getActionAnnotations();
        annotations.add(annotation1);
        annotations.add(annotation2);
        try {
            annotation1.putFileAnnotation(uri1);
            annotation2.putFileAnnotation(uri2);
            uri1 = annotation1.getFileAnnotation();
            File attachedFile1 = new File(uri1.toFileString());
            uri2 = annotation2.getFileAnnotation();
            File attachedFile2 = new File(uri2.toFileString());
            ValidateFacadeImpl.assertTrue((String)"AttachedFile1 was not successfully added to test suite", (boolean)attachedFile1.exists());
            annotation1.removeFileAnnotation();
            ValidateFacadeImpl.assertTrue((String)"AttachedFile1 was not successfully removed from test suite", (!attachedFile1.exists() ? 1 : 0) != 0);
            annotation2.removeFileAnnotation();
            ValidateFacadeImpl.assertTrue((String)"AttachedFile2 was not successfully removed from test suite", (!attachedFile2.exists() ? 1 : 0) != 0);
            ValidateFacadeImpl.assertTrue((String)"Object's annotation dir not successfully removed from resource's annotation dir", (!attachedFile2.getParentFile().exists() ? 1 : 0) != 0);
            annotations.remove(annotation1);
            annotations.remove(annotation2);
            ValidateFacadeImpl.assertTrue((String)"Annotations collection not emptied", (boolean)invocation.getActionAnnotations().isEmpty());
            this.save(testSuite);
            this.suite1Resource.unload();
        }
        catch (IOException ex) {
            ValidateFacadeImpl.fail((String)("Unable to put uris " + uri1.toFileString() + " and " + uri2.toFileString() + " into annotations " + annotation1.toString() + " and " + annotation2.toString()));
        }
    }

    private ITestSuite createBlankTestSuite() {
        ITestSuite testSuite = this.createTestSuite(this.suite1Resource);
        testSuite.setName("Test Suite 1");
        testSuite.setDescription("A simple Test Suite with one of everythiing");
        this.save(testSuite);
        return testSuite;
    }

    private ITestSuite createSimpleTestSuite() {
        ITestSuite testSuite = this.createTestSuite(this.suite1Resource);
        ITestCase testCase = this.createTestCase();
        testCase.setName("Test Case 1");
        testCase.setDescription("A simple test case");
        IImplementor implementor = this.createImplementor(testSuite, false);
        implementor.setName("Test Driver 1");
        implementor.setDescription("A test driver");
        implementor.setLocation("main");
        implementor.setResource("C:\\temp\\testDriver1.java");
        ISystemUnderTest systemUnderTest = this.createSystemUnderTest();
        systemUnderTest.setName("System Under Test 1");
        systemUnderTest.setDescription("A generic system under test");
        systemUnderTest.setLocation("");
        systemUnderTest.setResource("C:\\temp\\systemUnderTest1.java");
        ITestComponent testComponent = this.createTestComponent(testSuite);
        testComponent.setName("Test Component 1");
        testComponent.setDescription("A sample test component");
        IImplementor testComponentImplementor = this.createImplementor(testComponent, "implementor1", false);
        testSuite.setName("Test Suite 1");
        testSuite.setDescription("A simple Test Suite with one of everythiing");
        testSuite.getITestCases().add(0, testCase);
        testSuite.getISystemsUnderTest().add(0, systemUnderTest);
        testSuite.getITestComponents().add(0, testComponent);
        this.save(testSuite);
        return testSuite;
    }

    private ITestSuite createTestSuite(Resource resource) {
        return HyadesFactory.INSTANCE.createTestSuite(resource);
    }

    private ITestCase createTestCase() {
        return HyadesFactory.INSTANCE.createTestCase();
    }

    private IImplementor createImplementor(ITest implementedTest, boolean isExternalImplementor) {
        return HyadesFactory.INSTANCE.createImplementor(implementedTest, isExternalImplementor);
    }

    private IImplementor createImplementor(ITestComponent testComponent, String implementorName, boolean isExternalImplementor) {
        return HyadesFactory.INSTANCE.createImplementor(testComponent, implementorName, isExternalImplementor);
    }

    private ITestComponent createTestComponent(ITest implementedTest) {
        return HyadesFactory.INSTANCE.createTestComponent();
    }

    private ISystemUnderTest createSystemUnderTest() {
        return HyadesFactory.INSTANCE.createSystemUnderTest();
    }

    private IDecision createDecision() {
        return HyadesFactory.INSTANCE.createDecision();
    }

    private ILoop createLoop() {
        return HyadesFactory.INSTANCE.createLoop();
    }

    private IVerificationPoint createVerificationPoint() {
        return HyadesFactory.INSTANCE.createVerificationPoint();
    }

    private ITargetInvocation createTargetInvocation(IMethod method) {
        return HyadesFactory.INSTANCE.createTargetInvocation(method);
    }

    private ITestInvocation createTestInvocation(ITest test) {
        return HyadesFactory.INSTANCE.createTestInvocation(test);
    }

    private ITestComponentInvocation createTestComponentInvocation(ITestComponent testComponent, String implementorName) {
        return HyadesFactory.INSTANCE.createTestComponentInvocation(testComponent, implementorName);
    }

    private IMethod createMethod() {
        return HyadesFactory.INSTANCE.createMethod();
    }

    private IProperty createProperty() {
        return HyadesFactory.INSTANCE.createProperty();
    }

    private void save(Object obj) {
        if (obj instanceof EObject) {
            try {
                ((EObject)obj).eResource().save(Collections.EMPTY_MAP);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private Object load() {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        this.suite1Resource = resourceSet.getResource(URI.createURI((String)this.xmiFile), true);
        return this.suite1Resource.getContents().get(0);
    }
}

