/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.eclipse.hyades.logging.adapter.Adapter;
import org.eclipse.hyades.logging.adapter.AdapterException;
import org.eclipse.hyades.logging.adapter.config.AdapterConfigPlugin;
import org.eclipse.hyades.logging.adapter.util.Messages;
import org.eclipse.hyades.logging.core.SerializationException;
import org.eclipse.hyades.logging.core.XmlUtility;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.parsers.LogParserException;
import org.eclipse.hyades.logging.parsers.Parser;
import org.eclipse.hyades.logging.parsers.ParserUtilities;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class StaticParserWrapper
extends Parser {
    private Adapter adapter;
    private String parserName;
    private String agentName;
    private String key = String.valueOf(System.currentTimeMillis());
    private String originalConfigFile = null;
    protected String newDirectory = null;
    protected String newFileName = null;
    protected String currentPlugin = "org.eclipse.hyades.logging.adapter.config";
    private static Hashtable activeWrappers = new Hashtable();

    public StaticParserWrapper() {
        this.adapter = new Adapter();
        this.parserName = new String(Messages.getString((String)"HyadesGAUnknownNameTag"));
        this.agentName = new String(Messages.getString((String)"HyadesGAUnknownNameTag"));
    }

    public static Log getLogInstance(String logKey) {
        return (Log)activeWrappers.remove(logKey);
    }

    public void parse(Log argLogger) throws LogParserException {
        try {
            activeWrappers.put(this.key, argLogger);
            this.adapter.start(false, false);
        }
        catch (AdapterException e) {
            String errMessage = e.getLocalizedMessage();
            if (errMessage.indexOf("IWAT0375E") != -1 || errMessage.indexOf("IWAT0376E") != -1) {
                throw new LogParserException(ParserUtilities.getResourceString((String)"LOG_PARSER_INVALID_FILE_NAME_ERROR_", (String)this.file_path));
            }
            throw new LogParserException((Throwable)e);
        }
    }

    public void setUserInput(Hashtable table) throws LogParserException {
        table.put("loggerKey", this.key);
        String newConfigFile = this.getNewConfigFile(table);
        this.adapter.setContextConfigPath(newConfigFile);
        this.adapter.setComponentConfigPath(newConfigFile);
    }

    public String getName() {
        return this.agentName;
    }

    public CommonBaseEvent[] parseNext() throws LogParserException {
        return null;
    }

    public String getVersion() {
        return null;
    }

    private InputStream getConfigInputStream(String fileName, Hashtable table) throws LogParserException {
        String fileSeparator = System.getProperty("file.separator");
        try {
            if (fileName.indexOf(47) != -1 && fileSeparator != "/") {
                fileName = fileName.replace('/', fileSeparator.charAt(0));
            }
            if (fileName.startsWith("." + fileSeparator)) {
                fileName = fileName.substring(2);
            }
            return new FileInputStream(fileName);
        }
        catch (FileNotFoundException exc) {
            String fileName2 = (String)table.get(Messages.getString((String)"HyadesGAConfigFileRootAttributeName")) + fileSeparator + fileName;
            try {
                this.originalConfigFile = fileName2;
                return new FileInputStream(fileName2);
            }
            catch (FileNotFoundException exc2) {
                String config_paths = (String)table.get("config_path");
                if (config_paths != null && config_paths.length() != 0) {
                    StringTokenizer strtok = new StringTokenizer(config_paths, File.pathSeparator, false);
                    while (strtok.hasMoreTokens()) {
                        String config_path = strtok.nextToken();
                        File f = new File(config_path, fileName);
                        if (!f.exists()) continue;
                        try {
                            table.remove("config_path");
                            this.originalConfigFile = f.getAbsolutePath();
                            return new FileInputStream(f.getAbsolutePath());
                        }
                        catch (FileNotFoundException e) {
                        }
                    }
                }
                throw new LogParserException(Messages.getString((String)"HyadesGA_CBE_Adapter_No_Config_File_ERROR_", (String)fileName));
            }
            catch (SecurityException exc2) {
                throw new LogParserException(Messages.getString((String)"HyadesGA_CBE_Adapter_Config_File_Open_ERROR_", (String)fileName));
            }
        }
        catch (SecurityException exc) {
            throw new LogParserException(Messages.getString((String)"HyadesGA_CBE_Adapter_Config_File_Open_ERROR_", (String)fileName));
        }
    }

    /*
     * WARNING - void declaration
     */
    private String getNewConfigFile(Hashtable table) throws LogParserException {
        void var7_31;
        File adapterFile;
        Document doc = null;
        String version = (String)table.get(Messages.getString((String)"HyadesGALogVersionTagName"));
        String config_file = null;
        if (version == null) {
            version = Messages.getString((String)"HyadesGADefaultLogVersionTagName");
        }
        if ((config_file = (String)table.get(version)) == null && (config_file = (String)table.get(Messages.getString((String)"HyadesGADefaultLogVersionTagName"))) == null) {
            throw new LogParserException(Messages.getString((String)"HyadesGA_CBE_Adapter_No_Config_File_ERROR_"));
        }
        InputStream inStream = null;
        String configFileDirectory = null;
        this.originalConfigFile = config_file;
        try {
            Boolean append = Boolean.TRUE;
            Class<?> pathClass = Class.forName("org.eclipse.core.runtime.Path");
            Constructor<?> pathConstructor = pathClass.getConstructor(config_file.getClass());
            Object path = pathConstructor.newInstance(config_file);
            Class<?> platformClass = Class.forName("org.eclipse.core.runtime.Platform");
            Class<?> pluginClass = Class.forName("org.eclipse.core.runtime.Plugin");
            Object plugin = platformClass.getMethod("getPlugin", this.currentPlugin.getClass()).invoke(null, this.currentPlugin);
            inStream = (InputStream)pluginClass.getMethod("openStream", Class.forName("org.eclipse.core.runtime.IPath"), Boolean.TYPE).invoke(plugin, path, append);
            URL url = (URL)pluginClass.getMethod("find", Class.forName("org.eclipse.core.runtime.IPath")).invoke(plugin, path);
            adapterFile = new File(((URL)platformClass.getMethod("asLocalURL", url.getClass()).invoke(null, url)).getFile());
            configFileDirectory = adapterFile.getParent();
        }
        catch (ClassNotFoundException e) {
            inStream = this.getConfigInputStream(config_file, table);
            adapterFile = new File(this.originalConfigFile);
            configFileDirectory = adapterFile.getParentFile().getAbsolutePath();
        }
        catch (InvocationTargetException e) {
            inStream = this.getConfigInputStream(config_file, table);
            adapterFile = new File(this.originalConfigFile);
            configFileDirectory = adapterFile.getParentFile().getAbsolutePath();
        }
        catch (Exception e) {
            throw new LogParserException(Messages.getString((String)"HyadesGA_CBE_Adapter_Config_File_Open_ERROR_", (String)config_file), (Throwable)e);
        }
        this.file_path = (String)table.get(Messages.getString((String)"HyadesGAInputLogFilenameTag"));
        File logFile = null;
        if (this.file_path != null && this.file_path.trim().length() > 0) {
            logFile = new File(this.file_path.trim());
        }
        try {
            doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(inStream);
        }
        catch (SAXException e) {
            throw new LogParserException(Messages.getString((String)"HyadesGA_CBE_Adapter_Config_File_Parse_ERROR_", (String)var7_31.getAbsolutePath()), (Throwable)e);
        }
        catch (IOException e) {
            throw new LogParserException(Messages.getString((String)"HyadesGA_CBE_Adapter_Config_File_Parse_ERROR_", (String)var7_31.getAbsolutePath()), (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new LogParserException(Messages.getString((String)"HyadesGA_CBE_Adapter_Config_File_Parse_ERROR_", (String)var7_31.getAbsolutePath()), (Throwable)e);
        }
        catch (Exception e) {
            throw new LogParserException(Messages.getString((String)"HyadesGA_CBE_Adapter_Config_File_Parse_ERROR_", (String)var7_31.getAbsolutePath()), (Throwable)e);
        }
        NodeList sensorList = doc.getElementsByTagName(Messages.getString((String)"HyadesGASensorTagName"));
        int sensorCount = sensorList.getLength();
        for (int i = 0; i < sensorCount; ++i) {
            String propValue;
            Element sensorElement = (Element)sensorList.item(i);
            if (sensorElement == null) continue;
            Element sensorTypeInstance = null;
            String newConverterCmd = null;
            Element directoryPropertyElement = null;
            Element fileNamePropertyElement = null;
            NodeList sensorNodes = sensorElement.getChildNodes();
            for (int k = 0; k < sensorNodes.getLength(); ++k) {
                String propName;
                Element sensorPropertyElement;
                if (sensorNodes.item(k).getNodeType() != 1) continue;
                Element sensorNode = (Element)sensorNodes.item(k);
                if (sensorNode.getTagName().equals(Messages.getString((String)"HyadesGAPropertyElementTagName"))) {
                    sensorPropertyElement = sensorNode;
                    propName = sensorPropertyElement.getAttribute(Messages.getString((String)"HyadesGAPropertyNameAttributeName"));
                    propValue = sensorPropertyElement.getAttribute(Messages.getString((String)"HyadesGAPropertyValueAttributeName"));
                    if (propName.equals(Messages.getString((String)"HyadesGAdirectoryAttributeName"))) {
                        directoryPropertyElement = sensorPropertyElement;
                        if (logFile == null) continue;
                        sensorPropertyElement.setAttribute(Messages.getString((String)"HyadesGAPropertyValueAttributeName"), logFile.getParent());
                        continue;
                    }
                    if (propName.equals(Messages.getString((String)"HyadesGAfileNameAttributeName"))) {
                        fileNamePropertyElement = sensorPropertyElement;
                        if (logFile == null) continue;
                        sensorPropertyElement.setAttribute(Messages.getString((String)"HyadesGAPropertyValueAttributeName"), logFile.getName());
                        continue;
                    }
                    if (propName.equals(Messages.getString((String)"HyadesGAconverterCmdAttributeName"))) {
                        if (propValue == null || propValue.length() <= 0) continue;
                        if (newConverterCmd == null) {
                            newConverterCmd = this.modifyConverter(propValue, configFileDirectory, table, logFile);
                        }
                        sensorPropertyElement.setAttribute(Messages.getString((String)"HyadesGAPropertyValueAttributeName"), newConverterCmd);
                        continue;
                    }
                    if (propName.equals(Messages.getString((String)"HyadesGAstaticParserClassAttributeName"))) {
                        this.parserName = propValue;
                        continue;
                    }
                    propValue = (String)table.get(propName);
                    if (propValue == null) continue;
                    sensorPropertyElement.setAttribute(Messages.getString((String)"HyadesGAPropertyValueAttributeName"), propValue.trim());
                    continue;
                }
                if (!sensorNode.getTagName().equals(Messages.getString((String)"HyadesGAStaticParserSensorTagName")) && !sensorNode.getTagName().equals(Messages.getString((String)"HyadesGASingleFileSensorTagName"))) continue;
                sensorTypeInstance = sensorNode;
                NodeList sensorPropertyList = sensorTypeInstance.getElementsByTagName(Messages.getString((String)"HyadesGASensorPropertyElementTagName"));
                int sensorPropertyCount = sensorPropertyList.getLength();
                for (int j = 0; j < sensorPropertyCount; ++j) {
                    sensorPropertyElement = (Element)sensorPropertyList.item(j);
                    propName = sensorPropertyElement.getAttribute(Messages.getString((String)"HyadesGASensorPropertyNameAttributeName"));
                    propValue = (String)table.get(propName);
                    if (propValue == null) continue;
                    sensorPropertyElement.setAttribute(Messages.getString((String)"HyadesGASensorPropertyValueAttributeName"), propValue.trim());
                }
                NamedNodeMap sensorTypeAttributeList = sensorTypeInstance.getAttributes();
                int sensorTypeAttributeCount = sensorTypeAttributeList.getLength();
                for (int j = 0; j < sensorTypeAttributeCount; ++j) {
                    Node sensorTypeAttribute = sensorTypeAttributeList.item(j);
                    String attrName = sensorTypeAttribute.getNodeName();
                    if (attrName.equals(Messages.getString((String)"HyadesGAdirectoryAttributeName"))) {
                        if (logFile == null) continue;
                        sensorTypeAttribute.setNodeValue(logFile.getParent());
                        continue;
                    }
                    if (attrName.equals(Messages.getString((String)"HyadesGAfileNameAttributeName"))) {
                        if (logFile == null) continue;
                        sensorTypeAttribute.setNodeValue(logFile.getName());
                        continue;
                    }
                    if (attrName.equals(Messages.getString((String)"HyadesGAstaticParserClassAttributeName"))) {
                        this.parserName = sensorTypeAttribute.getNodeValue();
                        continue;
                    }
                    if (attrName.equals(Messages.getString((String)"HyadesGAconverterCmdAttributeName"))) {
                        if (newConverterCmd == null) {
                            newConverterCmd = this.modifyConverter(sensorTypeAttribute.getNodeValue(), configFileDirectory, table, logFile);
                        }
                        sensorTypeAttribute.setNodeValue(newConverterCmd);
                        continue;
                    }
                    propValue = (String)table.get(attrName);
                    if (propValue == null) continue;
                    sensorTypeAttribute.setNodeValue(propValue.trim());
                }
            }
            NamedNodeMap sensorAttributeList = sensorElement.getAttributes();
            int sensorTypeAttributeCount = sensorAttributeList.getLength();
            for (int k = 0; k < sensorTypeAttributeCount; ++k) {
                Node sensorTypeAttribute = sensorAttributeList.item(k);
                String attrName = sensorTypeAttribute.getNodeName();
                propValue = (String)table.get(attrName);
                if (propValue == null || propValue.length() <= 0) continue;
                sensorTypeAttribute.setNodeValue(propValue.trim());
            }
            if (this.newDirectory != null) {
                if (directoryPropertyElement != null) {
                    directoryPropertyElement.setAttribute(Messages.getString((String)"HyadesGASensorPropertyValueAttributeName"), this.newDirectory);
                }
                if (sensorTypeInstance != null) {
                    Attr sensorAttribute = sensorTypeInstance.getAttributeNode(Messages.getString((String)"HyadesGAdirectoryAttributeName"));
                    sensorAttribute.setNodeValue(this.newDirectory);
                }
            }
            if (this.newFileName == null) continue;
            if (fileNamePropertyElement != null) {
                fileNamePropertyElement.setAttribute(Messages.getString((String)"HyadesGASensorPropertyValueAttributeName"), this.newFileName);
            }
            if (sensorTypeInstance == null) continue;
            Attr sensorAttribute = sensorTypeInstance.getAttributeNode(Messages.getString((String)"HyadesGAfileNameAttributeName"));
            sensorAttribute.setNodeValue(this.newFileName);
        }
        NodeList outputterList = doc.getElementsByTagName(Messages.getString((String)"HyadesGAOutputterTagName"));
        int outputterCount = outputterList.getLength();
        for (int i = 0; i < outputterCount; ++i) {
            Element outputterElement = (Element)outputterList.item(i);
            Element outputterProperty = doc.createElement(Messages.getString((String)"HyadesGAPropertyElementTagName"));
            outputterProperty.setAttribute(Messages.getString((String)"HyadesGAPropertyValueAttributeName"), this.key);
            outputterProperty.setAttribute(Messages.getString((String)"HyadesGAPropertyNameAttributeName"), Messages.getString((String)"HyadesGAStaticParserLoggerKeyName"));
            outputterElement.appendChild(outputterProperty);
        }
        File newFile = null;
        try {
            Class<?> platformClass = Class.forName("org.eclipse.core.runtime.Platform");
            Method getPluginStateLocationMethod = platformClass.getMethod("getPluginStateLocation", Class.forName("org.eclipse.core.runtime.Plugin"));
            Object iPathObject = getPluginStateLocationMethod.invoke(null, new Object[]{AdapterConfigPlugin.getPlugin()});
            Class<?> iPathClass = iPathObject.getClass();
            Method toOSStringMethod = iPathClass.getMethod("toOSString", null);
            newFile = new File((String)toOSStringMethod.invoke(iPathObject, null), "GLA" + System.currentTimeMillis() + ".adapter");
        }
        catch (Exception e) {
            try {
                newFile = File.createTempFile("GLA", ".adapter");
            }
            catch (Exception e2) {
                File oldFile = new File(config_file);
                String tmpFileName = new String("GLA" + System.currentTimeMillis() + ".adapter");
                newFile = new File(oldFile.getParent(), tmpFileName);
            }
        }
        newFile.deleteOnExit();
        try {
            XmlUtility.serialize((Document)doc, (File)newFile);
        }
        catch (SerializationException s) {
            throw new LogParserException(Messages.getString((String)"HyadesGA_CBE_Adapter_Config_File_Save_ERROR_", (String)newFile.getAbsolutePath()), (Throwable)s);
        }
        return newFile.getAbsolutePath();
    }

    protected String modifyConverter(String converter, String configFileDirectory, Hashtable table, File logfile) {
        return converter;
    }
}

