/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.execution.security;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.hyades.internal.execution.local.control.Application;
import org.eclipse.hyades.internal.execution.security.DuplicateUserException;
import org.eclipse.hyades.internal.execution.security.User;

public class UserFactory {
    private static Hashtable _table = new Hashtable();

    public static synchronized User createUser(Application app, String name, String password) throws DuplicateUserException {
        Vector<User> userList = (Vector<User>)_table.get(app.getName());
        if (userList == null) {
            userList = new Vector<User>();
            _table.put(app.getName(), userList);
        } else {
            Enumeration e = userList.elements();
            while (e.hasMoreElements()) {
                User user = (User)e.nextElement();
                if (!user.getName().equals(name)) continue;
                throw new DuplicateUserException();
            }
        }
        User user = new User(app, name, password);
        userList.add(user);
        return user;
    }

    public static synchronized void removeAllUsers(Application app) {
        _table.remove(app.getName());
    }

    public static User removeUser(Application app, String name) {
        Vector userList = (Vector)_table.get(app.getName());
        if (userList != null) {
            Object[] users = userList.toArray();
            for (int i = 0; i < users.length; ++i) {
                User currentUser = (User)users[i];
                if (!currentUser.getName().equals(name)) continue;
                userList.remove(i);
                return currentUser;
            }
        }
        return null;
    }

    public static synchronized User getUser(Application app, String name) {
        User user = null;
        Vector userList = (Vector)_table.get(app.getName());
        if (userList != null) {
            Enumeration e = userList.elements();
            while (e.hasMoreElements()) {
                user = (User)e.nextElement();
                if (!user.getName().equals(name)) continue;
                return user;
            }
        }
        return null;
    }
}

