/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.loaders.util;

import java.util.Iterator;
import java.util.List;
import org.eclipse.hyades.loaders.util.HyadesConfigurationElement;
import org.eclipse.hyades.loaders.util.HyadesResourceExtensions;
import org.eclipse.hyades.loaders.util.IHyadesPluginClassDescriptor;
import org.eclipse.hyades.loaders.util.RegistryReader;
import org.eclipse.hyades.models.hierarchy.util.IHyadesResourceExtension;

class HyadesResourceRegistryReader
extends RegistryReader {
    static final String TAG_RESOURCE_EXTENSION = "hyadesResourceExtension";
    static final String ATT_CLASS = "class";

    public HyadesResourceRegistryReader() {
        super("hyades_resource_extension");
    }

    protected boolean readElement(HyadesConfigurationElement element) {
        if (element.getName().equals(TAG_RESOURCE_EXTENSION)) {
            if (element.getAttribute(ATT_CLASS) == null) {
                this.logMissingAttribute(element, ATT_CLASS);
            } else {
                try {
                    IHyadesPluginClassDescriptor classDescriptor = this.createPluginClassDescriptor(element, ATT_CLASS);
                    IHyadesResourceExtension f = (IHyadesResourceExtension)classDescriptor.createInstance();
                    List postfixes = f.getSupportedPostfixes();
                    Iterator iter = postfixes.iterator();
                    while (iter.hasNext()) {
                        String postfix = (String)iter.next();
                        if (HyadesResourceExtensions.getInstance().containsKey(postfix)) {
                            this.logError(element, "A Hyades resource factory extension for these \"" + postfixes + "\" already exists, this extension will be ignored.");
                            continue;
                        }
                        HyadesResourceExtensions.getInstance().put(postfix, f);
                    }
                }
                catch (Exception e) {
                    this.logError(element, e.getLocalizedMessage());
                }
                return true;
            }
        }
        return false;
    }
}

