/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.hierarchy.util;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.ecore.xmi.DanglingHREFException;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.XMISaveImpl;
import org.eclipse.hyades.models.hierarchy.util.ContainmentTraverser;
import org.eclipse.hyades.models.hierarchy.util.EObjectVisitor;
import org.eclipse.hyades.models.hierarchy.util.HierarchyXMLString;

public class HierarchyXMISaveImpl
extends XMISaveImpl {
    protected final int BUFFER_SIZE = 262144;
    protected List elementFeaturesPool = new ArrayList();
    protected StringBuffer ids = new StringBuffer(200);
    protected StringBuffer xsiSchemaLocation = new StringBuffer(100);
    protected char[] buffer = new char[262144];
    protected byte[] bytes = new byte[262144];
    protected int[] featureKinds;
    protected int currentDepth;
    protected int elementFeaturesCount = 0;
    private byte[] byteArray;
    private char[] charArray;

    public HierarchyXMISaveImpl(XMLHelper helper) {
        super(helper);
    }

    public HierarchyXMISaveImpl(Map options, XMLHelper helper, String encoding) {
        super(options, helper, encoding);
    }

    public void addNamespaceDeclarations() {
        EPackage ePackage;
        int i;
        this.doc.addAttribute("xmi:version", "2.0");
        this.doc.addAttribute("xmlns:xmi", "http://www.omg.org/XMI");
        EPackage[] packages = this.helper.packages();
        this.xsiSchemaLocation.setLength(0);
        if (this.declareSchemaLocation) {
            for (i = 0; i < packages.length; ++i) {
                EPackage rootEPackage;
                Resource resource;
                ePackage = packages[i];
                EObject root = EcoreUtil.getRootContainer((EObject)ePackage);
                if (!(root instanceof EPackage) || (resource = (rootEPackage = (EPackage)root).eResource()) == null) continue;
                URI uri = resource.getURI();
                String rootNsURI = rootEPackage.getNsURI();
                if (!(uri == null ? rootNsURI != null : !uri.toString().equals(rootNsURI))) continue;
                this.declareXSI = true;
                if (this.xsiSchemaLocation.length() > 0) {
                    this.xsiSchemaLocation.append(' ');
                }
                this.xsiSchemaLocation.append(rootNsURI);
                this.xsiSchemaLocation.append(' ');
                this.xsiSchemaLocation.append(this.helper.getHREF((EObject)rootEPackage));
            }
        }
        this.doc.addAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        for (i = 0; i < packages.length; ++i) {
            ePackage = packages[i];
            String nsURI = ePackage.getNsURI();
            String nsPrefix = ePackage.getNsPrefix();
            this.doc.addAttributeNS("xmlns", nsPrefix, nsURI);
        }
        if (this.xsiSchemaLocation != null && this.xsiSchemaLocation.length() > 0) {
            this.doc.addAttribute("xsi:schemaLocation", this.xsiSchemaLocation.toString());
        }
    }

    public void save(XMLResource resource, OutputStream outputStream, Map options) throws IOException {
        DanglingHREFException exception;
        this.init(resource, options);
        this.doc = new HierarchyXMLString(null);
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outputStream, this.helper.getJavaEncoding(this.encoding)), 262144);
        ((HierarchyXMLString)this.doc).setWriter(writer);
        this.traverse((List)resource.getContents());
        ((Writer)writer).flush();
        this.featureTable = null;
        this.doc = null;
        if ((this.processDanglingHREF == null || "THROW".equals(this.processDanglingHREF)) && (exception = this.helper.getDanglingHREFException()) != null) {
            this.helper = null;
            throw new Resource.IOWrappedException((Exception)exception);
        }
        this.helper = null;
    }

    public char[] toChar() {
        int size = this.doc.getLength();
        char[] output = this.allocCharArray(size);
        this.doc.getChars(output, 0);
        return output;
    }

    public void traverse(List contents) {
        int size;
        if (this.declareXML) {
            this.doc.add("<?xml version=\"1.0\" encoding=\"" + this.encoding + "\"?>");
            this.doc.addLine();
        }
        Object mark = (size = contents.size()) == 1 ? this.writeTopObject((EObject)contents.get(0)) : this.writeTopObjects(contents);
        this.doc.resetToMark(mark);
    }

    public void write(OutputStreamWriter os) throws IOException {
        int pos = 0;
        Iterator i = this.doc.iterator();
        while (i.hasNext()) {
            String s = (String)i.next();
            int slen = s.length();
            if (slen + pos >= this.buffer.length) {
                os.write(this.buffer, 0, pos);
                pos = 0;
                if (slen > this.buffer.length) {
                    this.buffer = this.allocCharArray(slen);
                }
            }
            s.getChars(0, slen, this.buffer, pos);
            pos += slen;
        }
        os.write(this.buffer, 0, pos);
        os.flush();
    }

    public void writeAscii(OutputStream os) throws IOException {
        int pos = 0;
        Iterator i = this.doc.iterator();
        while (i.hasNext()) {
            String s = (String)i.next();
            int slen = s.length();
            if (slen + pos >= this.buffer.length) {
                for (int x = 0; x < pos; ++x) {
                    this.bytes[x] = (byte)(this.buffer[x] & 0xFF);
                }
                os.write(this.bytes, 0, pos);
                pos = 0;
                if (slen > this.buffer.length) {
                    this.buffer = this.allocCharArray(slen);
                    this.bytes = this.allocByteArray(slen);
                }
            }
            s.getChars(0, slen, this.buffer, pos);
            pos += slen;
        }
        for (int x = 0; x < pos; ++x) {
            this.bytes[x] = (byte)(this.buffer[x] & 0xFF);
        }
        os.write(this.bytes, 0, pos);
        os.flush();
    }

    public Object writeTopObjects(List contents) {
        this.doc.startElement("xmi:XMI");
        this.addExtraPackages(contents, Integer.MAX_VALUE);
        this.addNamespaceDeclarations();
        Object mark = this.doc.mark();
        int size = contents.size();
        for (int i = 0; i < size; ++i) {
            EObject top = (EObject)contents.get(i);
            EClass eClass = top.eClass();
            String name = this.helper.getQName(eClass);
            this.doc.startElement(name);
            this.saveElementID(top);
        }
        this.doc.endElement();
        return mark;
    }

    protected String getContent(EObject o, EStructuralFeature[] features) {
        XMLResource.XMLMap map = this.helper.getXMLMap();
        if (map == null) {
            return null;
        }
        for (int i = 0; i < features.length; ++i) {
            XMLResource.XMLInfo info = map.getInfo((ENamedElement)features[i]);
            if (info == null || info.getXMLRepresentation() != 2) continue;
            Object value = this.helper.getValue(o, features[i]);
            if (value == null) {
                return null;
            }
            EDataType d = (EDataType)features[i].getEType();
            EPackage ePackage = d.getEPackage();
            EFactory fac = ePackage.getEFactoryInstance();
            String svalue = fac.convertToString(d, value);
            if (this.escape != null) {
                svalue = this.escape.convert(svalue);
            }
            return svalue;
        }
        return null;
    }

    protected byte[] allocByteArray(int slen) {
        if (this.byteArray.length < slen) {
            this.byteArray = new byte[slen];
        }
        return this.byteArray;
    }

    protected char[] allocCharArray(int slen) {
        if (this.charArray.length < slen) {
            this.charArray = new char[slen];
        }
        return this.charArray;
    }

    protected void saveDataTypeElementSingle(EObject o, EStructuralFeature f) {
        String name = this.helper.getQName(f);
        Object value = this.helper.getValue(o, f);
        if (value == null) {
            this.doc.startElement(name);
            this.doc.addAttribute("xsi:nil", "true");
            this.doc.endEmptyElement();
            this.declareXSI = true;
        } else {
            EDataType d = (EDataType)f.getEType();
            EPackage ePackage = d.getEPackage();
            EFactory fac = ePackage.getEFactoryInstance();
            this.doc.startElement(name);
            String svalue = fac.convertToString(d, value);
            if (this.escape != null) {
                svalue = this.escape.convert(svalue);
            }
            this.doc.endContentElement(svalue);
        }
    }

    protected void saveDataTypeMany(EObject o, EStructuralFeature f) {
        EDataType d = (EDataType)f.getEType();
        EPackage ePackage = d.getEPackage();
        EFactory fac = ePackage.getEFactoryInstance();
        List values = (List)this.helper.getValue(o, f);
        int size = values.size();
        if (size > 0) {
            String name = this.helper.getQName(f);
            for (int i = 0; i < size; ++i) {
                Object value = values.get(i);
                if (value == null) {
                    this.doc.startElement(name);
                    this.doc.addAttribute("xsi:nil", "true");
                    this.doc.endEmptyElement();
                    this.declareXSI = true;
                    continue;
                }
                this.doc.startElement(name);
                String svalue = fac.convertToString(d, value);
                if (this.escape != null) {
                    svalue = this.escape.convert(svalue);
                }
                this.doc.endContentElement(svalue);
            }
        }
    }

    protected void saveDataTypeSingle(EObject o, EStructuralFeature f) {
        EDataType d = (EDataType)f.getEType();
        EPackage ePackage = d.getEPackage();
        EFactory fac = ePackage.getEFactoryInstance();
        Object value = this.helper.getValue(o, f);
        if (value != null) {
            String svalue = fac.convertToString(d, value);
            if (this.escape != null) {
                svalue = this.escape.convert(svalue);
            }
            this.doc.addAttribute(this.helper.getQName(f), svalue);
        }
    }

    protected boolean saveFeatures(EObject o) {
        EClass eClass = o.eClass();
        EStructuralFeature[] features = this.featureTable.getFeatures(eClass);
        int[] featureKinds = this.featureTable.getKinds(eClass, features);
        int[] elementFeatures = null;
        int elementCount = 0;
        block32: for (int i = 0; i < features.length; ++i) {
            int kind = featureKinds[i];
            EStructuralFeature f = features[i];
            if (kind == 0 || !o.eIsSet(f)) continue;
            switch (kind) {
                case 2: {
                    if (elementFeatures == null) {
                        elementFeatures = this.allocElementFeatures(features.length);
                    }
                    elementFeatures[elementCount++] = i;
                    continue block32;
                }
                case 1: {
                    this.saveDataTypeSingle(o, f);
                    continue block32;
                }
                case 4: {
                    if (this.isNil(o, f)) {
                        if (elementFeatures == null) {
                            elementFeatures = this.allocElementFeatures(features.length);
                        }
                        elementFeatures[elementCount++] = i;
                        continue block32;
                    }
                    this.saveDataTypeSingle(o, f);
                    continue block32;
                }
                case 12: {
                    if (this.isNil(o, f)) {
                        if (elementFeatures == null) {
                            elementFeatures = this.allocElementFeatures(features.length);
                        }
                        elementFeatures[elementCount++] = i;
                        continue block32;
                    }
                }
                case 8: {
                    if (this.useEncodedAttributeStyle) {
                        this.saveEObjectSingle(o, f);
                        continue block32;
                    }
                    switch (this.sameDocSingle(o, f)) {
                        case 1: {
                            this.saveIDRefSingle(o, f);
                            break;
                        }
                        case 2: {
                            if (elementFeatures == null) {
                                elementFeatures = this.allocElementFeatures(features.length);
                            }
                            elementFeatures[elementCount++] = i;
                        }
                    }
                    continue block32;
                }
                case 13: {
                    if (this.isEmpty(o, f)) {
                        this.saveManyEmpty(f);
                        continue block32;
                    }
                }
                case 9: {
                    if (this.useEncodedAttributeStyle) {
                        this.saveEObjectMany(o, f);
                        continue block32;
                    }
                    switch (this.sameDocMany(o, f)) {
                        case 1: {
                            this.saveIDRefMany(o, f);
                            break;
                        }
                        case 2: {
                            if (elementFeatures == null) {
                                elementFeatures = this.allocElementFeatures(features.length);
                            }
                            elementFeatures[elementCount++] = i;
                        }
                    }
                    continue block32;
                }
                case 5: 
                case 11: {
                    if (this.isEmpty(o, f)) {
                        this.saveManyEmpty(f);
                        continue block32;
                    }
                }
                case 6: 
                case 7: 
                case 10: 
                case 14: 
                case 16: {
                    if (elementFeatures == null) {
                        elementFeatures = this.allocElementFeatures(features.length);
                    }
                    elementFeatures[elementCount++] = i;
                }
            }
        }
        String content = this.getContent(o, features);
        if (elementFeatures == null) {
            if (content == null) {
                this.endSaveFeatures(o, 1, null);
                if (elementFeatures != null) {
                    this.dealocElementFeatures();
                }
                return false;
            }
            this.endSaveFeatures(o, 2, content);
            if (elementFeatures != null) {
                this.dealocElementFeatures();
            }
            return true;
        }
        block33: for (int i = 0; i < elementCount; ++i) {
            int kind = featureKinds[elementFeatures[i]];
            EStructuralFeature f = features[elementFeatures[i]];
            switch (kind) {
                case 4: {
                    this.saveNil(f);
                    continue block33;
                }
                case 5: {
                    this.saveDataTypeMany(o, f);
                    continue block33;
                }
                case 2: {
                    this.saveDataTypeElementSingle(o, f);
                    continue block33;
                }
                case 10: {
                    if (this.isNil(o, f)) {
                        this.saveNil(f);
                        continue block33;
                    }
                }
                case 6: {
                    this.saveContainedSingle(o, f);
                    continue block33;
                }
                case 7: 
                case 11: {
                    this.saveContainedMany(o, f);
                    continue block33;
                }
                case 12: {
                    if (this.isNil(o, f)) {
                        this.saveNil(f);
                        continue block33;
                    }
                }
                case 8: {
                    this.saveHRefSingle(o, f);
                    continue block33;
                }
                case 9: 
                case 13: {
                    this.saveHRefMany(o, f);
                    continue block33;
                }
                case 14: {
                    this.saveElementReferenceSingle(o, f);
                    continue block33;
                }
                case 16: {
                    this.saveElementReferenceMany(o, f);
                }
            }
        }
        this.endSaveFeatures(o, 0, null);
        if (elementFeatures != null) {
            this.dealocElementFeatures();
        }
        return true;
    }

    protected void saveIDRefMany(EObject o, EStructuralFeature f) {
        InternalEList values = (InternalEList)this.helper.getValue(o, f);
        if (!values.isEmpty()) {
            String name = this.helper.getQName(f);
            this.ids.setLength(0);
            Iterator i = values.basicIterator();
            while (true) {
                EObject value = (EObject)i.next();
                String id = this.helper.getIDREF(value);
                this.ids.append(id);
                if (!i.hasNext()) break;
                this.ids.append(" ");
            }
            this.doc.addAttribute(name, this.ids.toString());
        }
    }

    protected Object writeTopObject(EObject top) {
        EClass eClass = top.eClass();
        BasicEList contents = new BasicEList();
        contents.add(top);
        this.addExtraPackages((List)contents, Integer.MAX_VALUE);
        String name = this.helper.getQName(eClass);
        this.doc.startElement(name);
        this.addNamespaceDeclarations();
        Object mark = this.doc.mark();
        this.saveElementID(top);
        return mark;
    }

    private void addExtraPackages(List objects, final int depth) {
        this.currentDepth = 0;
        ContainmentTraverser containmentTraverser = new ContainmentTraverser(objects);
        EObjectVisitor objectVisitor = new EObjectVisitor(){

            public boolean afterChildren(EObject element) {
                --HierarchyXMISaveImpl.this.currentDepth;
                HierarchyXMISaveImpl.this.helper.getQName(element.eClass());
                return true;
            }

            public boolean beforeChildren(EObject element) {
                if (HierarchyXMISaveImpl.this.currentDepth > depth) {
                    return false;
                }
                ++HierarchyXMISaveImpl.this.currentDepth;
                return true;
            }
        };
        containmentTraverser.registerVisitors(objectVisitor);
        containmentTraverser.traverse();
    }

    private int[] allocElementFeatures(int i) {
        int[] elementFeatures;
        if (this.elementFeaturesCount == this.elementFeaturesPool.size()) {
            elementFeatures = new int[i];
            this.elementFeaturesPool.add(elementFeatures);
        } else {
            elementFeatures = (int[])this.elementFeaturesPool.get(this.elementFeaturesCount);
            if (elementFeatures.length < i) {
                elementFeatures = new int[i];
                this.elementFeaturesPool.set(this.elementFeaturesCount, elementFeatures);
            }
        }
        ++this.elementFeaturesCount;
        return elementFeatures;
    }

    private void dealocElementFeatures() {
        if (this.elementFeaturesCount > 0) {
            --this.elementFeaturesCount;
        }
    }
}

