/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.collection.threadanalyzer.dumpparser;

import java.io.IOException;
import java.util.StringTokenizer;
import org.eclipse.hyades.collection.threadanalyzer.DumpData;
import org.eclipse.hyades.collection.threadanalyzer.StkEntry;
import org.eclipse.hyades.collection.threadanalyzer.TAUtils;
import org.eclipse.hyades.collection.threadanalyzer.TaException;
import org.eclipse.hyades.collection.threadanalyzer.Thd;
import org.eclipse.hyades.collection.threadanalyzer.dumpparser.DumpParser;

public class DumpParserSolaris
extends DumpParser {
    public void parse(DumpData d) throws Exception {
        try {
            if (this._r.ready()) {
                String s = this._r.readLine();
                this.getThreadData(d);
            }
        }
        catch (Exception e) {
            DumpParserSolaris.logErr(TAUtils.getNLSValue("ta.errmsg.ExceptionWhileParsing", "exception while parsing line") + ": " + this._lineNo + " -- " + _dumpInName);
            throw new TaException("" + this._lineNo, e);
        }
    }

    private void getThreadData(DumpData d) throws Exception {
        this.readToDump();
        String line = null;
        char firstChar = '\u0000';
        line = this.getLine(d);
        Thd thd = null;
        while (line.length() > 0) {
            firstChar = line.charAt(0);
            if (firstChar == '\"') {
                int idx1 = line.indexOf(34);
                int idx2 = line.indexOf(34, idx1 + 1);
                String thdNm = line.substring(idx1 + 1, idx2);
                idx1 = line.indexOf("sys_thread_t:");
                String line2 = line.substring(idx1);
                idx2 = line2.indexOf(44);
                String threadId = line2.substring(13, idx2);
                idx1 = line.indexOf("state:") + 6;
                idx2 = line.indexOf(44, idx1);
                String state = line.substring(idx1, idx2);
                idx1 = line.indexOf("prio=");
                String priority = line.substring(idx1 + 5);
                thd = d.addThd(thdNm, threadId, state, priority);
                line = this.getLine(d);
            } else if (firstChar == '[' && line.charAt(0) != '-') {
                StringTokenizer st = new StringTokenizer(line);
                String line2 = new String(st.nextToken());
                line2 = st.nextToken();
                if (st.hasMoreTokens()) {
                    line2 = line2 + " " + st.nextToken();
                }
                boolean isNative = false;
                String moduleName = null;
                String lineno = null;
                int idx1 = line2.indexOf("(Native Method)");
                if (idx1 > 0) {
                    isNative = true;
                    line2 = line2.substring(0, idx1);
                } else {
                    idx1 = line2.indexOf("(");
                    String moduleInfo = line2.substring(++idx1);
                    line2 = line2.substring(0, idx1 - 1);
                    int idx2 = moduleInfo.indexOf(58);
                    if (idx2 > 0) {
                        lineno = moduleInfo.substring(idx2 + 1, moduleInfo.indexOf(41, idx2));
                        moduleName = moduleInfo.substring(0, idx2);
                    } else {
                        idx2 = moduleInfo.indexOf(41);
                        moduleName = moduleInfo.substring(0, idx2);
                    }
                }
                String method = line2.substring(line2.lastIndexOf(46) + 1);
                String pkg = line2.substring(0, line2.lastIndexOf(46));
                int iLineNo = -1;
                if (lineno != null) {
                    iLineNo = Integer.parseInt(lineno);
                }
                StkEntry se = new StkEntry(method, pkg, moduleName, iLineNo, isNative);
                thd.addStackEntry(se);
            }
            line = this.getLine(d);
        }
    }

    private void readToDump() {
        int lineNo = 0;
        int matchAt = -1;
        try {
            while (this._r.ready()) {
                String str1 = this._r.readLine();
                ++lineNo;
                if (str1.indexOf("Full thread dump") <= -1) continue;
                matchAt = lineNo;
                break;
            }
        }
        catch (IOException ioe) {
            DumpParserSolaris.logErr(TAUtils.getNLSValue("ta.errmsg.ErrorReading", "error reading") + " " + "stderr");
            System.exit(-1);
        }
    }
}

