/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.common.interactions;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.MissingResourceException;
import org.eclipse.emf.common.util.AbstractEnumerator;
import org.eclipse.hyades.models.common.common.CommonPlugin;

public final class BVRMessageSort
extends AbstractEnumerator {
    public static final String copyright = "";
    public static final int SYNCH_CALL = 0;
    public static final int SYNCH_SIGNAL = 1;
    public static final int ASYNCH_CALL = 2;
    public static final int ASYNCH_SIGNAL = 3;
    public static final BVRMessageSort SYNCH_CALL_LITERAL = new BVRMessageSort(0, "synchCall");
    public static final BVRMessageSort SYNCH_SIGNAL_LITERAL = new BVRMessageSort(1, "synchSignal");
    public static final BVRMessageSort ASYNCH_CALL_LITERAL = new BVRMessageSort(2, "asynchCall");
    public static final BVRMessageSort ASYNCH_SIGNAL_LITERAL = new BVRMessageSort(3, "asynchSignal");
    private static final BVRMessageSort[] VALUES_ARRAY = new BVRMessageSort[]{SYNCH_CALL_LITERAL, SYNCH_SIGNAL_LITERAL, ASYNCH_CALL_LITERAL, ASYNCH_SIGNAL_LITERAL};
    public static final List VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    private final String keyPrefix = ((Object)((Object)this)).getClass().getName() + ".";

    public static BVRMessageSort get(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            BVRMessageSort result = VALUES_ARRAY[i];
            if (!result.toString().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static BVRMessageSort get(int value) {
        switch (value) {
            case 0: {
                return SYNCH_CALL_LITERAL;
            }
            case 1: {
                return SYNCH_SIGNAL_LITERAL;
            }
            case 2: {
                return ASYNCH_CALL_LITERAL;
            }
            case 3: {
                return ASYNCH_SIGNAL_LITERAL;
            }
        }
        return null;
    }

    private BVRMessageSort(int value, String name) {
        super(value, name);
    }

    public static BVRMessageSort getByLabel(String label) {
        if (label != null) {
            int maxi = VALUES_ARRAY.length;
            for (int i = 0; i < maxi; ++i) {
                if (!label.equals(VALUES_ARRAY[i].getLabel())) continue;
                return VALUES_ARRAY[i];
            }
        }
        return BVRMessageSort.get(label);
    }

    public String getLabel() {
        try {
            String label = this.getString(this.keyPrefix + this.getName());
            if (label != null) {
                return label;
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return this.getName();
    }

    protected String getString(String key) throws NullPointerException, MissingResourceException {
        return CommonPlugin.getString(key);
    }
}

