/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.common.facades.behavioral.impl;

import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.models.common.common.CommonFactory;
import org.eclipse.hyades.models.common.common.impl.CMNAnnotationImpl;
import org.eclipse.hyades.models.common.configuration.Common_ConfigurationFactory;
import org.eclipse.hyades.models.common.configuration.impl.CFGClassImpl;
import org.eclipse.hyades.models.common.configuration.impl.CFGInstanceImpl;
import org.eclipse.hyades.models.common.configuration.impl.CFGOperationImpl;
import org.eclipse.hyades.models.common.facades.behavioral.IAnnotation;
import org.eclipse.hyades.models.common.facades.behavioral.IDecision;
import org.eclipse.hyades.models.common.facades.behavioral.IImplementor;
import org.eclipse.hyades.models.common.facades.behavioral.ILoop;
import org.eclipse.hyades.models.common.facades.behavioral.IMethod;
import org.eclipse.hyades.models.common.facades.behavioral.IProperty;
import org.eclipse.hyades.models.common.facades.behavioral.ISystemUnderTest;
import org.eclipse.hyades.models.common.facades.behavioral.ITargetInvocation;
import org.eclipse.hyades.models.common.facades.behavioral.ITest;
import org.eclipse.hyades.models.common.facades.behavioral.ITestCase;
import org.eclipse.hyades.models.common.facades.behavioral.ITestComponent;
import org.eclipse.hyades.models.common.facades.behavioral.ITestComponentInvocation;
import org.eclipse.hyades.models.common.facades.behavioral.ITestInvocation;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.models.common.facades.behavioral.IVariable;
import org.eclipse.hyades.models.common.facades.behavioral.IVerificationPoint;
import org.eclipse.hyades.models.common.fragments.BVRInteractionOperator;
import org.eclipse.hyades.models.common.fragments.Common_Behavior_FragmentsFactory;
import org.eclipse.hyades.models.common.fragments.impl.BVRCombinedFragmentImpl;
import org.eclipse.hyades.models.common.fragments.impl.BVRInteractionConstraintImpl;
import org.eclipse.hyades.models.common.fragments.impl.BVRInteractionImpl;
import org.eclipse.hyades.models.common.fragments.impl.BVRInteractionOperandImpl;
import org.eclipse.hyades.models.common.interactions.Common_Behavior_InteractionsFactory;
import org.eclipse.hyades.models.common.interactions.impl.BVRExecutionOccurrenceImpl;
import org.eclipse.hyades.models.common.interactions.impl.BVRLifelineImpl;
import org.eclipse.hyades.models.common.interactions.impl.BVRMessageEndImpl;
import org.eclipse.hyades.models.common.interactions.impl.BVRPropertyImpl;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofileFactory;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;
import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.models.common.testprofile.TPFTestComponent;
import org.eclipse.hyades.models.common.testprofile.impl.TPFBehaviorImpl;
import org.eclipse.hyades.models.common.testprofile.impl.TPFSUTImpl;
import org.eclipse.hyades.models.common.testprofile.impl.TPFTestCaseImpl;
import org.eclipse.hyades.models.common.testprofile.impl.TPFTestComponentImpl;
import org.eclipse.hyades.models.common.testprofile.impl.TPFTestSuiteImpl;
import org.eclipse.hyades.models.common.testprofile.impl.TPFValidationActionImpl;

public class HyadesFactory {
    public static final HyadesFactory INSTANCE = new HyadesFactory();

    public ITestSuite createTestSuite(Resource resource) {
        TPFTestSuiteImpl testSuiteImpl = (TPFTestSuiteImpl)Common_TestprofileFactory.eINSTANCE.createTPFTestSuite();
        resource.getContents().add((Object)testSuiteImpl);
        testSuiteImpl.setPersistenceId("HyadesFacadeResource");
        return testSuiteImpl;
    }

    public ITestCase createTestCase() {
        TPFTestCaseImpl testCaseImpl = (TPFTestCaseImpl)Common_TestprofileFactory.eINSTANCE.createTPFTestCase();
        return testCaseImpl;
    }

    /*
     * WARNING - void declaration
     */
    public IImplementor createImplementor(ITest implementedTest, boolean isExternalImplementor) {
        void var5_5;
        TPFTestSuiteImpl testSuite;
        TPFBehaviorImpl testBehavior = null;
        String implementedTestName = "";
        if (implementedTest instanceof TPFTestSuiteImpl) {
            testBehavior = (TPFBehaviorImpl)((TPFTestSuiteImpl)implementedTest).getBehavior();
        } else if (implementedTest instanceof TPFTestCaseImpl) {
            testBehavior = (TPFBehaviorImpl)((TPFTestCaseImpl)implementedTest).getBehavior();
        }
        if (testBehavior == null) {
            testBehavior = (TPFBehaviorImpl)Common_TestprofileFactory.eINSTANCE.createTPFBehavior();
            testBehavior.setName(implementedTest.getName() + "_behavior");
        }
        if (implementedTest != null) {
            this.associateBehavior(testBehavior, implementedTest);
            implementedTest.getName();
        }
        if (implementedTest instanceof ITestSuite) {
            testSuite = (TPFTestSuiteImpl)implementedTest;
        } else if (implementedTest instanceof ITestCase) {
            testSuite = (TPFTestSuiteImpl)((ITestCase)implementedTest).getOwner();
            if (testSuite == null) {
                throw new IllegalArgumentException("Test cases must be first added to test suites before implementors can be associated.");
            }
        } else {
            throw new IllegalArgumentException("ITest must be either a ITestCase or a ITestSuite.");
        }
        void theClass = var5_5;
        return this.configureImplementor(isExternalImplementor, testBehavior, implementedTestName, (CFGClassImpl)theClass);
    }

    protected IImplementor configureImplementor(boolean isExternalImplementor, TPFBehaviorImpl testBehavior, String implementedTestName, CFGClassImpl theClass) {
        CFGInstanceImpl instance = null;
        if (instance == null) {
            instance = (CFGInstanceImpl)Common_ConfigurationFactory.eINSTANCE.createCFGInstance();
            instance.setClassType(theClass);
            theClass.getInstances().add((Object)instance);
        }
        if (!isExternalImplementor) {
            BVRLifelineImpl selfLifeline = (BVRLifelineImpl)Common_Behavior_InteractionsFactory.eINSTANCE.createBVRLifeline();
            selfLifeline.setName(implementedTestName + "_selfLifeline");
            BVRInteractionImpl testInteraction = (BVRInteractionImpl)Common_Behavior_FragmentsFactory.eINSTANCE.createBVRInteraction();
            testInteraction.setName(implementedTestName + "_interaction");
            testBehavior.setInteraction(testInteraction);
            testInteraction.getLifelines().add((Object)selfLifeline);
            instance.setLifeline(selfLifeline);
        }
        return testBehavior;
    }

    public IImplementor createImplementor(ITestComponent testComponent, String implementorName, boolean isExternalImplementor) {
        TPFBehaviorImpl testComponentBehavior = null;
        List implementors = testComponent.getImplementors();
        testComponentBehavior = (TPFBehaviorImpl)Common_TestprofileFactory.eINSTANCE.createTPFBehavior();
        testComponentBehavior.setName(implementorName);
        implementors.add(testComponentBehavior);
        this.configureImplementor(isExternalImplementor, testComponentBehavior, implementorName, (CFGClassImpl)((Object)testComponent));
        return testComponentBehavior;
    }

    public ITestComponent createTestComponent() {
        TPFTestComponent testComponent = Common_TestprofileFactory.eINSTANCE.createTPFTestComponent();
        return (TPFTestComponentImpl)testComponent;
    }

    public IDecision createDecision() {
        BVRCombinedFragmentImpl testDecisionImpl = (BVRCombinedFragmentImpl)Common_Behavior_FragmentsFactory.eINSTANCE.createBVRCombinedFragment();
        testDecisionImpl.setInteractionOperator(BVRInteractionOperator.get(0));
        BVRInteractionOperandImpl successOperand = (BVRInteractionOperandImpl)Common_Behavior_FragmentsFactory.eINSTANCE.createBVRInteractionOperand();
        BVRInteractionOperandImpl failureOperand = (BVRInteractionOperandImpl)Common_Behavior_FragmentsFactory.eINSTANCE.createBVRInteractionOperand();
        testDecisionImpl.getInteractionOperands().add(0, (Object)successOperand);
        testDecisionImpl.getInteractionOperands().add(1, (Object)failureOperand);
        BVRInteractionConstraintImpl testConditionImpl = (BVRInteractionConstraintImpl)Common_Behavior_FragmentsFactory.eINSTANCE.createBVRInteractionConstraint();
        successOperand.setInteractionConstraint(testConditionImpl);
        return testDecisionImpl;
    }

    public ILoop createLoop() {
        BVRCombinedFragmentImpl testLoopImpl = (BVRCombinedFragmentImpl)Common_Behavior_FragmentsFactory.eINSTANCE.createBVRCombinedFragment();
        testLoopImpl.setInteractionOperator(BVRInteractionOperator.get(3));
        BVRInteractionOperandImpl loopOperand = (BVRInteractionOperandImpl)Common_Behavior_FragmentsFactory.eINSTANCE.createBVRInteractionOperand();
        testLoopImpl.getInteractionOperands().add((Object)loopOperand);
        BVRInteractionConstraintImpl testConditionImpl = (BVRInteractionConstraintImpl)Common_Behavior_FragmentsFactory.eINSTANCE.createBVRInteractionConstraint();
        loopOperand.setInteractionConstraint(testConditionImpl);
        return testLoopImpl;
    }

    public ISystemUnderTest createSystemUnderTest() {
        TPFSUTImpl testSUTImpl = (TPFSUTImpl)Common_TestprofileFactory.eINSTANCE.createTPFSUT();
        return testSUTImpl;
    }

    public IVerificationPoint createVerificationPoint() {
        TPFValidationActionImpl testVPImpl = (TPFValidationActionImpl)Common_TestprofileFactory.eINSTANCE.createTPFValidationAction();
        return testVPImpl;
    }

    public ITargetInvocation createTargetInvocation(IMethod method) {
        BVRMessageEndImpl msgEnd = (BVRMessageEndImpl)Common_Behavior_InteractionsFactory.eINSTANCE.createBVRMessageEnd();
        msgEnd.associateOperationToMessageEnd(method);
        return msgEnd;
    }

    public ITestInvocation createTestInvocation(ITest test) {
        BVRExecutionOccurrenceImpl execOccur = (BVRExecutionOccurrenceImpl)Common_Behavior_InteractionsFactory.eINSTANCE.createBVRExecutionOccurrence();
        execOccur.setInvokedTest(test);
        return execOccur;
    }

    public ITestComponentInvocation createTestComponentInvocation(ITestComponent component, IImplementor implementor) {
        BVRExecutionOccurrenceImpl execOccur = (BVRExecutionOccurrenceImpl)Common_Behavior_InteractionsFactory.eINSTANCE.createBVRExecutionOccurrence();
        execOccur.setInvokedTestComponent(component, implementor);
        return execOccur;
    }

    public ITestComponentInvocation createTestComponentInvocation(ITestComponent component, String implementorName) {
        BVRExecutionOccurrenceImpl execOccur = (BVRExecutionOccurrenceImpl)Common_Behavior_InteractionsFactory.eINSTANCE.createBVRExecutionOccurrence();
        execOccur.setInvokedTestComponent(component, implementorName);
        return execOccur;
    }

    public IMethod createMethod() {
        CFGOperationImpl op = (CFGOperationImpl)Common_ConfigurationFactory.eINSTANCE.createCFGOperation();
        return op;
    }

    public IProperty createProperty() {
        BVRPropertyImpl property = (BVRPropertyImpl)Common_Behavior_InteractionsFactory.eINSTANCE.createBVRProperty();
        return property;
    }

    public IVariable createVariable() {
        CFGInstanceImpl instance = (CFGInstanceImpl)Common_ConfigurationFactory.eINSTANCE.createCFGInstance();
        return instance;
    }

    public IAnnotation createAnnotation() {
        CMNAnnotationImpl instance = (CMNAnnotationImpl)CommonFactory.eINSTANCE.createCMNAnnotation();
        return instance;
    }

    public Object getObjectByID(ITestSuite testSuite, String id) {
        if (!(testSuite instanceof EObject)) {
            throw new IllegalArgumentException();
        }
        Object returnObject = null;
        returnObject = ((EObject)testSuite).eResource().getEObject(id);
        if (returnObject != null) {
            return returnObject;
        }
        EList suites = ((TPFTestSuiteImpl)testSuite).getReferencedSuites();
        if (suites == null) {
            return null;
        }
        Iterator iter = suites.iterator();
        while (iter.hasNext()) {
            returnObject = this.getObjectByID((ITestSuite)iter.next(), id);
            if (returnObject == null) continue;
            return returnObject;
        }
        return null;
    }

    public ITestSuite getTestSuiteFromObject(Object object) {
        if (!(object instanceof EObject)) {
            throw new IllegalArgumentException();
        }
        Object returnObject = null;
        EObject rootContainer = EcoreUtil.getRootContainer((EObject)((EObject)object));
        if (rootContainer instanceof ITestSuite) {
            return (ITestSuite)rootContainer;
        }
        return null;
    }

    public ITestSuite loadTestSuite(String xmiFile) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource suiteResource = resourceSet.getResource(URI.createFileURI((String)xmiFile), true);
        return (ITestSuite)suiteResource.getContents().get(0);
    }

    protected void associateBehavior(TPFBehaviorImpl behavior, ITest implementedTest) {
        if (implementedTest instanceof TPFTest) {
            TPFTest test = (TPFTest)implementedTest;
            test.setBehavior(behavior);
        }
    }

    public TPFDeployment loadDeployment(String xmiFile) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource suiteResource = resourceSet.getResource(URI.createFileURI((String)xmiFile), true);
        return (TPFDeployment)suiteResource.getContents().get(0);
    }
}

