/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.collection.threadanalyzer;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.hyades.collection.threadanalyzer.Monitor;
import org.eclipse.hyades.collection.threadanalyzer.ParseMonitorOwner;
import org.eclipse.hyades.collection.threadanalyzer.Thd;

public class ParseSystemMonitor {
    private Hashtable _sysMon = new Hashtable();
    private Hashtable _threads = null;
    private Vector _lines = null;
    private Hashtable _idents = null;

    public ParseSystemMonitor(Hashtable t, Hashtable i, Vector l) {
        this._threads = t;
        this._lines = l;
        this._idents = i;
    }

    public void doIt(int startIndex, int stopIndex) {
        String s = null;
        String line = null;
        int sIndex = -1;
        for (int i = startIndex; i < stopIndex && this._lines.size() >= i; ++i) {
            line = (String)this._lines.elementAt(i);
            if (line.indexOf("lock:") < 0 || line.indexOf("<unowned>") >= 0) continue;
            sIndex = line.indexOf("Flat locked by thread ident ");
            if (sIndex >= 0) {
                s = line.substring(sIndex + ParseMonitorOwner.FLATLOCKMSG_LEN, sIndex + ParseMonitorOwner.FLATLOCKMSG_LEN + 4);
                s = (String)this._idents.get(s);
                this.setMonOwner(line, s, i);
                continue;
            }
            sIndex = line.indexOf("owner ");
            if (sIndex < 0) continue;
            s = line.substring(line.indexOf("(") + 1, line.indexOf(")"));
            this.setMonOwner(line, s, i);
        }
    }

    public void setMonOwner(String line, String t, int index) {
        int sIndex = line.indexOf(":", line.indexOf(":") + 1);
        String s = line.substring(0, sIndex);
        s = s.substring(s.lastIndexOf(":") + 1).trim();
        Monitor monitor = new Monitor(s, 0);
        Thd thread = (Thd)this._threads.get(t);
        if (thread != null) {
            monitor.setOwner(thread);
            monitor._name = s;
            this.setWaiters(index, monitor);
            this.addSystemMonitor(s, monitor);
        }
    }

    public void setWaiters(int index, Monitor monitor) {
        String line = (String)this._lines.elementAt(++index);
        int sIndex = line.indexOf("Waiting to be notified:");
        int p1 = -1;
        int p2 = -1;
        if (sIndex >= 0) {
            while (this._lines.size() >= ++index && (line = (String)this._lines.elementAt(index)).indexOf(" lock: ") < 0) {
                p1 = line.indexOf("(");
                p2 = line.indexOf(")");
                if (p1 < 0 || p2 < 0) break;
                line = line.substring(p1 + 1, p2);
                monitor._waiters.add(this._threads.get(line));
            }
        }
    }

    public void addSystemMonitor(String key, Monitor value) {
        this._sysMon.put(key, value);
    }

    public Hashtable getSysMon() {
        return this._sysMon;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        Iterator i = this._sysMon.keySet().iterator();
        sb.append("System Monitor Dump\n");
        while (i.hasNext()) {
            sb.append("Monitor=\n");
            String name = (String)i.next();
            Monitor m = (Monitor)this._sysMon.get(name);
            sb.append(m.getName()).append("\n");
            sb.append(m._owner._threadId).append("\n");
            if (m._waiters.size() > 0) {
                sb.append("Waiting sys_thread_t\n");
                for (int j = 0; j < m._waiters.size(); ++j) {
                    sb.append(((Thd)m._waiters.get((int)j))._threadId).append("\n");
                }
                continue;
            }
            sb.append("No Waiters\n");
        }
        return sb.toString();
    }
}

