/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.loaders.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.loaders.util.HyadesResourceRegistryReader;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.models.hierarchy.plugin.HierarchyPlugin;
import org.eclipse.hyades.models.hierarchy.util.IHyadesResourceExtension;

public class HyadesResourceExtensions
extends HashMap {
    private static HyadesResourceExtensions instance;
    private IHyadesResourceExtension defaultHyadesResourceFactory;
    private Properties defaultProperties = new Properties();

    public static HyadesResourceExtensions getInstance() {
        if (instance == null) {
            instance = new HyadesResourceExtensions();
            new HyadesResourceRegistryReader().readRegistry();
            try {
                Preferences preferences = HierarchyPlugin.getPlugin().getPluginPreferences();
                Iterator iter = instance.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry element = iter.next();
                    IHyadesResourceExtension hyadesResourceFactory = (IHyadesResourceExtension)element.getValue();
                    if (HyadesResourceExtensions.instance.defaultHyadesResourceFactory != null || !preferences.getString("largeResourceSupportCurrentDBType").equals(hyadesResourceFactory.getStoreType((String)element.getKey()))) continue;
                    String defaultStoreTypeName = preferences.getString("largeResourceSupportCurrentDBType");
                    HyadesResourceExtensions.instance.defaultHyadesResourceFactory = hyadesResourceFactory;
                    HyadesResourceExtensions.instance.defaultProperties.setProperty("location", preferences.getString(defaultStoreTypeName + "/" + "largeResourceSupportLocation"));
                    HyadesResourceExtensions.instance.defaultProperties.setProperty("user", preferences.getString(defaultStoreTypeName + "/" + "largeResourceSupportUsername"));
                    HyadesResourceExtensions.instance.defaultProperties.setProperty("password", LoadersUtils.restorePassword(preferences.getString(defaultStoreTypeName + "/" + "largeResourceSupportPassword")));
                    HyadesResourceExtensions.instance.defaultProperties.setProperty("cacheSize", preferences.getString(defaultStoreTypeName + "/" + "largeResourceSupportCacheSize"));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return instance;
    }

    public Resource createResource(URI uri) {
        IHyadesResourceExtension hyadesResourceExtension = (IHyadesResourceExtension)HyadesResourceExtensions.getInstance().get(LoadersUtils.getPostfix(uri));
        if (hyadesResourceExtension == null) {
            return null;
        }
        return hyadesResourceExtension.createResource(uri, this.defaultProperties);
    }

    public EList createList(Class dataClass, InternalEObject owner, int featureID, int inverseFeatureID) {
        IHyadesResourceExtension hyadesResourceFactory = this.getHyadesResourceFactory(owner);
        if (hyadesResourceFactory == null) {
            return null;
        }
        return hyadesResourceFactory.createPagingList(dataClass, (EObject)owner, featureID, inverseFeatureID);
    }

    public EList createList(Class dataClass, InternalEObject owner, int featureID) {
        IHyadesResourceExtension hyadesResourceFactory = this.getHyadesResourceFactory(owner);
        if (hyadesResourceFactory == null) {
            return null;
        }
        return hyadesResourceFactory.createPagingList(dataClass, (EObject)owner, featureID);
    }

    public EList createList(InternalEObject owner, EStructuralFeature feature) {
        IHyadesResourceExtension hyadesResourceFactory = this.getHyadesResourceFactory(owner);
        if (hyadesResourceFactory == null) {
            return null;
        }
        return hyadesResourceFactory.createPagingList((EObject)owner, feature);
    }

    private IHyadesResourceExtension getHyadesResourceFactory(InternalEObject owner) {
        Resource resource = owner.eResource();
        if (resource == null) {
            if (this.defaultHyadesResourceFactory != null) {
                return this.defaultHyadesResourceFactory;
            }
            return null;
        }
        URI uri = resource.getURI();
        if (uri == null) {
            return null;
        }
        IHyadesResourceExtension hyadesResourceFactory = (IHyadesResourceExtension)HyadesResourceExtensions.getInstance().get(LoadersUtils.getPostfix(uri));
        return hyadesResourceFactory;
    }

    public Resource createResource(URI uri, Collection notLoaded) {
        IHyadesResourceExtension hyadesResourceExtension = (IHyadesResourceExtension)HyadesResourceExtensions.getInstance().get(LoadersUtils.getPostfix(uri));
        if (hyadesResourceExtension == null) {
            return null;
        }
        return hyadesResourceExtension.createResource(uri, this.defaultProperties, notLoaded);
    }

    public Properties getProperties() {
        return this.defaultProperties;
    }
}

