/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.execution.local.common;

import java.util.Vector;
import org.eclipse.hyades.internal.execution.local.common.Message;
import org.eclipse.hyades.internal.execution.local.common.RAString;
import org.eclipse.hyades.internal.execution.local.common.SimpleProcessCommand;

public class ActiveAgentListCommand
extends SimpleProcessCommand {
    protected Vector _agents = new Vector();
    protected RAString _processName = new RAString("");

    public ActiveAgentListCommand() {
        this._tag = 34L;
    }

    public String[] getAgents() {
        int length = this._agents.size();
        String[] results = new String[length];
        for (int i = 0; i < length; ++i) {
            results[i] = ((RAString)this._agents.elementAt(i)).getData();
        }
        return results;
    }

    public String getProcessName() {
        return this._processName.getData();
    }

    public int getSize() {
        int size = super.getSize();
        size += this._processName.getSize();
        size += 4;
        for (int i = 0; i < this._agents.size(); ++i) {
            size += ((RAString)this._agents.elementAt(i)).getSize();
        }
        return size;
    }

    public int readFromBuffer(byte[] buffer, int offset) {
        int current = super.readFromBuffer(buffer, offset);
        current = Message.readRAStringFromBuffer(buffer, current, this._processName);
        long listLength = Message.readRALongFromBuffer(buffer, current);
        current += 4;
        int i = 0;
        while ((long)i < listLength) {
            RAString agent = new RAString("");
            current = Message.readRAStringFromBuffer(buffer, current, agent);
            this._agents.addElement(agent);
            ++i;
        }
        return current;
    }

    public int writeToBuffer(byte[] buffer, int offset) {
        int current = super.writeToBuffer(buffer, offset);
        current = Message.writeRAStringToBuffer(buffer, current, this._processName);
        current = Message.writeRALongToBuffer(buffer, current, this._agents.size());
        for (int i = 0; i < this._agents.size(); ++i) {
            current = Message.writeRAStringToBuffer(buffer, current, (RAString)this._agents.elementAt(i));
        }
        return current;
    }
}

