/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.jvm.threadanalysis;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.hyades.collection.threadanalyzer.DumpData;
import org.eclipse.hyades.collection.threadanalyzer.Monitor;
import org.eclipse.hyades.collection.threadanalyzer.StkEntry;
import org.eclipse.hyades.collection.threadanalyzer.StkEntryNative;
import org.eclipse.hyades.collection.threadanalyzer.Thd;
import org.eclipse.hyades.logging.events.EventItemsFactory;
import org.eclipse.hyades.logging.events.IAssociatedEvent;
import org.eclipse.hyades.logging.events.IAssociationEngine;
import org.eclipse.hyades.logging.events.ICommonBaseEvent;
import org.eclipse.hyades.logging.events.IComponentIdentification;
import org.eclipse.hyades.logging.events.IExtendedDataElement;
import org.eclipse.hyades.logging.events.IReportSituation;
import org.eclipse.hyades.logging.events.ISimpleEventFactory;
import org.eclipse.hyades.logging.events.ISituation;
import org.eclipse.hyades.logging.events.ISituationType;
import org.eclipse.hyades.logging.events.SimpleEventFactoryImpl;
import org.eclipse.hyades.logging.jvm.threadanalysis.ThreadDumpProcessor;

public class ThreadDumpProcessorImpl
implements ThreadDumpProcessor {
    private ISimpleEventFactory _simpleEventFactory;
    private IComponentIdentification _compId;
    private ISituation _situation;
    private IAssociationEngine _associationEngine;

    public Vector generateCBEs(DumpData dd) {
        Vector cbes = new Vector();
        IAssociatedEvent associatedThreadsEvent = this._simpleEventFactory.createAssociatedEvent();
        this._compId.setComponent(dd.getDumpingJvmName());
        ICommonBaseEvent cbeThdDump = this.createCBE("ThreadDump", null, cbes);
        cbeThdDump.addExtendedDataElement("Type", "Java");
        cbeThdDump.addExtendedDataElement("Description", dd.getDescription());
        cbeThdDump.addExtendedDataElement("DisplayName", dd.getDisplayName());
        ICommonBaseEvent cbeThreads = this.createCBE("Threads", cbeThdDump, cbes);
        IExtendedDataElement xdeThreads = cbeThdDump.addExtendedDataElementWithIntValue("Threads", dd.getThreads().size());
        this.addThreads(dd, xdeThreads, cbeThreads, cbes);
        ICommonBaseEvent cbeMonitors = this.createCBE("Monitors", cbeThdDump, cbes);
        IExtendedDataElement xdeMonitors = cbeThdDump.addExtendedDataElementWithIntValue("Monitors", dd.getMonitors().size());
        this.addMonitors(dd, xdeMonitors, cbeMonitors, cbes);
        return cbes;
    }

    private ICommonBaseEvent createCBE(String type, ICommonBaseEvent parentCbe, Vector cbes) {
        ICommonBaseEvent childCbe = this._simpleEventFactory.createCommonBaseEvent("CBE:" + type, new Date().getTime());
        childCbe.setSeverity((short)10);
        childCbe.setMsg(type);
        childCbe.setSourceComponentId(this._compId);
        childCbe.setSituation(this._situation);
        if (parentCbe != null) {
            IAssociatedEvent cbeAssociatedEvent = this._simpleEventFactory.createAssociatedEvent();
            cbeAssociatedEvent.setAssociationEngineInfo(this._associationEngine);
            cbeAssociatedEvent.addResolvedEvent(childCbe.getGlobalInstanceId());
            parentCbe.addAssociatedEvent(cbeAssociatedEvent);
        }
        cbes.add(childCbe);
        return childCbe;
    }

    private void addThreads(DumpData dd, IExtendedDataElement xdeThreads, ICommonBaseEvent cbeThreads, Vector cbes) {
        Thd currThd;
        int i = 0;
        cbeThreads.addExtendedDataElementWithIntValue("Thread Count", dd.getThreads().size());
        Enumeration enumThreads = dd.getThreadEnum();
        while ((currThd = dd.getNextThread(enumThreads)) != null) {
            this.createThreadCbe(cbeThreads, currThd, i, cbes);
            ++i;
        }
    }

    private IExtendedDataElement createThreadXde(IExtendedDataElement xdeThreads, Thd currThd, int i) {
        IExtendedDataElement xdeCurrThread = xdeThreads.addChildWithIntValue("Thread_" + i, i);
        xdeCurrThread.addChild("threadId", currThd.getThreadId());
        xdeCurrThread.addChild("name", currThd.getName());
        xdeCurrThread.addChild("priority", currThd._priority);
        xdeCurrThread.addChild("state", currThd._state);
        xdeCurrThread.addChildWithIntValue("waitMonitorID", currThd.getWaitMonitorId());
        if (currThd._waitMonitor != null) {
            xdeCurrThread.addChild("waitMonitorKey", currThd._waitMonitor.getName());
        }
        IExtendedDataElement xdeStkEntries = xdeCurrThread.addChildWithIntValue("StackEntries", currThd.getStkSize());
        IExtendedDataElement xdeStkEntriesNative = xdeCurrThread.addChildWithIntValue("StackEntriesNative", currThd.getStkNativeSize());
        this.addStackEntries(currThd, xdeStkEntries);
        this.addStackEntriesNative(currThd, xdeStkEntriesNative);
        return xdeCurrThread;
    }

    private ICommonBaseEvent createThreadCbe(ICommonBaseEvent parentCbe, Thd currThd, int i, Vector cbes) {
        ICommonBaseEvent cbeCurrThread = this.createCBE("Thread" + i, parentCbe, cbes);
        cbeCurrThread.addExtendedDataElementWithIntValue("Thread Index", i);
        cbeCurrThread.addExtendedDataElement("threadId", currThd.getThreadId());
        cbeCurrThread.addExtendedDataElement("name", currThd.getName());
        cbeCurrThread.addExtendedDataElement("priority", currThd._priority);
        cbeCurrThread.addExtendedDataElement("state", currThd._state);
        cbeCurrThread.addExtendedDataElementWithIntValue("waitMonitorID", currThd.getWaitMonitorId());
        if (currThd._waitMonitor != null) {
            cbeCurrThread.addExtendedDataElement("waitMonitorKey", currThd._waitMonitor.getName());
        }
        IExtendedDataElement xdeStkEntries = cbeCurrThread.addExtendedDataElementWithIntValue("StackEntries", currThd.getStkSize());
        IExtendedDataElement xdeStkEntriesNative = cbeCurrThread.addExtendedDataElementWithIntValue("StackEntriesNative", currThd.getStkNativeSize());
        this.addStackEntries(currThd, xdeStkEntries);
        this.addStackEntriesNative(currThd, xdeStkEntriesNative);
        return cbeCurrThread;
    }

    private void addStackEntries(Thd currThd, IExtendedDataElement xdeStkEntries) {
        for (int j = 0; j < currThd.getStkSize(); ++j) {
            StkEntry currStkEntry = currThd.getStkEntry(j);
            IExtendedDataElement xdeCurrStkEntry = xdeStkEntries.addChildWithIntValue("StkEntry_" + j, j);
            xdeCurrStkEntry.addChild("module", currStkEntry._module);
            xdeCurrStkEntry.addChild("pkg", currStkEntry._pkg);
            xdeCurrStkEntry.addChild("method", currStkEntry._method);
            xdeCurrStkEntry.addChildWithIntValue("lineno", currStkEntry._lineno);
            xdeCurrStkEntry.addChildWithBooleanValue("isNative", currStkEntry._isNative);
        }
    }

    private void addStackEntriesNative(Thd currThd, IExtendedDataElement xdeStkEntriesNative) {
        for (int j = 0; j < currThd.getStkNativeSize(); ++j) {
            StkEntryNative currStkEntryNative = currThd.getStkEntryNative(j);
            IExtendedDataElement xdeCurrStkEntryNative = xdeStkEntriesNative.addChildWithIntValue("StkEntryNative_" + j, j);
            xdeCurrStkEntryNative.addChild("function", currStkEntryNative._function);
            xdeCurrStkEntryNative.addChild("hexAddress", currStkEntryNative._hexAddress);
        }
    }

    private void addMonitors(DumpData dd, IExtendedDataElement xdeMonitors, ICommonBaseEvent cbeMonitors, Vector cbes) {
        Monitor currMon;
        int i = 0;
        cbeMonitors.addExtendedDataElementWithIntValue("Monitor Count", dd.getMonitors().size());
        Enumeration enumMonitors = dd.getMonitorEnum();
        while ((currMon = dd.getNextMonitor(enumMonitors)) != null) {
            this.createMonitorCbe(cbeMonitors, currMon, i, cbes);
            ++i;
        }
    }

    private void createMonitorXde(IExtendedDataElement xdeMonitors, Monitor currMon, int i) {
        IExtendedDataElement xdeCurrMonitor = xdeMonitors.addChildWithIntValue("Monitor" + i, i);
        int waitersSize = currMon._waiters.size();
        xdeCurrMonitor.addChild("name", currMon.getName());
        if (currMon._owner != null) {
            xdeCurrMonitor.addChild("ownerThreadId", currMon._owner._threadId);
            xdeCurrMonitor.addChild("ownerThreadName", currMon._owner.getName());
        }
        xdeCurrMonitor.addChildWithIntValue("monitor_type", currMon._monitor_type);
        if (waitersSize > 0) {
            IExtendedDataElement xdeWaiters = xdeCurrMonitor.addChildWithIntValue("Waiters", waitersSize);
            this.addWaiters(currMon, xdeWaiters);
        }
    }

    private void createMonitorCbe(ICommonBaseEvent parentCbe, Monitor currMon, int i, Vector cbes) {
        ICommonBaseEvent cbeCurrMonitor = this.createCBE("Monitor" + i, parentCbe, cbes);
        int waitersSize = currMon._waiters.size();
        cbeCurrMonitor.addExtendedDataElementWithIntValue("Monitor Index", i);
        cbeCurrMonitor.addExtendedDataElement("name", currMon.getName());
        if (currMon._owner != null) {
            cbeCurrMonitor.addExtendedDataElement("ownerThreadId", currMon._owner._threadId);
            cbeCurrMonitor.addExtendedDataElement("ownerThreadName", currMon._owner.getName());
        }
        cbeCurrMonitor.addExtendedDataElementWithIntValue("monitor_type", currMon._monitor_type);
        if (waitersSize > 0) {
            IExtendedDataElement xdeWaiters = cbeCurrMonitor.addExtendedDataElementWithIntValue("Waiters", waitersSize);
            this.addWaiters(currMon, xdeWaiters);
        }
    }

    private void addWaiters(Monitor currMon, IExtendedDataElement xdeWaiters) {
        Vector waiters = currMon._waiters;
        int waitersSize = currMon._waiters.size();
        for (int j = 0; j < waitersSize; ++j) {
            Thd currWaiter = (Thd)waiters.elementAt(j);
            IExtendedDataElement xdeCurrWaiter = xdeWaiters.addChildWithIntValue("Waiter_" + j, j);
            xdeCurrWaiter.addChild("ThreadId", currWaiter.getThreadId());
            xdeCurrWaiter.addChild("ThreadName", currWaiter.getName());
        }
    }

    public ThreadDumpProcessorImpl() {
        String hostname = null;
        this._simpleEventFactory = SimpleEventFactoryImpl.getInstance();
        try {
            hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            hostname = "localhost";
        }
        try {
            IReportSituation repSituation = this._simpleEventFactory.createReportSituation();
            repSituation.setReportCategory("Trace");
            this._situation = EventItemsFactory.createISituation((String)"ReportSituation", (ISituationType)repSituation);
            this._compId = EventItemsFactory.createIComponentIdentification((String)"ProductName", (String)"Dummy", (String)"Thread/Monitor dump", (String)"Hostname", (String)hostname, null, null, null, null, null, (String)"JAVA JVM");
            this._associationEngine = this._simpleEventFactory.createAssociationEngine();
            this._associationEngine.setType("Root");
            this._associationEngine.setName("Root");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

