/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.common.facades.behavioral.impl;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.hyades.models.common.facades.behavioral.impl.HyadesCommon_Behavior_FragmentsAdapterFactory;
import org.eclipse.hyades.models.common.facades.behavioral.impl.HyadesCommon_TestprofileAdapterFactory;
import org.eclipse.hyades.models.common.fragments.Common_Behavior_FragmentsPackage;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage;
import org.eclipse.hyades.models.common.util.FileUtil;

public class FacadeResourceImpl
extends XMIResourceImpl {
    private File annotationDir = null;

    public FacadeResourceImpl() {
    }

    public FacadeResourceImpl(URI arg0) {
        super(arg0);
    }

    public void attached(EObject arg0) {
        AdapterFactoryImpl adaptorFactory;
        super.attached(arg0);
        if (arg0.eClass().equals(Common_TestprofilePackage.eINSTANCE.getTPFTestSuite())) {
            adaptorFactory = new HyadesCommon_TestprofileAdapterFactory();
            adaptorFactory.adapt((Notifier)arg0, (Object)Common_TestprofilePackage.eINSTANCE.getTPFTestSuite());
        }
        if (arg0.eClass().equals(Common_Behavior_FragmentsPackage.eINSTANCE.getBVRInteraction())) {
            adaptorFactory = new HyadesCommon_Behavior_FragmentsAdapterFactory();
            adaptorFactory.adapt((Notifier)arg0, (Object)Common_Behavior_FragmentsPackage.eINSTANCE.getBVRInteraction());
        }
        if (arg0.eClass().equals(Common_Behavior_FragmentsPackage.eINSTANCE.getBVRInteractionOperand())) {
            adaptorFactory = new HyadesCommon_Behavior_FragmentsAdapterFactory();
            adaptorFactory.adapt((Notifier)arg0, (Object)Common_Behavior_FragmentsPackage.eINSTANCE.getBVRInteractionOperand());
        }
        if (arg0.eClass().equals(Common_TestprofilePackage.eINSTANCE.getTPFTestComponent())) {
            adaptorFactory = new HyadesCommon_TestprofileAdapterFactory();
            adaptorFactory.adapt((Notifier)arg0, (Object)Common_TestprofilePackage.eINSTANCE.getTPFTestComponent());
        }
    }

    public void detached(EObject arg0) {
        super.detached(arg0);
        arg0.eAdapters().clear();
    }

    public void doLoad(InputStream inputStream, Map options) throws IOException {
        if (inputStream instanceof ZipInputStream) {
            int count;
            ZipInputStream zipIn = (ZipInputStream)inputStream;
            File tempResourceContents = File.createTempFile("tempResouce", "");
            FileOutputStream file = new FileOutputStream(tempResourceContents);
            BufferedOutputStream bufFile = new BufferedOutputStream(file);
            int bufSize = 65536;
            byte[] readBuffer = new byte[bufSize];
            while ((count = zipIn.read(readBuffer, 0, bufSize)) != -1) {
                bufFile.write(readBuffer, 0, count);
            }
            bufFile.close();
            ZipEntry entry = zipIn.getNextEntry();
            if (entry != null) {
                URI baseAnnotationDirURI = URI.createFileURI((String)this.getAnnotationDir().getAbsolutePath());
                while (entry != null) {
                    String entryName = entry.getName();
                    URI relativeURI = URI.createURI((String)entryName);
                    URI fileURI = relativeURI.resolve(baseAnnotationDirURI);
                    File dest = new File(fileURI.toFileString());
                    if (!dest.getParentFile().exists()) {
                        dest.getParentFile().mkdirs();
                    }
                    file = new FileOutputStream(fileURI.toFileString());
                    bufFile = new BufferedOutputStream(file);
                    while ((count = zipIn.read(readBuffer, 0, bufSize)) != -1) {
                        bufFile.write(readBuffer, 0, count);
                    }
                    bufFile.close();
                    entry = zipIn.getNextEntry();
                }
            }
            FileInputStream fileIn = new FileInputStream(tempResourceContents);
            BufferedInputStream bufIn = new BufferedInputStream(fileIn);
            super.doLoad((InputStream)bufIn, options);
            bufIn.close();
            tempResourceContents.delete();
        } else {
            super.doLoad(inputStream, options);
        }
    }

    public void doSave(OutputStream outputStream, Map options) throws IOException {
        super.doSave(outputStream, options);
        if (this.hasAnnotations() && outputStream instanceof ZipOutputStream) {
            ZipOutputStream zipOut = (ZipOutputStream)outputStream;
            File annotationDir = this.getAnnotationDir();
            URI baseAnnotationDirURI = URI.createFileURI((String)annotationDir.getAbsolutePath());
            File[] annotations = FileUtil.listAllFiles(annotationDir);
            if (annotations == null) {
                return;
            }
            for (int i = 0; i < annotations.length; ++i) {
                int count;
                URI currentFile = URI.createFileURI((String)annotations[i].getAbsolutePath());
                URI relativeURI = currentFile.deresolve(baseAnnotationDirURI);
                FileInputStream in = new FileInputStream(annotations[i]);
                ZipEntry entry = new ZipEntry(relativeURI.toString());
                entry.setMethod(0);
                entry.setSize(annotations[i].length());
                CRC32 crc = new CRC32();
                BufferedInputStream contentStream = new BufferedInputStream(in);
                int bufSize = 65536;
                byte[] readBuffer = new byte[bufSize];
                while ((count = contentStream.read(readBuffer, 0, bufSize)) != -1) {
                    crc.update(readBuffer, 0, count);
                }
                contentStream.close();
                entry.setCrc(crc.getValue());
                zipOut.putNextEntry(entry);
                in = new FileInputStream(annotations[i]);
                contentStream = new BufferedInputStream(in);
                while ((count = contentStream.read(readBuffer, 0, bufSize)) != -1) {
                    zipOut.write(readBuffer, 0, count);
                }
                zipOut.closeEntry();
                contentStream.close();
            }
        }
    }

    public boolean hasAnnotations() {
        return this.annotationDir != null;
    }

    public synchronized File getAnnotationDir() throws IOException {
        if (this.annotationDir != null) {
            return this.annotationDir;
        }
        File systemTempDir = FileUtil.getTempDir();
        File temp = File.createTempFile("Hyades.TestModel.AnnotationDir", "", systemTempDir);
        if (temp.delete() && temp.mkdir()) {
            this.annotationDir = new File(temp, "annotations");
            if (!this.annotationDir.mkdir()) {
                throw new IOException("Unable to create new annotation Dir " + this.annotationDir.getAbsolutePath());
            }
        } else {
            throw new IOException("Unable to create new annotation Dir " + temp.getAbsolutePath());
        }
        return this.annotationDir;
    }

    protected void finalize() throws Throwable {
        this.cleanupAnnotationDir();
        super.finalize();
    }

    public void cleanup() {
        this.cleanupAnnotationDir();
    }

    private void cleanupAnnotationDir() {
        if (this.hasAnnotations()) {
            FileUtil.deltree(this.annotationDir.getParentFile());
        }
    }

    protected void doUnload() {
        super.doUnload();
        this.cleanupAnnotationDir();
    }
}

