/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.hierarchy.util;

public final class IndexHashTable {
    public Object[] keyTable;
    public int[] valueTable;
    int elementSize = 0;
    int threshold;

    public IndexHashTable() {
        this(13);
    }

    public IndexHashTable(int size) {
        this.threshold = size;
        int extraRoom = (int)((float)size * 1.75f);
        if (this.threshold == extraRoom) {
            ++extraRoom;
        }
        this.keyTable = new Object[extraRoom];
        this.valueTable = new int[extraRoom];
    }

    public boolean containsKey(Object key) {
        Object currentKey;
        int index = key.hashCode() % this.valueTable.length;
        while ((currentKey = this.keyTable[index]) != null) {
            if (currentKey == key) {
                return true;
            }
            index = (index + 1) % this.keyTable.length;
        }
        return false;
    }

    public int get(Object key) {
        Object currentKey;
        int index = key.hashCode() % this.valueTable.length;
        while ((currentKey = this.keyTable[index]) != null) {
            if (currentKey == key) {
                return this.valueTable[index];
            }
            index = (index + 1) % this.keyTable.length;
        }
        return -1;
    }

    public int put(Object key, int value) {
        Object currentKey;
        int index = key.hashCode() % this.valueTable.length;
        while ((currentKey = this.keyTable[index]) != null) {
            if (currentKey == key) {
                this.valueTable[index] = value;
                return this.valueTable[index];
            }
            index = (index + 1) % this.keyTable.length;
        }
        this.keyTable[index] = key;
        this.valueTable[index] = value;
        if (++this.elementSize > this.threshold) {
            this.rehash();
        }
        return value;
    }

    private void rehash() {
        IndexHashTable newHashtable = new IndexHashTable(this.elementSize * 2);
        int i = this.keyTable.length;
        while (--i >= 0) {
            Object currentKey = this.keyTable[i];
            if (currentKey == null) continue;
            newHashtable.put(currentKey, this.valueTable[i]);
        }
        this.keyTable = newHashtable.keyTable;
        this.valueTable = newHashtable.valueTable;
        this.threshold = newHashtable.threshold;
    }

    public int size() {
        return this.elementSize;
    }

    public String toString() {
        String s = "";
        int length = this.valueTable.length;
        for (int i = 0; i < length; ++i) {
            int object = this.valueTable[i];
            if (object == -1) continue;
            s = s + this.keyTable[i] + " -> " + object + "\n";
        }
        return s;
    }
}

