/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.execution.local.common;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.Vector;
import org.eclipse.hyades.internal.execution.local.common.Constants;
import org.eclipse.hyades.internal.execution.local.common.DataProcessor;
import org.eclipse.hyades.internal.execution.local.common.DataServerListener;
import org.eclipse.hyades.internal.execution.local.common.Message;

public final class TCPDataServer {
    private ServerSocket _sock = null;
    private TCPDataProcessor _server = null;
    private BufferFlusher _flusher = null;
    private int _port;
    private static final short NUM_BUFFERS = 32;
    private SingleBuffer[] _bufferArray;
    private short _currentFullBuffers = 0;
    public static final byte BINARY_DATA = 0;
    public static final byte UTF8_STRING_DATA = 1;
    public static final byte UNICODE_STRING_DATA = 2;
    private Vector _dataServerListeners = new Vector();

    public int getPort() {
        return this._port;
    }

    public InetAddress getServerAddress() {
        return this._sock.getInetAddress();
    }

    public void startServer(DataProcessor processor, int port) throws SocketException, IOException {
        this._bufferArray = new SingleBuffer[32];
        for (int i = 0; i < 32; ++i) {
            this._bufferArray[i] = new SingleBuffer();
        }
        this._sock = new ServerSocket(port);
        this._port = this._sock.getLocalPort();
        this._server = new TCPDataProcessor();
        this._server.setSocket(this._sock);
        this._server.setName("TCPDataFiller");
        this._flusher = new BufferFlusher();
        this._flusher.setProcessor(processor);
        this._flusher.setName("TCPDataFlusher");
        this._server.setDaemon(true);
        this._flusher.setDaemon(true);
        this._flusher.setPriority(this._server.getPriority() + 3);
        this._server.start();
        this._flusher.start();
    }

    public void startServer(DataProcessor processor) throws SocketException, IOException {
        this.startServer(processor, 0);
    }

    public boolean isProcessing() {
        return this._server.isAlive();
    }

    public void stopServer() {
        this._server.pauseProcessing();
    }

    public void resumeServer() {
        this._server.resumeProcessing();
    }

    public void resumeServer(DataProcessor processor) {
        this._flusher.setProcessor(processor);
        this._server.resumeProcessing();
    }

    public void shutdownServer() {
        this._server.shutdown();
    }

    static /* synthetic */ short access$008(TCPDataServer x0) {
        short s = x0._currentFullBuffers;
        x0._currentFullBuffers = (short)(s + 1);
        return s;
    }

    static /* synthetic */ short access$010(TCPDataServer x0) {
        short s = x0._currentFullBuffers;
        x0._currentFullBuffers = (short)(s - 1);
        return s;
    }

    class BufferFlusher
    extends Thread
    implements Constants {
        private DataProcessor _processor = null;
        private byte[] _binaryForwardBuffer = new byte[8096];
        private char[] _stringForwardBuffer = new char[8096];
        private byte[] _messageHeader = new byte[10];
        private long _currentBufferSize = 8096L;
        private short _currentFlusherBuffer = 0;
        private int _currentHeaderOffset = 0;
        private int _bytesWritten = 0;

        BufferFlusher() {
        }

        public void setProcessor(DataProcessor processor) {
            this._processor = processor;
        }

        protected int loadMessageHeader(byte[] data, int offset, int limit) {
            while (offset < limit && this._currentHeaderOffset < 10) {
                this._messageHeader[this._currentHeaderOffset++] = data[offset++];
            }
            return offset;
        }

        protected long getMessageLength() {
            return Message.readRALongFromBuffer(this._messageHeader, 5);
        }

        protected byte getMessageType() {
            return this._messageHeader[9];
        }

        protected boolean checkMessageMagic() {
            long messageKey = (long)(this._messageHeader[0] << 24 & 0xFF000000) | (long)(this._messageHeader[1] << 16 & 0xFF0000) | (long)this._messageHeader[2] << 8 & 0xFF00L | (long)this._messageHeader[3];
            return true;
        }

        protected int processData(byte[] data, int offset, int limit, InetAddress addr) {
            int current = offset;
            if (offset >= limit) {
                return limit;
            }
            if (this._currentHeaderOffset < 10) {
                if ((current = this.loadMessageHeader(data, current, limit)) == limit) {
                    return current;
                }
                if (this.getMessageLength() >= this._currentBufferSize) {
                    byte type = this.getMessageType();
                    if (type == 0 || type == 1) {
                        byte[] replacement = new byte[(int)this.getMessageLength()];
                        System.arraycopy(data, current, replacement, 0, limit - current);
                        this._bytesWritten = limit - current;
                        this._binaryForwardBuffer = replacement;
                    } else {
                        char[] replacement = new char[(int)this.getMessageLength()];
                        for (int i = 0; i < limit - current + 1; ++i) {
                            replacement[i] = (char)data[i + current];
                        }
                        this._bytesWritten = limit - current;
                        this._stringForwardBuffer = replacement;
                    }
                    return limit;
                }
            }
            if (!this.checkMessageMagic()) {
                System.out.println("Corrupt data");
                this._currentHeaderOffset = 0;
                return this.processData(data, offset + 1, limit, addr);
            }
            long messageLength = this.getMessageLength();
            byte type = this.getMessageType();
            while (current < limit) {
                if (type == 0 || type == 1) {
                    while (current < limit && (long)this._bytesWritten < messageLength) {
                        this._binaryForwardBuffer[this._bytesWritten++] = data[current++];
                    }
                    if ((long)this._bytesWritten != messageLength) continue;
                    this._processor.incommingData(this._binaryForwardBuffer, this._bytesWritten, addr);
                    this._bytesWritten = 0;
                    this._currentHeaderOffset = 0;
                    current = this.processData(data, current, limit, addr);
                    continue;
                }
                if (type == 2) {
                    while (offset < limit && (long)this._bytesWritten < messageLength) {
                        this._stringForwardBuffer[this._bytesWritten >> 1] = (char)((char)data[current++] | (char)(data[current++] << 8));
                        this._bytesWritten += 2;
                    }
                    if ((long)this._bytesWritten != messageLength) continue;
                    this._processor.incommingData(this._stringForwardBuffer, this._bytesWritten, addr);
                    this._bytesWritten = 0;
                    this._currentHeaderOffset = 0;
                    current = this.processData(data, current, limit, addr);
                    continue;
                }
                while (offset < limit && (long)this._bytesWritten < messageLength) {
                    this._binaryForwardBuffer[this._bytesWritten++] = data[current++];
                }
                if ((long)this._bytesWritten != messageLength) continue;
                this._processor.incommingData(this._binaryForwardBuffer, this._bytesWritten, addr);
                this._bytesWritten = 0;
                this._currentHeaderOffset = 0;
                current = this.processData(data, current, limit, addr);
            }
            return current;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block8: while (TCPDataServer.this.isProcessing() || TCPDataServer.this._currentFullBuffers != 0) {
                SingleBuffer singleBuffer;
                if (TCPDataServer.this._currentFullBuffers == 0) {
                    this._processor.waitingForData();
                    do {
                        singleBuffer = TCPDataServer.this._bufferArray[0];
                        synchronized (singleBuffer) {
                            try {
                                TCPDataServer.this._bufferArray[0].wait(1000L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                        if (!TCPDataServer.this.isProcessing() && TCPDataServer.this._currentFullBuffers == 0) break block8;
                    } while (TCPDataServer.this._currentFullBuffers == 0);
                }
                if (((TCPDataServer)TCPDataServer.this)._bufferArray[this._currentFlusherBuffer].length > 0) {
                    this.processData(((TCPDataServer)TCPDataServer.this)._bufferArray[this._currentFlusherBuffer].data, 0, ((TCPDataServer)TCPDataServer.this)._bufferArray[this._currentFlusherBuffer].length, ((TCPDataServer)TCPDataServer.this)._bufferArray[this._currentFlusherBuffer].addr);
                    ((TCPDataServer)TCPDataServer.this)._bufferArray[this._currentFlusherBuffer].length = 0;
                }
                singleBuffer = TCPDataServer.this._bufferArray[0];
                synchronized (singleBuffer) {
                    TCPDataServer.access$010(TCPDataServer.this);
                    this._currentFlusherBuffer = (short)(this._currentFlusherBuffer + 1);
                    if (this._currentFlusherBuffer == 32) {
                        this._currentFlusherBuffer = 0;
                    }
                    if (TCPDataServer.this._currentFullBuffers == 0) {
                        TCPDataServer.this._bufferArray[0].notifyAll();
                    }
                }
            }
            if (this._processor instanceof DataServerListener) {
                ((DataServerListener)this._processor).dataServerExited();
            }
        }
    }

    class TCPDataProcessor
    extends Thread
    implements Constants {
        ServerSocket _socket;
        boolean _processing = true;
        boolean _shutdown = false;
        private short _currentFillerBuffer = 0;

        TCPDataProcessor() {
        }

        public void setSocket(ServerSocket sock) {
            this._socket = sock;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resumeProcessing() {
            TCPDataProcessor tCPDataProcessor = this;
            synchronized (tCPDataProcessor) {
                this._processing = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void pauseProcessing() {
            TCPDataProcessor tCPDataProcessor = this;
            synchronized (tCPDataProcessor) {
                this._processing = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isProcessing() {
            TCPDataProcessor tCPDataProcessor = this;
            synchronized (tCPDataProcessor) {
                return this._processing;
            }
        }

        public void shutdown() {
            this._shutdown = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block22: while (!this._shutdown || TCPDataServer.this._currentFullBuffers != 0) {
                if (this.isProcessing()) {
                    Socket incommingConnection = null;
                    InputStream is = null;
                    try {
                        incommingConnection = this._socket.accept();
                        is = incommingConnection.getInputStream();
                        incommingConnection.setSoTimeout(1000);
                    }
                    catch (SocketException e) {
                        this.pauseProcessing();
                        continue;
                    }
                    catch (IOException e) {
                        continue;
                    }
                    while (true) {
                        if (TCPDataServer.this._currentFullBuffers == 32) {
                            SingleBuffer e = TCPDataServer.this._bufferArray[0];
                            synchronized (e) {
                                try {
                                    TCPDataServer.this._bufferArray[0].wait();
                                }
                                catch (InterruptedException e2) {
                                    // empty catch block
                                }
                            }
                        }
                        ((TCPDataServer)TCPDataServer.this)._bufferArray[this._currentFillerBuffer].addr = incommingConnection.getInetAddress();
                        try {
                            ((TCPDataServer)TCPDataServer.this)._bufferArray[this._currentFillerBuffer].length = is.read(((TCPDataServer)TCPDataServer.this)._bufferArray[this._currentFillerBuffer].data);
                        }
                        catch (InterruptedIOException e) {
                            if (this._shutdown && TCPDataServer.this._currentFullBuffers == 0) {
                                this.pauseProcessing();
                                try {
                                    incommingConnection.close();
                                }
                                catch (IOException e1) {}
                                break block22;
                            }
                        }
                        catch (IOException e) {
                            this.pauseProcessing();
                            try {
                                incommingConnection.close();
                            }
                            catch (IOException e1) {}
                            break block22;
                        }
                        if (((TCPDataServer)TCPDataServer.this)._bufferArray[this._currentFillerBuffer].length < 0) {
                            this.pauseProcessing();
                            try {
                                incommingConnection.close();
                            }
                            catch (IOException iOException) {}
                            break block22;
                        }
                        SingleBuffer singleBuffer = TCPDataServer.this._bufferArray[0];
                        synchronized (singleBuffer) {
                            if (((TCPDataServer)TCPDataServer.this)._bufferArray[this._currentFillerBuffer].length > 0) {
                                this._currentFillerBuffer = (short)(this._currentFillerBuffer + 1);
                                if (this._currentFillerBuffer == 32) {
                                    this._currentFillerBuffer = 0;
                                }
                                TCPDataServer.access$008(TCPDataServer.this);
                                if (TCPDataServer.this._currentFullBuffers == 1) {
                                    TCPDataServer.this._bufferArray[0].notifyAll();
                                }
                            }
                        }
                    }
                }
                try {
                    TCPDataProcessor.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    class SingleBuffer
    implements Constants {
        public InetAddress addr;
        public int length = 0;
        public int size = 8096;
        public byte[] data = new byte[8096];

        SingleBuffer() {
        }
    }
}

