/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.hierarchy.util;

import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.loaders.util.RegistryReader;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.models.hierarchy.util.HierarchyResourceSetImpl;

public class SaveUtil {
    protected static final boolean debugSystemOut = false;

    public static URI createURI(String uri) {
        if (RegistryReader.isPlatformMode()) {
            if (uri.startsWith("platform:/resource")) {
                return URI.createURI((String)uri);
            }
            if (uri.startsWith("/")) {
                return URI.createURI((String)("platform:/resource" + uri));
            }
            return URI.createURI((String)("platform:/resource/" + uri));
        }
        if (uri.startsWith("platform:/resource")) {
            return URI.createURI((String)uri.substring("platform:/resource".length()));
        }
        return URI.createURI((String)uri);
    }

    public static void save(TRCMonitor monitor, IProgressMonitor mon) throws Exception {
        try {
            SaveUtil.saveResource(mon, monitor.eResource());
        }
        catch (Exception exc) {
            if (mon != null) {
                mon.done();
            }
            throw exc;
        }
        EList nodes = monitor.getNodes();
        for (int idx = 0; idx < nodes.size(); ++idx) {
            if (((TRCNode)nodes.get(idx)).eIsProxy()) continue;
            SaveUtil.save((TRCNode)nodes.get(idx), mon);
        }
    }

    public static void saveDocuments() throws Exception {
        SaveUtil.saveDocuments(null);
    }

    public static void saveDocuments(IProgressMonitor mon) throws Exception {
        EList documentList = HierarchyResourceSetImpl.getInstance().getResources();
        if (mon != null) {
            mon.beginTask("Saving...", documentList.size());
        }
        if (!documentList.isEmpty()) {
            HashMap<String, Boolean> options = new HashMap<String, Boolean>();
            options.put("DECLARE_XML", Boolean.TRUE);
            Iterator iter = documentList.iterator();
            while (iter.hasNext()) {
                Resource res = (Resource)iter.next();
                if (!res.isModified() || !res.isLoaded()) continue;
                try {
                    res.save(options);
                }
                catch (Exception exc) {
                    if (mon != null) {
                        mon.done();
                    }
                    throw exc;
                }
            }
        }
        if (mon != null) {
            mon.done();
        }
    }

    public static void saveResource(IProgressMonitor mon, Resource res) throws Exception {
        if (mon != null) {
            mon.setTaskName(res.getURI().path());
        }
        HashMap<String, Boolean> options = new HashMap<String, Boolean>();
        options.put("DECLARE_XML", Boolean.TRUE);
        res.save(options);
        Resource iovr = SaveUtil.getIOVResource(res);
        if (iovr != null) {
            try {
                iovr.save(options);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        }
        if (mon != null) {
            mon.worked(1);
        }
    }

    private static final void save(TRCAgent agent, IProgressMonitor mon) throws Exception {
        if (mon != null && mon.isCanceled()) {
            throw new OperationCanceledException();
        }
        try {
            SaveUtil.saveResource(mon, agent.eResource());
            Resource iovr = SaveUtil.getIOVResource(agent.eResource());
            if (iovr != null) {
                SaveUtil.saveResource(mon, iovr);
            }
        }
        catch (Exception exc) {
            if (mon != null) {
                mon.done();
            }
            throw exc;
        }
    }

    private static Resource getIOVResource(Resource r) {
        String uri = r.getURI().toString();
        int extIndex = uri.indexOf(".trca");
        if (extIndex == -1) {
            return null;
        }
        String newUri = uri.substring(0, extIndex);
        newUri = newUri.concat(".trciov").concat(uri.substring(extIndex + 5));
        return HierarchyResourceSetImpl.getInstance().getResource(SaveUtil.createURI(newUri), false);
    }

    private static final void save(TRCNode node, IProgressMonitor mon) throws Exception {
        if (mon != null && mon.isCanceled()) {
            throw new OperationCanceledException();
        }
        try {
            SaveUtil.saveResource(mon, node.eResource());
        }
        catch (Exception exc) {
            if (mon != null) {
                mon.done();
            }
            throw exc;
        }
        EList processes = node.getProcessProxies();
        for (int idx = 0; idx < processes.size(); ++idx) {
            TRCProcessProxy process = (TRCProcessProxy)processes.get(idx);
            if (process.eIsProxy()) continue;
            SaveUtil.save(process, mon);
        }
    }

    private static final void save(TRCProcessProxy process, IProgressMonitor mon) throws Exception {
        if (mon != null && mon.isCanceled()) {
            throw new OperationCanceledException();
        }
        try {
            SaveUtil.saveResource(mon, process.eResource());
        }
        catch (Exception exc) {
            if (mon != null) {
                mon.done();
            }
            throw exc;
        }
        EList agents = process.getAgentProxies();
        for (int idx = 0; idx < agents.size(); ++idx) {
            TRCAgent agent = ((TRCAgentProxy)agents.get(idx)).getAgent();
            if (agent.eIsProxy()) continue;
            SaveUtil.save(agent, mon);
        }
    }
}

