/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.common.junit;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import junit.extensions.TestDecorator;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.eclipse.hyades.test.common.junit.IHyadesTest;

public class HyadesTestUtil {
    public static String getHierarchy(Test test) {
        return HyadesTestUtil.getHierarchy(test, true);
    }

    public static String getHierarchy(Test test, boolean bl) {
        StringBuffer stringBuffer = HyadesTestUtil.doGetHierarchy(test, bl);
        if (stringBuffer.length() == 0) {
            return "";
        }
        if (stringBuffer.charAt(0) == '-') {
            stringBuffer.deleteCharAt(0);
        }
        return stringBuffer.toString();
    }

    private static StringBuffer doGetHierarchy(Test test, boolean bl) {
        if (test != null) {
            if (test instanceof IHyadesTest) {
                IHyadesTest iHyadesTest = (IHyadesTest)test;
                StringBuffer stringBuffer = HyadesTestUtil.doGetHierarchy(iHyadesTest.getParent(), bl);
                stringBuffer.append("-").append(HyadesTestUtil.getNotNullString(iHyadesTest.getName()));
                if (bl && iHyadesTest.getIteration() > 0) {
                    stringBuffer.append("[").append(iHyadesTest.getIteration()).append("]");
                }
                return stringBuffer;
            }
            return new StringBuffer("-?").append(test.toString());
        }
        return new StringBuffer(0);
    }

    public static String getHierarchyIds(Test test) {
        StringBuffer stringBuffer = HyadesTestUtil.doGetHierarchyIds(test);
        if (stringBuffer.length() == 0) {
            return "";
        }
        if (stringBuffer.charAt(0) == '.') {
            stringBuffer.deleteCharAt(0);
        }
        return stringBuffer.toString();
    }

    private static StringBuffer doGetHierarchyIds(Test test) {
        if (test != null) {
            if (test instanceof IHyadesTest) {
                IHyadesTest iHyadesTest = (IHyadesTest)test;
                StringBuffer stringBuffer = HyadesTestUtil.doGetHierarchyIds(iHyadesTest.getParent());
                int n = iHyadesTest.getIteration();
                if (iHyadesTest.getTestInvocationId() != null) {
                    HyadesTestUtil.appendToHierarchyId(stringBuffer, iHyadesTest.getTestInvocationId(), n);
                }
                return HyadesTestUtil.appendToHierarchyId(stringBuffer, iHyadesTest.getId(), n);
            }
            return new StringBuffer(".?").append(test.toString());
        }
        return new StringBuffer(0);
    }

    public static String appendToHierarchyId(String string, String string2, int n) {
        StringBuffer stringBuffer = null;
        if (string != null) {
            stringBuffer = new StringBuffer(string);
        }
        return HyadesTestUtil.appendToHierarchyId(stringBuffer, string2, n).toString();
    }

    public static StringBuffer appendToHierarchyId(StringBuffer stringBuffer, String string, int n) {
        if (stringBuffer == null) {
            if (string == null) {
                return null;
            }
            stringBuffer = new StringBuffer();
        }
        if (string != null) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(".");
            }
            stringBuffer.append(string);
        }
        if (n >= 1) {
            stringBuffer.append("(").append(n).append(")");
        }
        return stringBuffer;
    }

    public static int countTests(Test[] testArray) {
        int n = 0;
        for (int i = 0; i < testArray.length; ++i) {
            n += testArray[i].countTestCases();
        }
        return n;
    }

    public static String getNotNullString(Object object) {
        if (object == null) {
            return "";
        }
        return object.toString();
    }

    public static Object getObjectFieldValue(Object object, String string) throws Exception {
        if (object == null || string == null) {
            return null;
        }
        Field field = null;
        Exception exception = null;
        Class<?> clazz = object.getClass();
        while (field == null && clazz != null) {
            try {
                field = clazz.getDeclaredField(string);
            }
            catch (Exception exception2) {
                if (exception == null) {
                    exception = exception2;
                }
                clazz = clazz.getSuperclass();
            }
        }
        if (field == null) {
            if (exception != null) {
                throw exception;
            }
            return null;
        }
        field.setAccessible(true);
        return field.get(object);
    }

    public static Iterator getTestListeners(TestResult testResult) {
        try {
            return ((Vector)HyadesTestUtil.getObjectFieldValue(testResult, "fListeners")).iterator();
        }
        catch (Exception exception) {
            return Collections.EMPTY_LIST.iterator();
        }
    }

    public static boolean isParentOf(Test test, Test test2) {
        if (test != null && test2 != null && test2 instanceof IHyadesTest) {
            Test test3 = ((IHyadesTest)test2).getParent();
            if (test.equals(test3)) {
                return true;
            }
            return HyadesTestUtil.isParentOf(test, test3);
        }
        return false;
    }

    public static int getTestCaseCount(TestSuite testSuite) {
        int n = 0;
        Enumeration enumeration = testSuite.tests();
        while (enumeration.hasMoreElements()) {
            Test test = (Test)enumeration.nextElement();
            if (test instanceof TestDecorator) {
                test = HyadesTestUtil.getDecoratorTest((TestDecorator)test);
            }
            if (!(test instanceof TestCase)) continue;
            ++n;
        }
        return n;
    }

    public static Test getDecoratorTest(TestDecorator testDecorator) {
        if (testDecorator == null) {
            return null;
        }
        Test test = testDecorator.getTest();
        if (test instanceof TestDecorator) {
            return HyadesTestUtil.getDecoratorTest((TestDecorator)test);
        }
        return test;
    }
}

