/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.collection.framework;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.eclipse.hyades.execution.security.IClientHandler;

public class ClientHandlerImpl
implements IClientHandler {
    private Socket _socket;
    private InputStream _instrm;
    private OutputStream _outstrm;

    public ClientHandlerImpl(Socket s) {
        this._socket = s;
        try {
            this._instrm = s.getInputStream();
            this._outstrm = s.getOutputStream();
        }
        catch (IOException ioe) {
            this._instrm = null;
            this._outstrm = null;
        }
    }

    public byte[] getRemoteAddress() {
        return this._socket.getInetAddress().getAddress();
    }

    public int read(byte[] b, int off, int len) {
        int bytesRead;
        try {
            bytesRead = this._instrm.read(b, off, len);
        }
        catch (IOException ioe) {
            bytesRead = -1;
        }
        return bytesRead;
    }

    public int write(byte[] b, int off, int len) {
        try {
            this._outstrm.write(b, off, len);
        }
        catch (IOException ioe) {
            return -1;
        }
        return 0;
    }

    public void closeConnection() {
        try {
            this._instrm.close();
            this._outstrm.close();
            this._socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

