/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.common.datapool.test;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.hyades.edit.datapool.IDatapool;
import org.eclipse.hyades.edit.datapool.IDatapoolEquivalenceClass;
import org.eclipse.hyades.edit.datapool.IDatapoolListener;
import org.eclipse.hyades.edit.datapool.IDatapoolRecord;
import org.eclipse.hyades.execution.runtime.datapool.IDatapoolCell;
import org.eclipse.hyades.execution.runtime.datapool.IDatapoolFactory;
import org.eclipse.hyades.execution.runtime.datapool.IDatapoolIterator;
import org.eclipse.hyades.execution.runtime.datapool.IDatapoolVariable;
import org.eclipse.hyades.models.common.datapool.impl.Common_DatapoolFactoryImpl;
import org.eclipse.hyades.models.common.datapool.impl.DPLDatapoolImpl;
import org.eclipse.hyades.models.common.datapool.impl.DPLLogImpl;

public class DatapoolAPITest
extends TestCase {
    IDatapoolListener lis = null;
    org.eclipse.hyades.edit.datapool.IDatapoolFactory editFactory = null;
    IDatapoolFactory runtimeFactory = null;
    IDatapool edp = null;
    org.eclipse.hyades.execution.runtime.datapool.IDatapool rdp = null;
    File testDpXmiFile;
    File testDpResFile;

    public DatapoolAPITest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite junitTestSuite = new TestSuite("Datapool API Test");
        junitTestSuite.addTest((Test)new DatapoolAPITest("testDatapoolSetup"));
        junitTestSuite.addTest((Test)new DatapoolAPITest("testIDatapoolFactoryEdit"));
        junitTestSuite.addTest((Test)new DatapoolAPITest("testIDatapoolEdit"));
        junitTestSuite.addTest((Test)new DatapoolAPITest("testIDatapoolEquivalenceClassEdit"));
        junitTestSuite.addTest((Test)new DatapoolAPITest("testIDatapoolFactoryRuntime"));
        junitTestSuite.addTest((Test)new DatapoolAPITest("testRuntimeAPIs"));
        return junitTestSuite;
    }

    public void setUp() {
        this.lis = new IDatapoolListener(){

            public void variableAdded(IDatapool datapool, int variableIndex) {
                DPLLogImpl.log("***Listener: variableAdded: " + variableIndex);
            }

            public void variableRemoved(IDatapool datapool, int variableIndex) {
                DPLLogImpl.log("***Listener: variableRemoved: " + variableIndex);
            }

            public void variableMoved(IDatapool datapool, int beforeVariableIndex, int afterVariableIndex) {
                DPLLogImpl.log("***Listener: variableMoved: " + beforeVariableIndex + " " + afterVariableIndex);
            }

            public void variableChanged(IDatapool datapool, int variableIndex) {
                DPLLogImpl.log("***Listener: variableChanged: " + variableIndex);
            }

            public void variableChanged(IDatapool datapool, int variableIndex, String oldName) {
                DPLLogImpl.log("***Listener: variableChanged: " + variableIndex + " " + oldName);
            }

            public void recordAdded(IDatapool datapool, int equivClassIndex, int recordIndex) {
                DPLLogImpl.log("***Listener: recordAdded: " + equivClassIndex + " " + recordIndex);
            }

            public void recordRemoved(IDatapool datapool, int equivClassIndex, int recordIndex) {
                DPLLogImpl.log("***Listener: recordRemoved: " + equivClassIndex + " " + recordIndex);
            }

            public void recordMoved(IDatapool datapool, int equivClassIndex, int beforeRecordIndex, int afterRecordIndex) {
                DPLLogImpl.log("***Listener: recordMoved: " + equivClassIndex + " " + beforeRecordIndex + " " + afterRecordIndex);
            }

            public void recordChanged(IDatapool datapool, int equivClassIndex, int recordIndex) {
                DPLLogImpl.log("***Listener: recordMoved: " + equivClassIndex + " " + recordIndex);
            }

            public void cellChanged(IDatapool datapool, int equivalenceClassIndex, int recordIndex, int variableIndex) {
                DPLLogImpl.log("***Listener: cellChanged: " + equivalenceClassIndex + " " + recordIndex + " " + variableIndex);
            }

            public void equivalenceClassReordered(IDatapool datapool, int equivalenceClassIndex) {
                DPLLogImpl.log("***Listener: equivalenceClassReordered");
            }

            public void equivalenceClassAdded(IDatapool datapool, int equivalenceClassIndex) {
                DPLLogImpl.log("***Listener: equivalenceClassAdded: " + equivalenceClassIndex);
            }

            public void equivalenceClassRemoved(IDatapool datapool, int equivalenceClassIndex) {
                DPLLogImpl.log("***Listener: equivalenceClassRemoved: " + equivalenceClassIndex);
            }

            public void equivalenceClassMoved(IDatapool datapool, int beforeEquivalenceClassIndex, int afterEquivalenceClassIndex) {
                DPLLogImpl.log("***Listener: equivalenceClassMoved: " + beforeEquivalenceClassIndex + " " + afterEquivalenceClassIndex);
            }

            public void equivalenceClassChanged(IDatapool datapool, int equivalenceClassIndex) {
                DPLLogImpl.log("***Listener: equivalenceClassChanged: " + equivalenceClassIndex);
            }

            public void equivalenceClassChanged(IDatapool datapool, int equivalenceClassIndex, String oldName) {
                DPLLogImpl.log("***Listener: equivalenceClassChanged: " + equivalenceClassIndex + " " + oldName);
            }

            public void save(IDatapool datapool) {
                DPLLogImpl.log("***Listener: datapoolSaved");
            }
        };
        this.editFactory = new Common_DatapoolFactoryImpl();
        this.runtimeFactory = new Common_DatapoolFactoryImpl();
        try {
            this.testDpXmiFile = File.createTempFile("testDatapool", ".xmi");
            this.testDpXmiFile.deleteOnExit();
            this.testDpResFile = File.createTempFile("testDatapool", ".datapool");
            this.testDpResFile.deleteOnExit();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void tearDown() {
    }

    public void testDatapoolSetup() {
        DPLLogImpl.log("\n########## Hello to Datapool Setup (edit) Test!");
        this.edp = this.editFactory.constructDatapool();
        this.edp.setName("DP1");
        this.edp.addDatapoolListener(this.lis);
        org.eclipse.hyades.edit.datapool.IDatapoolVariable evar1 = this.edp.constructVariable();
        evar1.setName("LoginId");
        this.edp.appendVariable(evar1);
        org.eclipse.hyades.edit.datapool.IDatapoolVariable evar2 = this.edp.constructVariable();
        evar2.setName("Password");
        this.edp.appendVariable(evar2);
        IDatapoolEquivalenceClass eec1 = this.edp.constructEquivalenceClass();
        eec1.setName("EC1");
        this.edp.appendEquivalenceClass(eec1);
        IDatapoolRecord erec1 = eec1.constructRecord(new Object[]{"<Literal>myLoginId</Literal>", "<Literal>myPassword</Literal>"});
        IDatapoolRecord erec2 = eec1.constructRecord(new Object[]{"<Literal>yourLoginId</Literal>", "<Literal>yourPassword</Literal>"});
        IDatapoolRecord erec3 = eec1.constructRecord(new Object[]{"<Literal>hisLoginId</Literal>", "<Literal>hisPassword</Literal>"});
        eec1.appendRecord(erec1);
        eec1.appendRecord(erec2);
        eec1.appendRecord(erec3);
        ((DPLDatapoolImpl)this.edp).logDatapoolAsStrings();
        DatapoolAPITest.assertTrue((this.edp.getEquivalenceClassCount() == 1 ? 1 : 0) != 0);
        DatapoolAPITest.assertTrue((this.edp.getEquivalenceClass(0).getRecordCount() == 3 ? 1 : 0) != 0);
        this.rdp = this.edp;
        DPLLogImpl.log("########## Bye from Datapool Setup (edit) Test!");
    }

    public void testIDatapoolFactoryEdit() {
        DPLLogImpl.log("\n########## Hello to IDatapoolFactory (edit) Test!");
        DPLLogImpl.setLoggingStatus(false);
        this.testDatapoolSetup();
        DPLLogImpl.setLoggingStatus(true);
        ((DPLDatapoolImpl)this.edp).logDatapoolAsStrings();
        this.editFactory.saveAs(this.edp, this.testDpXmiFile);
        try {
            int r;
            FileInputStream fis = new FileInputStream(this.testDpXmiFile);
            FileOutputStream fos = new FileOutputStream(this.testDpResFile);
            ZipOutputStream zos = new ZipOutputStream(fos);
            ZipEntry ze = new ZipEntry("ResourceContents");
            zos.putNextEntry(ze);
            byte[] buf = new byte[10];
            while ((r = fis.read(buf, 0, 10)) != -1) {
                zos.write(buf, 0, r);
            }
            zos.close();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        this.edp = this.editFactory.loadForEdit(this.testDpResFile, false);
        ((DPLDatapoolImpl)this.edp).logDatapoolAsStrings();
        DPLLogImpl.log("########## bye from IDatapool (edit) Test!");
    }

    public void testIDatapoolEdit() {
        DPLLogImpl.log("\n########## Hello to IDatapool (edit) Test!");
        DPLLogImpl.setLoggingStatus(false);
        this.testDatapoolSetup();
        DPLLogImpl.setLoggingStatus(true);
        ((DPLDatapoolImpl)this.edp).logDatapoolAsStrings();
        org.eclipse.hyades.edit.datapool.IDatapoolVariable evar0 = this.edp.constructVariable();
        evar0.setName("MachineName");
        this.edp.appendVariable(evar0);
        DatapoolAPITest.assertTrue((this.edp.getVariableCount() == 3 ? 1 : 0) != 0);
        DatapoolAPITest.assertTrue((boolean)this.edp.getVariable(2).getName().equals("MachineName"));
        this.edp.moveVariable(1, 0);
        DatapoolAPITest.assertTrue((boolean)this.edp.getVariable(0).getName().equals("Password"));
        DatapoolAPITest.assertTrue((boolean)this.edp.getVariable(1).getName().equals("LoginId"));
        this.edp.removeVariable(2);
        DatapoolAPITest.assertTrue((this.edp.getVariableCount() == 2 ? 1 : 0) != 0);
        this.edp.updateVariable(evar0, 0);
        ((DPLDatapoolImpl)this.edp).logDatapoolAsStrings();
        DatapoolAPITest.assertTrue((boolean)this.edp.getVariable(0).getName().equals("MachineName"));
        DPLLogImpl.log("########## Bye from IDatapool (edit) Test!");
    }

    public void testIDatapoolEquivalenceClassEdit() {
        DPLLogImpl.log("\n########## Hello to IDatapoolEquivalenceClass (edit) Test!");
        DPLLogImpl.setLoggingStatus(false);
        this.testDatapoolSetup();
        DPLLogImpl.setLoggingStatus(true);
        IDatapoolEquivalenceClass eec2 = this.edp.constructEquivalenceClass();
        eec2.setName("EC2");
        this.edp.appendEquivalenceClass(eec2);
        IDatapoolRecord erec1 = eec2.constructRecord(new Object[]{"<ExcelData>LoginId1</ExcelData>", "<ExcelData>Password1</ExcelData>"});
        IDatapoolRecord erec2 = eec2.constructRecord(new Object[]{"<Literal>LoginId2</Literal>", "<Literal>Password2</Literal>"});
        IDatapoolRecord erec3 = eec2.constructRecord(new Object[]{"<Literal>LoginId3</Literal>", "<Literal>Password3</Literal>"});
        eec2.appendRecord(erec1);
        eec2.appendRecord(erec2);
        eec2.appendRecord(erec3);
        ((DPLDatapoolImpl)this.edp).logDatapoolAsStrings();
        DatapoolAPITest.assertTrue((this.edp.getEquivalenceClassCount() == 2 ? 1 : 0) != 0);
        DatapoolAPITest.assertTrue((this.edp.getEquivalenceClass(1).getRecordCount() == 3 ? 1 : 0) != 0);
        IDatapoolCell rcell1 = this.rdp.getEquivalenceClass(1).getRecord(0).getCell("LoginId");
        DatapoolAPITest.assertTrue((boolean)rcell1.getCellVariable().getName().equals("LoginId"));
        DatapoolAPITest.assertTrue((boolean)rcell1.getStringValue().equals("LoginId1 (Excel)"));
        this.edp.moveEquivalenceClass(0, 1);
        DatapoolAPITest.assertTrue((boolean)this.edp.getEquivalenceClass(0).getName().equals("EC2"));
        DatapoolAPITest.assertTrue((boolean)this.edp.getEquivalenceClass(1).getName().equals("EC1"));
        this.edp.removeEquivalenceClass(1);
        DatapoolAPITest.assertTrue((this.edp.getEquivalenceClassCount() == 1 ? 1 : 0) != 0);
        DatapoolAPITest.assertTrue((boolean)this.edp.getEquivalenceClass(0).getName().equals("EC2"));
        ((IDatapoolEquivalenceClass)this.edp.getEquivalenceClass(0)).reorder(new int[]{1, 0, 2});
        DatapoolAPITest.assertTrue((boolean)this.edp.getEquivalenceClass(0).getRecord(0).getCell("LoginId").getStringValue().equals("LoginId2"));
        DPLLogImpl.log("########## bye from IDatapoolEquivalenceClass (edit) Test!");
    }

    public void testIDatapoolFactoryRuntime() {
        DPLLogImpl.log("\n########## Hello to IDatapool (runtime) Test!");
        DPLLogImpl.setLoggingStatus(false);
        this.testIDatapoolFactoryEdit();
        DPLLogImpl.setLoggingStatus(true);
        this.rdp = this.runtimeFactory.load(this.testDpResFile, true);
        this.rdp = this.runtimeFactory.load(this.testDpResFile, true);
        this.rdp = this.runtimeFactory.load(this.testDpResFile, true);
        this.runtimeFactory.unload(this.rdp);
        this.runtimeFactory.unload(this.rdp);
        this.runtimeFactory.unload(this.rdp);
        this.rdp = this.runtimeFactory.load(this.testDpResFile, true);
        ((DPLDatapoolImpl)this.rdp).logDatapoolAsStrings();
        IDatapoolIterator it = this.runtimeFactory.open(this.rdp, "org.eclipse.hyades.datapool.iterator.DatapoolIteratorSequentialShared");
        it.dpInitialize(this.rdp, -1);
        DPLLogImpl.log("");
        while (!it.dpDone()) {
            DPLLogImpl.log("Iterator: " + it.dpString("LoginId"));
            it.dpNext();
        }
        this.runtimeFactory.close(it);
        DPLLogImpl.log("########## Bye from IDatapool (runtime) Test!");
    }

    public void testRuntimeAPIs() {
        DPLLogImpl.log("\n########## Hello to Runtime APIs Test!");
        DPLLogImpl.setLoggingStatus(false);
        this.testDatapoolSetup();
        DPLLogImpl.setLoggingStatus(true);
        IDatapoolCell rcell1 = this.rdp.getEquivalenceClass(0).getRecord(0).getCell("LoginId");
        DatapoolAPITest.assertTrue((boolean)rcell1.getCellVariable().getName().equals("LoginId"));
        DatapoolAPITest.assertTrue((boolean)rcell1.getStringValue().equals("myLoginId"));
        int i = this.rdp.getVariableIndex("LoginId");
        IDatapoolVariable rvar1 = this.rdp.getVariable(i);
        DatapoolAPITest.assertTrue((i == 0 ? 1 : 0) != 0);
        DatapoolAPITest.assertTrue((boolean)rvar1.getName().equals("LoginId"));
        DPLLogImpl.log("########## Bye from Runtime APIs Test!");
    }
}

