/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.common.facades.behavioral.test;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.hyades.models.common.facades.behavioral.IAction;
import org.eclipse.hyades.models.common.facades.behavioral.IDecision;
import org.eclipse.hyades.models.common.facades.behavioral.IImplementor;
import org.eclipse.hyades.models.common.facades.behavioral.ILoop;
import org.eclipse.hyades.models.common.facades.behavioral.ISystemUnderTest;
import org.eclipse.hyades.models.common.facades.behavioral.ITargetInvocation;
import org.eclipse.hyades.models.common.facades.behavioral.ITest;
import org.eclipse.hyades.models.common.facades.behavioral.ITestCase;
import org.eclipse.hyades.models.common.facades.behavioral.ITestComponent;
import org.eclipse.hyades.models.common.facades.behavioral.ITestInvocation;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.models.common.facades.behavioral.IVerificationPoint;

public class ValidateFacade
extends TestCase {
    protected static ITestSuite facadeTestSuite;
    protected static Set validatedTestSuites;

    public ValidateFacade(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite junitTestSuite = new TestSuite("Facade Validation");
        junitTestSuite.addTest((Test)new ValidateFacade("suiteSetUp"));
        junitTestSuite.addTest((Test)new ValidateFacade("testTestSuite"));
        junitTestSuite.addTest((Test)new ValidateFacade("testTestCases"));
        junitTestSuite.addTest((Test)new ValidateFacade("testSystemsUnderTest"));
        junitTestSuite.addTest((Test)new ValidateFacade("testTestComponents"));
        junitTestSuite.addTest((Test)new ValidateFacade("suiteTearDown"));
        return junitTestSuite;
    }

    public void suiteSetUp() {
        validatedTestSuites = new HashSet();
        facadeTestSuite = this.getFacadeTestSuite();
    }

    public void suiteTearDown() {
        validatedTestSuites.clear();
        facadeTestSuite = null;
    }

    protected ITestSuite getFacadeTestSuite() {
        return null;
    }

    public void testTestSuite() throws Exception {
        ValidateFacade.assertNotNull((Object)facadeTestSuite);
        this.validate(facadeTestSuite);
    }

    public void testTestCases() throws Exception {
        ValidateFacade.assertNotNull((Object)facadeTestSuite);
        List testCases = facadeTestSuite.getITestCases();
        if (testCases.isEmpty()) {
            return;
        }
        Iterator i = testCases.iterator();
        while (i.hasNext()) {
            this.validate((ITestCase)i.next());
        }
    }

    public void testSystemsUnderTest() throws Exception {
        ValidateFacade.assertNotNull((Object)facadeTestSuite);
        List systemsUnderTest = facadeTestSuite.getISystemsUnderTest();
        if (systemsUnderTest.isEmpty()) {
            return;
        }
        Iterator i = systemsUnderTest.iterator();
        while (i.hasNext()) {
            this.validate((ISystemUnderTest)i.next());
        }
    }

    public void testStubs() throws Exception {
        ValidateFacade.assertNotNull((Object)facadeTestSuite);
        List testStubs = facadeTestSuite.getITestComponents();
        if (testStubs.isEmpty()) {
            return;
        }
        Iterator i = testStubs.iterator();
        while (i.hasNext()) {
            this.validate((ITestComponent)i.next());
        }
    }

    protected void validate(ITestSuite testSuite) throws Exception {
        if (validatedTestSuites.contains(testSuite)) {
            return;
        }
        validatedTestSuites.add(testSuite);
        ValidateFacade.assertNotNull((Object)testSuite.getName());
        this.validate(testSuite.getImplementor());
        ValidateFacade.assertNotNull((Object)testSuite.getITestCases());
        ValidateFacade.assertNotNull((Object)testSuite.getISystemsUnderTest());
        ValidateFacade.assertNotNull((Object)testSuite.getITestComponents());
    }

    protected void validate(ITestCase testCase) throws Exception {
        ValidateFacade.assertNotNull((Object)testCase);
        ValidateFacade.assertNotNull((Object)testCase.getName());
        ValidateFacade.assertEquals((Object)testCase.getOwner(), (Object)facadeTestSuite);
        this.validate(testCase.getImplementor());
    }

    protected void validate(IImplementor implementor) throws Exception {
        ValidateFacade.assertNotNull((Object)implementor);
        if (implementor.isExternalImplementor()) {
            IImplementor externalImplementor = implementor;
            ValidateFacade.assertNotNull((Object)externalImplementor.getResource());
        } else if (implementor instanceof IImplementor) {
            IImplementor impl = implementor;
            ValidateFacade.assertEquals((Object)impl.getOwner(), (Object)facadeTestSuite);
        }
    }

    protected void validate(ISystemUnderTest systemUnderTest) throws Exception {
        ValidateFacade.assertNotNull((Object)systemUnderTest);
        ValidateFacade.assertNotNull((Object)systemUnderTest.getName());
        ValidateFacade.assertEquals((Object)systemUnderTest.getOwner(), (Object)facadeTestSuite);
    }

    protected void validate(ITestComponent stub) throws Exception {
        ValidateFacade.assertNotNull((Object)stub.getName());
        ValidateFacade.assertEquals((Object)stub.getOwner(), (Object)facadeTestSuite);
    }

    protected void validate(IAction action) throws Exception {
        ValidateFacade.assertNotNull((Object)action.getActionProperties());
        if (action instanceof IDecision) {
            IDecision decision = (IDecision)action;
            ValidateFacade.assertNotNull((Object)decision.getCondition());
            ValidateFacade.assertNotNull((Object)decision.getCondition().getConstraint());
            ValidateFacade.assertNotNull((Object)decision.getSuccessBlock());
            ValidateFacade.assertNotNull((Object)decision.getFailureBlock());
        } else if (action instanceof ILoop) {
            ILoop loop = (ILoop)action;
            ValidateFacade.assertNotNull((Object)loop.getCondition());
            ValidateFacade.assertNotNull((Object)loop.getCondition().getConstraint());
            ValidateFacade.assertNotNull((Object)loop.getBlock());
        } else if (!(action instanceof IVerificationPoint)) {
            if (action instanceof ITargetInvocation) {
                ITargetInvocation targetInvocation = (ITargetInvocation)action;
                ValidateFacade.assertNotNull((Object)targetInvocation.getTarget());
            } else if (action instanceof ITestInvocation) {
                ITestInvocation testInvocation = (ITestInvocation)action;
                ITest test = testInvocation.getInvokedTest();
                ValidateFacade.assertNotNull((Object)test);
                ITestSuite invokedTestSuite = null;
                if (test instanceof ITestSuite) {
                    invokedTestSuite = (ITestSuite)test;
                } else if (test instanceof ITestCase) {
                    invokedTestSuite = ((ITestCase)test).getOwner();
                }
                ValidateFacade.assertNotNull((Object)invokedTestSuite);
                this.validate(invokedTestSuite);
                IImplementor implementor = testInvocation.getInvokedTest().getImplementor();
                ValidateFacade.assertNotNull((Object)implementor);
            }
        }
    }
}

