/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.preferences;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.internal.preferences.EclipsePreferences;
import org.eclipse.core.internal.preferences.ExportedPreferences;
import org.eclipse.core.internal.preferences.LookupOrder;
import org.eclipse.core.internal.preferences.RootPreferences;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.internal.runtime.Policy;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IExportedPreferences;
import org.eclipse.core.runtime.preferences.IPreferenceNodeVisitor;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.IScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.osgi.framework.Bundle;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class PreferencesService
implements IPreferencesService,
IRegistryChangeListener {
    private static final String[] DEFAULT_DEFAULT_LOOKUP_ORDER = new String[]{"project", "instance", "configuration", "default"};
    private static final char EXPORT_ROOT_PREFIX = '!';
    private static final char BUNDLE_VERSION_PREFIX = '@';
    private static final float EXPORT_VERSION = 3.0f;
    private static final String VERSION_KEY = "file_export_version";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ATTRIBUTE_CLASS = "class";
    private static final String ELEMENT_SCOPE = "scope";
    private static final String EMPTY_STRING = "";
    private static IPreferencesService instance;
    static final RootPreferences root;
    private static final Map defaultsRegistry;
    private static final Map scopeRegistry;

    static {
        root = new RootPreferences();
        defaultsRegistry = Collections.synchronizedMap(new HashMap());
        scopeRegistry = Collections.synchronizedMap(new HashMap());
    }

    private static IStatus createStatusError(String message, Exception e) {
        return new Status(4, "org.eclipse.core.runtime", 4, message, e);
    }

    private static IStatus createStatusWarning(String message, Exception e) {
        return new Status(2, "org.eclipse.core.runtime", 2, message, e);
    }

    public static IPreferencesService getDefault() {
        if (instance == null) {
            instance = new PreferencesService();
        }
        return instance;
    }

    private void initializeScopes() {
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.core.runtime", "preferences");
        if (point == null) {
            return;
        }
        IExtension[] extensions = point.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                if (ELEMENT_SCOPE.equalsIgnoreCase(elements[j].getName())) {
                    PreferencesService.scopeAdded(elements[j]);
                }
                ++j;
            }
            ++i;
        }
        Platform.getExtensionRegistry().addRegistryChangeListener(this, "org.eclipse.core.runtime");
    }

    static void log(IStatus status) {
        InternalPlatform.getDefault().log(status);
    }

    static void scopeAdded(IConfigurationElement element) {
        String key = element.getAttribute(ATTRIBUTE_NAME);
        if (key == null) {
            String message = Policy.bind("preferences.missingScopeAttribute", element.getDeclaringExtension().getUniqueIdentifier());
            PreferencesService.log(PreferencesService.createStatusWarning(message, null));
            return;
        }
        scopeRegistry.put(key, element);
        root.addChild(key, null);
    }

    static void scopeRemoved(String key) {
        IEclipsePreferences node = (IEclipsePreferences)root.node(key);
        root.removeNode(node);
        scopeRegistry.remove(key);
    }

    private PreferencesService() {
        this.initializeScopes();
    }

    public IStatus applyPreferences(IExportedPreferences preferences) throws CoreException {
        if (preferences == null) {
            throw new IllegalArgumentException();
        }
        if (InternalPlatform.DEBUG_PREFERENCES) {
            Policy.debug("Applying exported preferences: " + ((ExportedPreferences)preferences).toDeepDebugString());
        }
        MultiStatus result = new MultiStatus("org.eclipse.core.runtime", 0, Policy.bind("preferences.applyProblems"), null);
        IPreferenceNodeVisitor visitor = new IPreferenceNodeVisitor(){

            public boolean visit(IEclipsePreferences node) throws BackingStoreException {
                IEclipsePreferences globalNode = node.parent() == null ? root : (IEclipsePreferences)root.node(node.absolutePath());
                ExportedPreferences epNode = (ExportedPreferences)node;
                boolean removed = false;
                if (epNode.isExportRoot()) {
                    if (InternalPlatform.DEBUG_PREFERENCES) {
                        Policy.debug("Found export root: " + epNode.absolutePath());
                    }
                    globalNode.removeNode();
                    removed = true;
                }
                if (epNode.properties != null && !epNode.properties.isEmpty()) {
                    if (removed) {
                        globalNode = (IEclipsePreferences)root.node(node.absolutePath());
                    }
                    Iterator<Object> i = epNode.properties.keySet().iterator();
                    while (i.hasNext()) {
                        String key = (String)i.next();
                        String value = node.get(key = key.intern(), null);
                        if (value == null) continue;
                        if (InternalPlatform.DEBUG_PREFERENCES) {
                            Policy.debug("Setting: " + globalNode.absolutePath() + '/' + key + '=' + value);
                        }
                        globalNode.put(key, value);
                    }
                }
                return true;
            }
        };
        try {
            preferences.accept(visitor);
        }
        catch (BackingStoreException e) {
            String message = Policy.bind("preferences.applyProblems");
            throw new CoreException(PreferencesService.createStatusError(message, e));
        }
        try {
            this.getRootNode().node(preferences.absolutePath()).flush();
        }
        catch (BackingStoreException e) {
            String message = Policy.bind("preferences.saveProblems");
            throw new CoreException(PreferencesService.createStatusError(message, e));
        }
        if (InternalPlatform.DEBUG_PREFERENCES) {
            Policy.debug("Current list of all settings: " + ((EclipsePreferences)this.getRootNode()).toDeepDebugString());
        }
        return result;
    }

    private Properties convertFromLegacy(Properties properties) {
        Properties result = new Properties();
        String prefix = "/instance/";
        Iterator<Object> i = properties.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            String value = properties.getProperty(key);
            if (value == null) continue;
            int index = key.indexOf(47);
            if (index == -1) {
                result.put(String.valueOf('@') + key, value);
                result.put(String.valueOf('!') + prefix + key, EMPTY_STRING);
                continue;
            }
            String path = key.substring(0, index);
            key = key.substring(index + 1);
            result.put(EclipsePreferences.encodePath(String.valueOf(prefix) + path, key), value);
        }
        return result;
    }

    private IExportedPreferences convertFromProperties(Properties properties) {
        ExportedPreferences result = new ExportedPreferences(null, EMPTY_STRING);
        Iterator<Object> i = properties.keySet().iterator();
        while (i.hasNext()) {
            ExportedPreferences current;
            String path = (String)i.next();
            String value = properties.getProperty(path);
            if (path.charAt(0) == '!') {
                current = (ExportedPreferences)result.node(path.substring(1));
                current.setExportRoot();
                continue;
            }
            if (path.charAt(0) == '@') {
                current = (ExportedPreferences)result.node("instance").node(path.substring(1));
                current.setVersion(value);
                continue;
            }
            String[] decoded = EclipsePreferences.decodePath(path);
            path = decoded[0] == null ? EMPTY_STRING : decoded[0];
            ExportedPreferences current2 = (ExportedPreferences)result.node(path);
            String key = decoded[1];
            current2.put(key, value);
        }
        if (InternalPlatform.DEBUG_PREFERENCES) {
            Policy.debug("Converted preferences file to IExportedPreferences tree: " + result.toDeepDebugString());
        }
        return result;
    }

    String getScope(String path) {
        if (path == null || path.length() == 0) {
            return EMPTY_STRING;
        }
        int startIndex = path.indexOf(47);
        if (startIndex == -1) {
            return path;
        }
        if (path.length() == 1) {
            return EMPTY_STRING;
        }
        int endIndex = path.indexOf(47, startIndex + 1);
        if (endIndex == -1) {
            endIndex = path.length();
        }
        return path.substring(startIndex + 1, endIndex);
    }

    private Properties convertToProperties(IEclipsePreferences preferences, final String[] excludesList) throws BackingStoreException {
        final Properties result = new Properties();
        final int baseLength = preferences.absolutePath().length();
        IPreferenceNodeVisitor visitor = new IPreferenceNodeVisitor(){

            public boolean visit(IEclipsePreferences node) throws BackingStoreException {
                String absolutePath = node.absolutePath();
                String scope = PreferencesService.this.getScope(absolutePath);
                if ("default".equals(scope)) {
                    return false;
                }
                String path = absolutePath.length() <= baseLength ? PreferencesService.EMPTY_STRING : EclipsePreferences.makeRelative(absolutePath.substring(baseLength));
                int i = 0;
                while (i < excludesList.length) {
                    String exclusion = EclipsePreferences.makeRelative(excludesList[i]);
                    if (path.startsWith(exclusion)) {
                        return false;
                    }
                    ++i;
                }
                boolean needToAddVersion = "instance".equals(scope);
                String[] keys = node.keys();
                int i2 = 0;
                while (i2 < keys.length) {
                    String value;
                    String key = keys[i2];
                    boolean ignore = false;
                    int j = 0;
                    while (!ignore && j < excludesList.length) {
                        if (EclipsePreferences.encodePath(path, key).startsWith(EclipsePreferences.makeRelative(excludesList[j]))) {
                            ignore = true;
                        }
                        ++j;
                    }
                    if (!ignore && (value = node.get(key, null)) != null) {
                        if (needToAddVersion) {
                            String version;
                            String bundle = PreferencesService.this.getBundleName(absolutePath);
                            if (bundle != null && (version = PreferencesService.this.getBundleVersion(bundle)) != null) {
                                result.put(String.valueOf('@') + bundle, version);
                            }
                            needToAddVersion = false;
                        }
                        result.put(EclipsePreferences.encodePath(absolutePath, key), value);
                    }
                    ++i2;
                }
                return true;
            }
        };
        preferences.accept(visitor);
        return result;
    }

    protected IEclipsePreferences createNode(String name) {
        IScope scope = null;
        Object value = scopeRegistry.get(name);
        if (value instanceof IConfigurationElement) {
            try {
                scope = (IScope)((IConfigurationElement)value).createExecutableExtension(ATTRIBUTE_CLASS);
                scopeRegistry.put(name, scope);
            }
            catch (ClassCastException e) {
                String message = Policy.bind("preferences.classCast");
                PreferencesService.log(PreferencesService.createStatusError(message, e));
                return new EclipsePreferences(root, name);
            }
            catch (CoreException e) {
                PreferencesService.log(e.getStatus());
                return new EclipsePreferences(root, name);
            }
        } else {
            scope = (IScope)value;
        }
        return scope.create(root, name);
    }

    public IStatus exportPreferences(IEclipsePreferences node, OutputStream output, String[] excludesList) throws CoreException {
        if (node == null || output == null) {
            throw new IllegalArgumentException();
        }
        Properties properties = null;
        if (excludesList == null) {
            excludesList = new String[]{};
        }
        try {
            properties = this.convertToProperties(node, excludesList);
            if (properties.isEmpty()) {
                return Status.OK_STATUS;
            }
            properties.put(VERSION_KEY, Float.toString(3.0f));
            properties.put(String.valueOf('!') + node.absolutePath(), EMPTY_STRING);
        }
        catch (BackingStoreException e) {
            throw new CoreException(PreferencesService.createStatusError(e.getMessage(), e));
        }
        try {
            properties.store(output, null);
        }
        catch (IOException e) {
            String message = Policy.bind("preferences.exportProblems");
            throw new CoreException(PreferencesService.createStatusError(message, e));
        }
        return Status.OK_STATUS;
    }

    public String get(String key, String defaultValue, Preferences[] nodes) {
        if (nodes == null) {
            return defaultValue;
        }
        int i = 0;
        while (i < nodes.length) {
            String result;
            Preferences node = nodes[i];
            if (node != null && (result = node.get(key, null)) != null) {
                return result;
            }
            ++i;
        }
        return defaultValue;
    }

    public boolean getBoolean(String qualifier, String key, boolean defaultValue, IScopeContext[] scopes) {
        String result = this.get(EclipsePreferences.decodePath(key)[1], null, this.getNodes(qualifier, key, scopes));
        return result == null ? defaultValue : Boolean.valueOf(result);
    }

    String getBundleVersion(String bundleName) {
        Object version;
        Bundle bundle = Platform.getBundle(bundleName);
        if (bundle != null && (version = bundle.getHeaders(EMPTY_STRING).get("Bundle-Version")) != null && version instanceof String) {
            return (String)version;
        }
        return null;
    }

    String getBundleName(String path) {
        if (path.length() == 0 || path.charAt(0) != '/') {
            return null;
        }
        int first = path.indexOf(47, 1);
        if (first == -1) {
            return null;
        }
        int second = path.indexOf(47, first + 1);
        return second == -1 ? path.substring(first + 1) : path.substring(first + 1, second);
    }

    public byte[] getByteArray(String qualifier, String key, byte[] defaultValue, IScopeContext[] scopes) {
        String result = this.get(EclipsePreferences.decodePath(key)[1], null, this.getNodes(qualifier, key, scopes));
        return result == null ? defaultValue : result.getBytes();
    }

    public String[] getDefaultLookupOrder(String qualifier, String key) {
        LookupOrder order = (LookupOrder)defaultsRegistry.get(this.getRegistryKey(qualifier, key));
        return order == null ? null : order.getOrder();
    }

    public double getDouble(String qualifier, String key, double defaultValue, IScopeContext[] scopes) {
        String value = this.get(EclipsePreferences.decodePath(key)[1], null, this.getNodes(qualifier, key, scopes));
        if (value == null) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    public float getFloat(String qualifier, String key, float defaultValue, IScopeContext[] scopes) {
        String value = this.get(EclipsePreferences.decodePath(key)[1], null, this.getNodes(qualifier, key, scopes));
        if (value == null) {
            return defaultValue;
        }
        try {
            return Float.parseFloat(value);
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    public int getInt(String qualifier, String key, int defaultValue, IScopeContext[] scopes) {
        String value = this.get(EclipsePreferences.decodePath(key)[1], null, this.getNodes(qualifier, key, scopes));
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    public long getLong(String qualifier, String key, long defaultValue, IScopeContext[] scopes) {
        String value = this.get(EclipsePreferences.decodePath(key)[1], null, this.getNodes(qualifier, key, scopes));
        if (value == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    public String[] getLookupOrder(String qualifier, String key) {
        String[] order = this.getDefaultLookupOrder(qualifier, key);
        if (order == null && key != null) {
            order = this.getDefaultLookupOrder(qualifier, null);
        }
        if (order == null) {
            order = DEFAULT_DEFAULT_LOOKUP_ORDER;
        }
        return order;
    }

    private Preferences[] getNodes(String qualifier, String key, IScopeContext[] contexts) {
        String[] order = this.getLookupOrder(qualifier, key);
        String childPath = EclipsePreferences.makeRelative(EclipsePreferences.decodePath(key)[0]);
        ArrayList<Preferences> result = new ArrayList<Preferences>();
        int i = 0;
        while (i < order.length) {
            String scopeString = order[i];
            boolean found = false;
            int j = 0;
            while (contexts != null && j < contexts.length) {
                Preferences node;
                IScopeContext context = contexts[j];
                if (context != null && context.getName().equals(scopeString) && (node = context.getNode(qualifier)) != null) {
                    found = true;
                    if (childPath != null) {
                        node = node.node(childPath);
                    }
                    result.add(node);
                }
                ++j;
            }
            if (!found) {
                Preferences node = this.getRootNode().node(scopeString).node(qualifier);
                if (childPath != null) {
                    node = node.node(childPath);
                }
                result.add(node);
            }
            found = false;
            ++i;
        }
        return result.toArray(new Preferences[result.size()]);
    }

    private String getRegistryKey(String qualifier, String key) {
        if (qualifier == null) {
            throw new IllegalArgumentException();
        }
        if (key == null) {
            return qualifier;
        }
        return String.valueOf(qualifier) + '/' + key;
    }

    public IEclipsePreferences getRootNode() {
        return root;
    }

    public String getString(String qualifier, String key, String defaultValue, IScopeContext[] scopes) {
        return this.get(EclipsePreferences.decodePath(key)[1], defaultValue, this.getNodes(qualifier, key, scopes));
    }

    public IStatus importPreferences(InputStream input) throws CoreException {
        if (InternalPlatform.DEBUG_PREFERENCES) {
            Policy.debug("Importing preferences...");
        }
        return this.applyPreferences(this.readPreferences(input));
    }

    private boolean isLegacy(Properties properties) {
        return properties.getProperty(VERSION_KEY) == null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IExportedPreferences readPreferences(InputStream input) throws CoreException {
        if (input == null) {
            throw new IllegalArgumentException();
        }
        if (InternalPlatform.DEBUG_PREFERENCES) {
            Policy.debug("Reading preferences from stream...");
        }
        Properties properties = new Properties();
        try {
            try {
                properties.load(input);
            }
            catch (IOException e) {
                String message = Policy.bind("preferences.importProblems");
                throw new CoreException(PreferencesService.createStatusError(message, e));
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            try {
                input.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        try {}
        catch (IOException iOException) {}
        input.close();
        if (this.isLegacy(properties)) {
            if (InternalPlatform.DEBUG_PREFERENCES) {
                Policy.debug("Read legacy preferences file, converting to 3.0 format...");
            }
            properties = this.convertFromLegacy(properties);
            return this.convertFromProperties(properties);
        }
        if (InternalPlatform.DEBUG_PREFERENCES) {
            Policy.debug("Read preferences file.");
        }
        properties.remove(VERSION_KEY);
        return this.convertFromProperties(properties);
    }

    public void registryChanged(IRegistryChangeEvent event) {
        IExtensionDelta[] deltas = event.getExtensionDeltas("org.eclipse.core.runtime", "preferences");
        int i = 0;
        while (i < deltas.length) {
            IConfigurationElement[] elements = deltas[i].getExtension().getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                switch (deltas[i].getKind()) {
                    case 1: {
                        PreferencesService.scopeAdded(elements[j]);
                        break;
                    }
                    case 2: {
                        String scope = elements[j].getAttribute(ATTRIBUTE_NAME);
                        if (scope == null) break;
                        PreferencesService.scopeRemoved(scope);
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    public void setDefaultLookupOrder(String qualifier, String key, String[] order) {
        String registryKey = this.getRegistryKey(qualifier, key);
        if (order == null) {
            defaultsRegistry.remove(registryKey);
        } else {
            LookupOrder obj = new LookupOrder(qualifier, key, order);
            defaultsRegistry.put(registryKey, obj);
        }
    }

    public IStatus validateVersions(IPath path) {
        String message = Policy.bind("preferences.validate");
        final MultiStatus result = new MultiStatus("org.eclipse.core.runtime", 1, message, null);
        IPreferenceNodeVisitor visitor = new IPreferenceNodeVisitor(){

            public boolean visit(IEclipsePreferences node) {
                if (!(node instanceof ExportedPreferences)) {
                    return false;
                }
                ExportedPreferences realNode = (ExportedPreferences)node;
                String version = realNode.getVersion();
                if (version == null || !PluginVersionIdentifier.validateVersion(version).isOK()) {
                    return true;
                }
                PluginVersionIdentifier versionInFile = new PluginVersionIdentifier(version);
                String bundleName = PreferencesService.this.getBundleName(node.absolutePath());
                if (bundleName == null) {
                    return true;
                }
                String stringVersion = PreferencesService.this.getBundleVersion(bundleName);
                if (stringVersion == null || !PluginVersionIdentifier.validateVersion(stringVersion).isOK()) {
                    return true;
                }
                PluginVersionIdentifier versionInMemory = new PluginVersionIdentifier(stringVersion);
                IStatus verification = PreferencesService.this.validatePluginVersions(bundleName, versionInFile, versionInMemory);
                if (verification != null) {
                    result.add(verification);
                }
                return true;
            }
        };
        BufferedInputStream input = null;
        try {
            input = new BufferedInputStream(new FileInputStream(path.toFile()));
            IExportedPreferences prefs = this.readPreferences(input);
            prefs.accept(visitor);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (CoreException e) {
            message = Policy.bind("preferences.validationException");
            result.add(PreferencesService.createStatusError(message, e));
        }
        catch (BackingStoreException e) {
            message = Policy.bind("preferences.validationException");
            result.add(PreferencesService.createStatusError(message, e));
        }
        return result;
    }

    IStatus validatePluginVersions(String bundle, PluginVersionIdentifier pref, PluginVersionIdentifier installed) {
        if (installed.getMajorComponent() == pref.getMajorComponent() && installed.getMinorComponent() == pref.getMinorComponent()) {
            return null;
        }
        int severity = installed.getMajorComponent() < pref.getMajorComponent() ? 4 : 2;
        String msg = Policy.bind("preferences.incompatible", new String[]{pref.toString(), bundle, installed.toString()});
        return new Status(severity, "org.eclipse.core.runtime", 1, msg, null);
    }
}

