/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.loaders.common;

import java.util.StringTokenizer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.loaders.common.ExecutionResultData;
import org.eclipse.hyades.loaders.common.XMLexecutionEventLoader;
import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofileFactory;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionEvent;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.models.common.testprofile.TPFVerdict;
import org.eclipse.hyades.models.common.testprofile.TPFVerdictEvent;
import org.eclipse.hyades.models.common.testprofile.TPFVerdictReason;

public class XMLverdictEventLoader
extends XMLexecutionEventLoader {
    protected static final String EVENT_VERDICT_VERDICT = "verdict";
    protected static final String EVENT_VERDICT_REASON = "reason";
    protected static final String EVENT_VERDICT_CAUSEDBY = "causedBy";
    protected TPFVerdict verdict = null;
    protected TPFVerdictReason verdictReason = null;
    protected String causedBy = null;

    public void initialize(HierarchyContext context, String name) {
        super.initialize(context, name);
        this.verdict = null;
        this.verdictReason = null;
        this.causedBy = null;
    }

    public void addAttribute(String name, String value) {
        this.printAttribute(name, value);
        switch (LoadersUtils.getHashCode((String)name)) {
            case 351160793: {
                this.verdict = TPFVerdict.get(Integer.parseInt(value));
                break;
            }
            case -934964668: {
                this.verdictReason = TPFVerdictReason.get(Integer.parseInt(value));
                break;
            }
            case 91997906: {
                this.causedBy = value;
                break;
            }
            default: {
                super.addAttribute(name, value);
            }
        }
    }

    public void addYourselfInContext() {
        TPFVerdictEvent verdictEvent = Common_TestprofileFactory.eINSTANCE.createTPFVerdictEvent();
        verdictEvent.setVerdict(this.verdict);
        verdictEvent.setReason(this.verdictReason);
        this.event = verdictEvent;
        super.addYourselfInContext();
        super.addYourselfToContainer();
        if (this.parentId != null) {
            TPFExecutionResult containingResult = ExecutionResultData.getContainingResult(this.event);
            containingResult.setVerdict(((TPFVerdictEvent)this.event).getVerdict());
            if (this.causedBy != null) {
                StringTokenizer tok = new StringTokenizer(this.causedBy, ",");
                EList causedByList = verdictEvent.getCausedBy();
                while (tok.hasMoreElements()) {
                    String causeId = tok.nextToken();
                    TPFVerdictEvent cause = (TPFVerdictEvent)verdictEvent.eResource().getEObject(causeId);
                    if (cause == null) continue;
                    causedByList.add(cause);
                }
            }
        }
    }

    protected boolean needOverwrite(TPFExecutionEvent match) {
        return super.needOverwrite(match);
    }

    protected void overwrite(TPFExecutionEvent match) {
        ((TPFVerdictEvent)match).setVerdict(((TPFVerdictEvent)this.event).getVerdict());
        ((TPFVerdictEvent)match).setReason(((TPFVerdictEvent)this.event).getReason());
        ((TPFVerdictEvent)match).getCausedBy().clear();
        super.overwrite(match);
    }
}

