/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.impl;

import java.util.Hashtable;
import org.eclipse.hyades.logging.adapter.AdapterInvalidConfig;
import org.eclipse.hyades.logging.adapter.IProcessUnit;
import org.eclipse.hyades.logging.adapter.impl.Component;
import org.eclipse.hyades.logging.adapter.util.Messages;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ProcessUnit
extends Component
implements IProcessUnit {
    private Hashtable properties = null;
    protected boolean flushingMode = false;

    public Object[] processEventItems(Object[] msgs) {
        CommonBaseEvent event = this.getEventFactory().createCommonBaseEvent();
        event.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_ProcessUnit_ERROR_");
        event.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID()});
        event.setSeverity((short)60);
        this.log(event);
        return null;
    }

    public Object[] flushEventItems(Object[] msgs) {
        this.flushingMode = true;
        Object[] temp = this.processEventItems(msgs);
        this.flushingMode = false;
        return temp;
    }

    public Object[] testProcessEventItems(Object[] msgs) throws AdapterInvalidConfig {
        return null;
    }

    public void update() throws AdapterInvalidConfig {
        super.update();
        Element element = this.getConfiguration();
        String propertyName = null;
        String propertyValue = null;
        this.properties = new Hashtable();
        NodeList sensorNodes = element.getChildNodes();
        for (int i = 0; i < sensorNodes.getLength(); ++i) {
            Element sensorNode;
            if (sensorNodes.item(i).getNodeType() != 1 || !(sensorNode = (Element)sensorNodes.item(i)).getTagName().equals(Messages.getString("HyadesGAPropertyElementTagName"))) continue;
            Element sensorProperty = sensorNode;
            if (sensorProperty.hasAttribute(Messages.getString("HyadesGAPropertyNameAttributeName"))) {
                propertyName = sensorProperty.getAttribute(Messages.getString("HyadesGAPropertyNameAttributeName"));
            }
            if (sensorProperty.hasAttribute(Messages.getString("HyadesGAPropertyValueAttributeName"))) {
                propertyValue = sensorProperty.getAttribute(Messages.getString("HyadesGAPropertyValueAttributeName"));
            }
            if (propertyName == null || propertyName.length() <= 0 || propertyValue == null || propertyValue.length() <= 0) continue;
            this.properties.put(propertyName, propertyValue);
        }
    }

    public Hashtable getProperties() {
        return this.properties;
    }

    public void setProperties(Hashtable hashtable) {
        this.properties = hashtable;
    }
}

