/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.http.runner;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.eclipse.hyades.test.http.runner.HttpRequest;
import org.eclipse.hyades.test.http.runner.HttpResourceBundle;
import org.eclipse.hyades.test.http.runner.HttpResponse;
import org.eclipse.hyades.test.http.runner.internal.exec.HttpRequestHandler;
import org.eclipse.hyades.test.http.runner.internal.exec.SSLHttpExecutor;

public class HttpExecutor {
    private static int iSSLClassesAvailable = -1;
    private String strLastHost = null;
    private int iLastPort = 0;
    private Socket socket = null;
    private InputStream from_server = null;
    private OutputStream to_server = null;
    private Object sslExecutor = null;
    private HttpRequestHandler httpRequestHandler = null;
    private int socketBufSize = 0;
    public int currentPageNumber;
    public int currentPageOrder;
    public String currentPageName;
    public long pageStart;
    public long pageEnd;
    public long pageResponseTime;

    public HttpResponse execute(HttpRequest httpRequest) throws Exception {
        HttpResponse httpResponse = new HttpResponse(httpRequest);
        if (iSSLClassesAvailable == -1) {
            try {
                Class<?> clazz = Class.forName("javax.net.ssl.SSLSocket");
                iSSLClassesAvailable = 1;
            }
            catch (ClassNotFoundException classNotFoundException) {
                iSSLClassesAvailable = 0;
            }
        }
        try {
            httpRequest.getClass().getMethod("getThinkTime", null);
            long l = httpRequest.getThinkTime();
            if (l > 0L) {
                Thread.sleep(l);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.httpRequestHandler == null) {
            this.httpRequestHandler = new HttpRequestHandler();
        }
        this.currentPageNumber = httpRequest.getPageNumber();
        this.currentPageOrder = httpRequest.getPageOrder();
        long l = System.currentTimeMillis();
        if (this.currentPageOrder == 1 || this.currentPageOrder == 4) {
            this.pageStart = l;
            this.currentPageName = httpRequest.getURL();
        }
        if (iSSLClassesAvailable == 1 && httpRequest.getSecure()) {
            SSLHttpExecutor sSLHttpExecutor = null;
            if (this.sslExecutor == null) {
                this.sslExecutor = new SSLHttpExecutor(this.httpRequestHandler);
            }
            sSLHttpExecutor = (SSLHttpExecutor)this.sslExecutor;
            sSLHttpExecutor.execute(httpRequest, httpResponse);
            this.setResponseEndingData(httpRequest, httpResponse, l);
            return httpResponse;
        }
        if (iSSLClassesAvailable == 0 && httpRequest.getSecure()) {
            System.out.println(HttpResourceBundle.getInstance().getString("SSL_NOTSUPPORTED"));
        }
        String string = httpRequest.getHost();
        int n = httpRequest.getPort();
        if (!(n == this.iLastPort && this.strLastHost != null && string.regionMatches(0, this.strLastHost, 0, this.strLastHost.length()) || this.connectToServer(httpResponse, string, n))) {
            httpResponse.setCode(-1);
            return httpResponse;
        }
        if (!this.httpRequestHandler.sendRequest(httpRequest, this.to_server)) {
            if (!this.connectToServer(httpResponse, string, n)) {
                httpResponse.setCode(-1);
                return httpResponse;
            }
            if (!this.httpRequestHandler.sendRequest(httpRequest, this.to_server)) {
                httpResponse.setCode(-1);
                return httpResponse;
            }
        }
        this.httpRequestHandler.getServerResponse(httpRequest, httpResponse, this.from_server, this.socketBufSize);
        if (httpResponse.getCode() == 0 && this.connectToServer(httpResponse, string, n) && this.httpRequestHandler.sendRequest(httpRequest, this.to_server)) {
            this.httpRequestHandler.getServerResponse(httpRequest, httpResponse, this.from_server, this.socketBufSize);
        }
        if (httpResponse.getShouldCloseSocket()) {
            this.strLastHost = null;
        }
        this.setResponseEndingData(httpRequest, httpResponse, l);
        return httpResponse;
    }

    private boolean setResponseEndingData(HttpRequest httpRequest, HttpResponse httpResponse, long l) {
        long l2 = System.currentTimeMillis();
        if (this.currentPageOrder == 3 || this.currentPageOrder == 4) {
            this.pageEnd = l2;
        }
        if (httpRequest.getPageOrder() == 4 || httpRequest.getPageOrder() == 3) {
            this.pageResponseTime = this.pageEnd - this.pageStart;
            System.out.println(HttpResourceBundle.getInstance().getString("PAGERESPONSE_URL") + " " + this.currentPageName + " " + HttpResourceBundle.getInstance().getString("PAGERESPONSE_TIME") + " " + this.pageResponseTime);
        } else {
            this.pageResponseTime = -1L;
        }
        httpResponse.setElapsedTime(l2 - l);
        httpResponse.setPageResponseTime(this.pageResponseTime);
        return true;
    }

    private boolean connectToServer(HttpResponse httpResponse, String string, int n) {
        try {
            if (this.socket != null) {
                this.socket.close();
            }
            this.socket = new Socket(string, n);
            this.from_server = this.socket.getInputStream();
            this.to_server = this.socket.getOutputStream();
            this.socketBufSize = this.socket.getReceiveBufferSize();
            this.iLastPort = n;
            this.strLastHost = string;
        }
        catch (Exception exception) {
            httpResponse.setCode(-1);
            httpResponse.setDetail(exception.getLocalizedMessage());
            return false;
        }
        return true;
    }
}

