/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.collection.threadanalyzer;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.hyades.collection.threadanalyzer.Proto;
import org.eclipse.hyades.collection.threadanalyzer.StkEntry;
import org.eclipse.hyades.collection.threadanalyzer.TOSEntryPoint;
import org.eclipse.hyades.collection.threadanalyzer.Thd;

public class TOSInfo {
    protected Vector _entryPoints = null;
    protected Hashtable _oldThreadsByTOS = null;
    protected Hashtable _threadsByTOS = null;
    private static int dotCountMinor = 0;
    private static int dotCountMajor = 0;

    public TOSInfo(Hashtable threadsByTOS) {
        this._oldThreadsByTOS = threadsByTOS;
        this._threadsByTOS = new Hashtable();
        this.build();
    }

    public int tosCount() {
        return this._threadsByTOS.size();
    }

    public Hashtable getTosHT() {
        return this._threadsByTOS;
    }

    protected void build() {
        Enumeration enumeration = this._oldThreadsByTOS.keys();
        while (enumeration.hasMoreElements()) {
            int j;
            int i;
            Vector<TOSEntryPoint> entryPoints = new Vector<TOSEntryPoint>();
            Vector allThreads = null;
            Vector<Proto> prototypes = new Vector<Proto>();
            String tos = (String)enumeration.nextElement();
            allThreads = (Vector)this._oldThreadsByTOS.get(tos);
            if (allThreads.size() < 1) break;
            Thd thd = (Thd)allThreads.elementAt(0);
            Proto proto = new Proto();
            proto._threads.add(thd);
            prototypes.add(proto);
            for (i = 1; i < allThreads.size(); ++i) {
                boolean fAdded = false;
                thd = (Thd)allThreads.elementAt(i);
                for (j = 0; j < prototypes.size(); ++j) {
                    proto = (Proto)prototypes.elementAt(j);
                    Thd thd2 = proto.getPrototype();
                    if (!this.compareStack(thd, thd2)) continue;
                    proto._threads.add(thd);
                    fAdded = true;
                    break;
                }
                if (fAdded) continue;
                proto = new Proto();
                proto._threads.add(thd);
                prototypes.add(proto);
            }
            ++dotCountMinor;
            if (prototypes.size() > 1) {
                for (i = 0; i < prototypes.size() - 1; ++i) {
                    Proto proto1 = (Proto)prototypes.elementAt(0);
                    for (j = i + 1; j < prototypes.size(); ++j) {
                        this.mark();
                        Proto proto2 = (Proto)prototypes.elementAt(j);
                        int idx = this.compareForStkSimilarity(proto1, proto2);
                        if (idx <= 1) continue;
                        TOSEntryPoint tep = this.findEntryPoint(proto1, idx, entryPoints);
                        if (tep != null) {
                            tep.addThreadsNoDups(proto1._threads);
                            tep.addThreadsNoDups(proto2._threads);
                            continue;
                        }
                        StkEntry se = proto1.getPrototype().getStkEntry(idx);
                        if (se == null) continue;
                        tep = new TOSEntryPoint(se);
                        tep.addThreadsNoDups(proto1._threads);
                        tep.addThreadsNoDups(proto2._threads);
                        entryPoints.add(tep);
                    }
                }
            }
            if (entryPoints == null || entryPoints.size() <= 0) continue;
            this._threadsByTOS.put(tos, entryPoints);
        }
    }

    private void mark() {
        if (dotCountMinor++ == 100) {
            dotCountMinor = 0;
            ++dotCountMajor;
        }
        if (dotCountMajor == 50) {
            dotCountMajor = 0;
        }
    }

    protected int compareForStkSimilarity(Proto proto1, Proto proto2) {
        int idx;
        Thd t1 = proto1.getPrototype();
        Thd t2 = proto2.getPrototype();
        Object se1 = null;
        Object se2 = null;
        for (idx = 0; idx < t1.getStkSize() && idx < t2.getStkSize() && t1.getStkEntry(idx).getFQName().equals(t2.getStkEntry(idx).getFQName()); ++idx) {
        }
        return idx;
    }

    protected TOSEntryPoint findEntryPoint(Proto proto, int idx, Vector entryPoints) {
        TOSEntryPoint tRet = null;
        for (int i = 0; i < entryPoints.size(); ++i) {
            StkEntry protoSe;
            String epName;
            TOSEntryPoint ep = (TOSEntryPoint)entryPoints.elementAt(i);
            if (ep != null && idx < proto.getPrototype().getStkSize() && (epName = ep.getName()).equals((protoSe = proto.getPrototype().getStkEntry(idx)).getFQName())) {
                Thd thd1 = (Thd)ep._threads.elementAt(0);
                Thd thd2 = proto.getPrototype();
                tRet = ep;
                for (int j = 0; j <= idx; ++j) {
                    if (thd1.getStkEntry(idx).getFQName().equals(thd2.getStkEntry(idx).getFQName())) continue;
                    tRet = null;
                    break;
                }
            }
            if (tRet != null) break;
        }
        return tRet;
    }

    protected boolean compareStack(Thd t1, Thd t2) {
        boolean fRet = false;
        if (t1.getStkSize() == t2.getStkSize()) {
            for (int i = 0; i < t1.getStkSize() && t1.getStkEntry(i).getFQName().equals(t2.getStkEntry(i).getFQName()); ++i) {
            }
        }
        return fRet;
    }
}

