/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.navigator;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.hyades.ui.internal.logicalfolder.LogicalFolder;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.hyades.ui.internal.util.HyadesViewerSorter;
import org.eclipse.hyades.ui.util.IDisposable;
import org.eclipse.hyades.ui.util.INamedElement;
import org.eclipse.jface.viewers.Viewer;

public class NavigatorViewerSorter
extends HyadesViewerSorter
implements IDisposable {
    public static final int SORTER_TYPE = (class$org$eclipse$hyades$ui$internal$navigator$NavigatorViewerSorter == null ? (class$org$eclipse$hyades$ui$internal$navigator$NavigatorViewerSorter = NavigatorViewerSorter.class$("org.eclipse.hyades.ui.internal.navigator.NavigatorViewerSorter")) : class$org$eclipse$hyades$ui$internal$navigator$NavigatorViewerSorter).hashCode();
    public static final int NAME = 1;
    public static final int TYPE = 2;
    private INavigator navigator;
    private int criteria;
    static /* synthetic */ Class class$org$eclipse$hyades$ui$internal$navigator$NavigatorViewerSorter;
    static /* synthetic */ Class class$org$eclipse$core$resources$IResource;

    public NavigatorViewerSorter(INavigator navigator, int criteria) {
        this.navigator = navigator;
        this.criteria = criteria != 1 && criteria != 2 ? 1 : criteria;
    }

    public void dispose() {
        this.navigator = null;
    }

    public INavigator getNavigator() {
        return this.navigator;
    }

    public void setCriteria(int newCriteria) {
        if (this.criteria == newCriteria) {
            return;
        }
        if (newCriteria != 1 && newCriteria != 2) {
            return;
        }
        this.criteria = newCriteria;
        if (this.navigator.getViewer() != null) {
            this.navigator.getViewer().refresh();
        }
        this.navigator.handleChange(SORTER_TYPE);
    }

    public int getCriteria() {
        return this.criteria;
    }

    public int category(Object element) {
        if (element instanceof IProject) {
            return 1000;
        }
        if (element instanceof IFolder) {
            return 400;
        }
        if (element instanceof LogicalFolder) {
            return 200;
        }
        return 600;
    }

    protected String getValue(Viewer viewer, Object e) {
        String value = null;
        if (e instanceof LogicalFolder && (value = this.getLogicalFolderValue(viewer, (LogicalFolder)e)) != null) {
            return value;
        }
        if (e instanceof IResource && (value = this.getResourceValue(viewer, (IResource)e)) != null) {
            return value;
        }
        if (e instanceof IAdaptable && (value = this.getAdaptableValue(viewer, (IAdaptable)e)) != null) {
            return value;
        }
        if (e instanceof INamedElement && (value = this.getNamedElementValue(viewer, (INamedElement)e)) != null) {
            return value;
        }
        return super.getValue(viewer, e);
    }

    protected String getLogicalFolderValue(Viewer viewer, LogicalFolder logicalFolder) {
        return "0";
    }

    protected String getResourceValue(Viewer viewer, IResource resource) {
        if (resource.getFileExtension() == null) {
            return resource.getName();
        }
        if (1 == this.getCriteria()) {
            return resource.getName() + "_+_" + resource.getFileExtension();
        }
        return resource.getFileExtension() + "_+_" + resource.getName();
    }

    protected String getAdaptableValue(Viewer viewer, IAdaptable adaptable) {
        IResource resource = (IResource)adaptable.getAdapter(class$org$eclipse$core$resources$IResource == null ? (class$org$eclipse$core$resources$IResource = NavigatorViewerSorter.class$("org.eclipse.core.resources.IResource")) : class$org$eclipse$core$resources$IResource);
        if (resource == null) {
            return null;
        }
        return this.getResourceValue(viewer, resource);
    }

    protected String getNamedElementValue(Viewer viewer, INamedElement namedElement) {
        return namedElement.getName();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

