/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.provider;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.internal.provider.IResourceChangeUpdater;
import org.eclipse.hyades.ui.util.IDisposable;
import org.eclipse.swt.widgets.Display;

public class ResourceChangeUpdaterProvider
implements IResourceChangeListener,
IDisposable {
    private IResourceChangeUpdater resourceChangeUpdater;

    public void dispose() {
        this.resourceChangeUpdater = null;
    }

    public void setResourceChangeUpdater(IResourceChangeUpdater resourceChangeUpdater) {
        this.resourceChangeUpdater = resourceChangeUpdater;
    }

    public IResourceChangeUpdater getResourceChangeUpdater() {
        return this.resourceChangeUpdater;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (this.getResourceChangeUpdater() == null || !this.getResourceChangeUpdater().isActive()) {
            return;
        }
        this.doProcessDelta(event.getDelta());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doProcessDelta(IResourceDelta delta) {
        this.getResourceChangeUpdater().started();
        try {
            this.processDelta(delta);
        }
        catch (Exception e) {
            HyadesUIPlugin.logError(e);
        }
        finally {
            this.getResourceChangeUpdater().ended();
        }
    }

    protected void processDelta(IResourceDelta delta) {
        int i;
        IResourceChangeUpdater resourceChangeUpdater = this.getResourceChangeUpdater();
        if (resourceChangeUpdater == null || !this.getResourceChangeUpdater().isActive()) {
            return;
        }
        IResource resource = delta.getResource();
        IResourceDelta[] affectedChildren = delta.getAffectedChildren(4);
        for (int i2 = 0; i2 < affectedChildren.length; ++i2) {
            int flags = affectedChildren[i2].getFlags();
            if (!((flags & 0x8000) != 0 ? resourceChangeUpdater.updateChildrenType(resource) : (flags & 0x100) != 0 && resourceChangeUpdater.updateContent(resource, affectedChildren[i2].getResource()))) continue;
            return;
        }
        int changeFlags = delta.getFlags();
        if ((changeFlags & 0x14000) != 0 && resourceChangeUpdater.updateProperties(resource)) {
            return;
        }
        if ((changeFlags & 0x40000) != 0 && resourceChangeUpdater.replaced(resource)) {
            return;
        }
        for (int i3 = 0; i3 < affectedChildren.length; ++i3) {
            this.processDelta(affectedChildren[i3]);
        }
        affectedChildren = delta.getAffectedChildren(2);
        if (affectedChildren.length > 0) {
            IResource[] affected = new IResource[affectedChildren.length];
            for (i = 0; i < affectedChildren.length; ++i) {
                affected[i] = affectedChildren[i].getResource();
            }
            if (resourceChangeUpdater.remove(resource, affected)) {
                return;
            }
        }
        if ((affectedChildren = delta.getAffectedChildren(1)).length > 0) {
            IResource[] affected = new IResource[affectedChildren.length];
            for (i = 0; i < affectedChildren.length; ++i) {
                affected[i] = affectedChildren[i].getResource();
            }
            if (resourceChangeUpdater.add(resource, affected)) {
                return;
            }
        }
        for (int i4 = 0; i4 < affectedChildren.length; ++i4) {
            this.processDelta(affectedChildren[i4]);
        }
    }

    public static class UIUpdaterProvider
    extends ResourceChangeUpdaterProvider
    implements Runnable {
        private IResourceDelta delta;

        public void run() {
            super.doProcessDelta(this.delta);
            this.delta = null;
        }

        protected void doProcessDelta(IResourceDelta delta) {
            this.delta = delta;
            Display.getDefault().syncExec((Runnable)this);
        }
    }
}

