/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.util;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.hyades.ui.internal.util.RuntimeExceptionDecorator;
import org.eclipse.hyades.ui.util.IDisposable;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.internal.WorkbenchPlugin;

public class CoreUtil {
    public static String getStackTrace(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        ByteArrayOutputStream errorStream = new ByteArrayOutputStream();
        PrintStream errorPS = new PrintStream(errorStream);
        throwable.printStackTrace(errorPS);
        errorPS.flush();
        String stackTrace = errorStream.toString();
        try {
            errorStream.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        return stackTrace;
    }

    public static boolean dispose(Map map) {
        if (map == null) {
            return true;
        }
        boolean ret = CoreUtil.dispose(map.values());
        map.clear();
        return ret;
    }

    public static boolean dispose(Collection disposableCandidates) {
        if (disposableCandidates == null) {
            return true;
        }
        Iterator i = disposableCandidates.iterator();
        while (i.hasNext()) {
            Object object = i.next();
            if (object instanceof IDisposable) {
                ((IDisposable)object).dispose();
                continue;
            }
            if (object instanceof Collection) {
                CoreUtil.dispose((Collection)object);
                continue;
            }
            if (!(object instanceof Map)) continue;
            CoreUtil.dispose((Map)object);
        }
        try {
            disposableCandidates.clear();
        }
        catch (UnsupportedOperationException e) {
            return false;
        }
        return true;
    }

    public static Object getObjectFieldValue(Object object, String fieldName, boolean throwException) throws RuntimeException {
        if (object == null || fieldName == null) {
            return null;
        }
        RuntimeExceptionDecorator red = null;
        Field field = null;
        Class<?> currentClass = object.getClass();
        while (field == null && currentClass != null) {
            try {
                field = currentClass.getDeclaredField(fieldName);
            }
            catch (Exception e) {
                if (throwException && red == null) {
                    red = new RuntimeExceptionDecorator(e);
                }
                currentClass = currentClass.getSuperclass();
            }
        }
        if (field == null) {
            if (red != null) {
                throw red;
            }
            return null;
        }
        try {
            field.setAccessible(true);
            return field.get(object);
        }
        catch (Exception e) {
            if (throwException) {
                throw new RuntimeExceptionDecorator(e);
            }
            return null;
        }
    }

    public static Object invokeObjectMethod(Object object, String methodName, Object[] arguments, boolean throwException) throws RuntimeException {
        Class[] parameterTypes = null;
        if (arguments != null) {
            parameterTypes = new Class[arguments.length];
            int maxi = arguments.length;
            for (int i = 0; i < maxi; ++i) {
                parameterTypes[i] = arguments[i].getClass();
            }
        }
        return CoreUtil.invokeObjectMethod(object, methodName, parameterTypes, arguments, throwException);
    }

    public static Object invokeObjectMethod(Object object, String methodName, Class[] parameterTypes, Object[] arguments, boolean throwException) throws RuntimeException {
        if (object == null || methodName == null) {
            return null;
        }
        if (parameterTypes == null) {
            parameterTypes = new Class[]{};
        }
        if (arguments == null) {
            arguments = new Object[]{};
        }
        RuntimeExceptionDecorator red = null;
        Method method = null;
        Class<?> currentClass = object.getClass();
        while (method == null && currentClass != null) {
            try {
                method = currentClass.getDeclaredMethod(methodName, parameterTypes);
            }
            catch (Exception e) {
                if (throwException && red == null) {
                    red = new RuntimeExceptionDecorator(e);
                }
                currentClass = currentClass.getSuperclass();
            }
        }
        if (method == null) {
            if (red != null) {
                throw red;
            }
            return null;
        }
        try {
            method.setAccessible(true);
            return method.invoke(object, arguments);
        }
        catch (Exception e) {
            if (throwException) {
                throw new RuntimeExceptionDecorator(e);
            }
            return null;
        }
    }

    public static int removeBitFlag(int value, int flag) {
        return ~(~value | flag);
    }

    public static int fromBynaryString(String bits) {
        int length;
        int ret = 0;
        for (int i = length = bits.length(); i > 0; --i) {
            if (bits.charAt(i - 1) != '1') continue;
            ret = (int)((double)ret + Math.pow(2.0, length - i));
        }
        return ret;
    }

    public static IElementFactory getElementFactory(String factoryId) {
        return WorkbenchPlugin.getDefault().getElementFactory(factoryId);
    }

    public static void moveUp(List owner, List elements) {
        if (owner == null || owner.isEmpty() || elements == null || elements.isEmpty()) {
            return;
        }
        int top = 0;
        Iterator i = elements.iterator();
        while (i.hasNext()) {
            Object element = i.next();
            int index = owner.indexOf(element);
            if (index < 0) continue;
            if (index > top) {
                CoreUtil.swap(owner, index, index - 1);
                continue;
            }
            ++top;
        }
    }

    public static void moveDown(List owner, List elements) {
        if (owner == null || owner.isEmpty() || elements == null || elements.isEmpty()) {
            return;
        }
        int botton = owner.size() - 1;
        ListIterator i = elements.listIterator(elements.size());
        while (i.hasPrevious()) {
            Object element = i.previous();
            int index = owner.indexOf(element);
            if (index < 0) continue;
            if (index < botton) {
                CoreUtil.swap(owner, index, index + 1);
                continue;
            }
            --botton;
        }
    }

    public static void swap(List list, int index1, int index2) {
        if (list == null || index1 == index2) {
            return;
        }
        int lastIndex = list.size() - 1;
        if (index1 > lastIndex || index2 > lastIndex || index1 < 0 || index2 < 0) {
            return;
        }
        if (index1 > index2) {
            int index = index2;
            index2 = index1;
            index1 = index;
        }
        Object o1 = list.get(index1);
        Object o2 = list.get(index2);
        list.remove(o1);
        list.remove(o2);
        list.add(index1, o2);
        list.add(index2, o1);
    }
}

