/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.util;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;

public class StringUtil {
    public static String replace(String in, String oldString, String newString) {
        if (in == null || oldString == null) {
            return in;
        }
        int oldStringLength = oldString.length();
        if (oldStringLength == 0) {
            return in;
        }
        if (newString == null) {
            newString = "";
        }
        int newStringLength = newString.length();
        int index = 0 - newStringLength;
        StringBuffer sbIn = new StringBuffer(in);
        while ((index = StringUtil.indexOf(sbIn, oldString, index + newStringLength)) >= 0) {
            sbIn.replace(index, index + oldStringLength, newString);
        }
        return sbIn.toString();
    }

    public static int indexOf(StringBuffer in, String str, int fromIndex) {
        int lengthStr;
        int lengthIn;
        if (in == null) {
            return -1;
        }
        if (str == null) {
            str = "";
        }
        if ((lengthIn = in.length()) < (lengthStr = str.length())) {
            return -1;
        }
        if (fromIndex > lengthIn) {
            if (lengthIn == 0 && fromIndex == 0 && lengthStr == 0) {
                return 0;
            }
            return -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (lengthStr == 0) {
            return fromIndex;
        }
        int strPos = 0;
        for (int i = fromIndex; i < lengthIn; ++i) {
            if (in.charAt(i) == str.charAt(strPos)) {
                if (++strPos != lengthStr) continue;
                return i - lengthStr + 1;
            }
            strPos = 0;
        }
        return -1;
    }

    public static String[] tokenizer(String text, String token, boolean includeToken) {
        if (text == null || token == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer(text);
        ArrayList<String> ret = new ArrayList<String>();
        int index = 0;
        do {
            if ((index = StringUtil.indexOf(sb, token, 0)) < 0) continue;
            if (index > 0) {
                ret.add(sb.substring(0, index));
            }
            sb.delete(0, index += token.length());
            if (!includeToken) continue;
            ret.add(token);
        } while (index >= 0);
        if (sb.length() > 0) {
            ret.add(sb.toString());
        }
        return ret.toArray(new String[ret.size()]);
    }

    public static byte[] encode(String encoding, String text) {
        if (text != null) {
            if (encoding == null) {
                return text.getBytes();
            }
            try {
                return text.getBytes(encoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return null;
    }

    public static String decode(String encoding, byte[] data) {
        if (data != null) {
            if (encoding == null) {
                return new String(data);
            }
            try {
                return new String(data, encoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return null;
    }

    public static boolean isDigits(String string) {
        if (string == null) {
            return false;
        }
        int max = string.length();
        block3: for (int i = 0; i < max; ++i) {
            switch (string.charAt(i)) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    continue block3;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    public static String toProperCase(String text) {
        if (text == null || text.length() == 0) {
            return null;
        }
        if (text.length() == 1) {
            return text.toUpperCase();
        }
        StringBuffer sb = new StringBuffer();
        String[] pieces = StringUtil.tokenizer(text, " ", true);
        for (int i = 0; i < pieces.length; ++i) {
            sb.append(pieces[i].substring(0, 1).toUpperCase());
            if (pieces[i].length() <= 1) continue;
            sb.append(pieces[i].substring(1));
        }
        return sb.toString();
    }
}

