/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.sdb.internal;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.hyades.sdb.internal.SDbPlugin;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

public class SDbPluginImages {
    private static URL fgIconBaseURL = null;
    public static final String T_OBJ = "obj16";
    public static final String T_WIZBAN = "wizban";
    public static final String IMG_IMPORT_LOG = "importactivitylog_wiz.gif";
    public static final String IMG_NEW_DB_WIZ_BAN = "new_symptomdb_wiz.gif";
    public static final String IMG_IMPORT_DB_WIZ_BAN = "import_symptomdb_wiz.gif";
    public static final String IMG_EXPORT_DB_WIZ_BAN = "export_symptomdb_wiz.gif";
    public static final String IMG_SYMPTOM_DB = "symptomdb_obj.gif";
    public static final String IMG_SYMPTOM_SOL = "symptomdb_solution_obj.gif";
    public static final String IMG_SYMPTOM_DESC = "symptomdb_desc_obj.gif";
    public static final String IMG_DB_EDITOR_BAN = "page_banner.gif";
    public static final String IMG_SYMPTOM_DIRECTIVE = "trcdirective_obj.gif";
    public static final ImageDescriptor DESC_IMG_NEW_DB_WIZ_BAN;
    public static final ImageDescriptor DESC_IMG_IMPORT_DB_WIZ_BAN;
    public static final ImageDescriptor DESC_IMG_EXPORT_DB_WIZ_BAN;
    public static final ImageDescriptor DESC_IMG_SYMPTOM_DB;
    public static final ImageDescriptor DESC_IMG_SYMPTOM_SOL;
    public static final ImageDescriptor DESC_IMG_SYMPTOM_DESC;
    public static final ImageDescriptor DESC_IMG_DB_EDITOR_BAN;
    public static final ImageDescriptor DESC_IMG_SYMPTOM_DIRECTIVE;
    protected static HashMap _images;
    protected static HashMap _imageDescriptors;

    public static Image getImage(String name) {
        return (Image)_images.get(name);
    }

    public static ImageDescriptor getImageDescriptor(String name) {
        return (ImageDescriptor)_imageDescriptors.get(name);
    }

    private static ImageDescriptor createManaged(String prefix, String name) {
        try {
            ImageDescriptor result = ImageDescriptor.createFromURL((URL)SDbPluginImages.makeIconFileURL(prefix, name));
            if (_images == null || _imageDescriptors == null) {
                _images = new HashMap();
                _imageDescriptors = new HashMap();
            }
            _imageDescriptors.put(name, result);
            _images.put(name, result.createImage());
            return result;
        }
        catch (MalformedURLException e) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    public static void setImageDescriptors(IAction action, String type, String relPath) {
        ImageDescriptor id;
        try {
            id = ImageDescriptor.createFromURL((URL)SDbPluginImages.makeIconFileURL("d" + type, relPath));
            if (id != null) {
                action.setDisabledImageDescriptor(id);
            }
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        try {
            id = ImageDescriptor.createFromURL((URL)SDbPluginImages.makeIconFileURL("c" + type, relPath));
            if (id != null) {
                action.setHoverImageDescriptor(id);
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        action.setImageDescriptor(SDbPluginImages.create("e" + type, relPath));
    }

    private static URL makeIconFileURL(String prefix, String name) throws MalformedURLException {
        StringBuffer buffer;
        if (fgIconBaseURL == null) {
            throw new MalformedURLException();
        }
        if (prefix != null) {
            buffer = new StringBuffer(prefix);
            buffer.append('/');
            buffer.append(name);
        } else {
            buffer = new StringBuffer(name);
        }
        return new URL(fgIconBaseURL, buffer.toString());
    }

    private static ImageDescriptor create(String prefix, String name) {
        try {
            return ImageDescriptor.createFromURL((URL)SDbPluginImages.makeIconFileURL(prefix, name));
        }
        catch (MalformedURLException e) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    public static void shutdown() {
        if (_images == null) {
            return;
        }
        Iterator e = _images.values().iterator();
        while (e.hasNext()) {
            Object next = e.next();
            if (!(next instanceof Image) || ((Image)next).isDisposed()) continue;
            ((Image)next).dispose();
        }
        _images.clear();
        _images = null;
        _imageDescriptors.clear();
        _imageDescriptors = null;
    }

    static {
        String pathSuffix = "icons/full/";
        try {
            fgIconBaseURL = new URL(SDbPlugin.getDefault().getDescriptor().getInstallURL(), pathSuffix);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        DESC_IMG_NEW_DB_WIZ_BAN = SDbPluginImages.createManaged(T_WIZBAN, IMG_NEW_DB_WIZ_BAN);
        DESC_IMG_IMPORT_DB_WIZ_BAN = SDbPluginImages.createManaged(T_WIZBAN, IMG_IMPORT_DB_WIZ_BAN);
        DESC_IMG_EXPORT_DB_WIZ_BAN = SDbPluginImages.createManaged(T_WIZBAN, IMG_EXPORT_DB_WIZ_BAN);
        DESC_IMG_SYMPTOM_DB = SDbPluginImages.createManaged(T_OBJ, IMG_SYMPTOM_DB);
        DESC_IMG_SYMPTOM_SOL = SDbPluginImages.createManaged(T_OBJ, IMG_SYMPTOM_SOL);
        DESC_IMG_SYMPTOM_DESC = SDbPluginImages.createManaged(T_OBJ, IMG_SYMPTOM_DESC);
        DESC_IMG_DB_EDITOR_BAN = SDbPluginImages.createManaged(T_WIZBAN, IMG_DB_EDITOR_BAN);
        DESC_IMG_SYMPTOM_DIRECTIVE = SDbPluginImages.createManaged(T_OBJ, IMG_SYMPTOM_DIRECTIVE);
    }
}

