/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.sdb.internal.util;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.sdb.internal.SDbPlugin;
import org.eclipse.hyades.sdb.internal.util.IValidateEditListener;
import org.eclipse.hyades.sdb.internal.util.ResourceStateValidator;
import org.eclipse.hyades.sdb.internal.util.TString;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;

public class ValidateEditListener
extends ShellAdapter
implements IValidateEditListener {
    private ResourceStateValidator fValidator;
    private boolean fNeedsStateValidation = true;
    private Shell fShell;
    private IWorkbenchPart fPart;
    private boolean fHasReadOnlyFiles = false;
    private boolean firstReadOnlyFileAttempt = true;
    private boolean fMessageUp = false;
    private boolean fIsActivating = false;
    private boolean fIsDeactivating = false;

    public ValidateEditListener(IWorkbenchPart part, ResourceStateValidator aValidator) {
        this.fPart = part;
        this.fValidator = aValidator;
        if (part != null) {
            part.getSite().getPage().addPartListener((IPartListener)this);
        }
        if (this.getShell() != null) {
            this.getShell().addShellListener((ShellListener)this);
        }
    }

    protected Shell getShell() {
        if (this.fShell == null && this.fPart != null && this.fPart.getSite() != null) {
            this.fShell = this.fPart.getSite().getShell();
        }
        return this.fShell;
    }

    public ResourceStateValidator getValidator() {
        return this.fValidator;
    }

    public boolean getNeedsStateValidation() {
        return this.fNeedsStateValidation;
    }

    public void setNeedsStateValidation(boolean needsStateValidation) {
        this.fNeedsStateValidation = needsStateValidation;
    }

    public boolean promptForInconsistentFileRefresh(List inconsistentFiles) {
        if (inconsistentFiles == null || inconsistentFiles.size() == 0) {
            return false;
        }
        String message = null;
        String title = SDbPlugin.getResourceString("SYMPTOMDB_MESSAGE");
        if (inconsistentFiles.size() == 1) {
            Object file = inconsistentFiles.get(0);
            String fileString = null;
            fileString = file instanceof Resource ? ((Resource)file).getURI().devicePath() : file.toString();
            message = SDbPlugin.getResourceString("STR_INCONS_FILE_EDITOR_INFO_");
            message = TString.change(message, "%1", fileString);
        } else {
            message = SDbPlugin.getResourceString("STR_INCONS_FILES_EDITOR_INFO_");
            Iterator iterator = inconsistentFiles.iterator();
            while (iterator.hasNext()) {
                message = message + "    ";
                Object file = iterator.next();
                message = file instanceof Resource ? message + ((Resource)file).getURI().devicePath() : message + file.toString();
                if (iterator.hasNext()) {
                    message = message + ",";
                }
                message = message + "\n";
            }
        }
        message = message + SDbPlugin.getResourceString("STR_UPDATE_EDITOR_INFO_");
        return MessageDialog.openQuestion((Shell)this.getShell(), (String)title, (String)message);
    }

    public Object getValidateEditContext() {
        return this.getShell();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleActivation() {
        if (this.fIsActivating) {
            return;
        }
        this.fIsActivating = true;
        try {
            this.fValidator.checkActivation(this);
            this.updatePartReadOnly();
        }
        catch (CoreException coreException) {
        }
        finally {
            this.fIsActivating = false;
        }
    }

    public void shellActivated(ShellEvent event) {
        this.handleActivation();
    }

    public void partActivated(IWorkbenchPart part) {
        if (part == this.fPart) {
            this.handleActivation();
        }
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
        if (part == this.fPart) {
            part.getSite().getPage().removePartListener((IPartListener)this);
        }
        if (this.getShell() != null) {
            this.getShell().removeShellListener((ShellListener)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void partDeactivated(IWorkbenchPart part) {
        if (part == this.fPart) {
            if (this.fIsDeactivating) {
                return;
            }
            this.fIsDeactivating = true;
            try {
                this.fValidator.lostActivation(this);
                this.updatePartReadOnly();
            }
            catch (CoreException coreException) {
            }
            finally {
                this.fIsDeactivating = true;
            }
        }
    }

    public void partOpened(IWorkbenchPart part) {
    }

    public IStatus validateState() {
        if (this.fNeedsStateValidation) {
            this.setNeedsStateValidation(false);
            IStatus status = null;
            try {
                status = this.fValidator.validateState(this);
                if (status.getSeverity() == 4) {
                    ErrorDialog.openError((Shell)this.getShell(), (String)SDbPlugin.getResourceString("SYMPTOMDB_MESSAGE"), (String)SDbPlugin.getResourceString("STR_CHECKOUT_ERR_INFO_"), (IStatus)status);
                    this.setNeedsStateValidation(true);
                }
                this.fValidator.checkActivation(this);
                this.updatePartReadOnly();
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            return status;
        }
        return ResourceStateValidator.OK_STATUS;
    }

    public boolean promptForInconsistentFileOverwrite(List inconsistentFiles) {
        if (inconsistentFiles == null || inconsistentFiles.size() == 0) {
            return false;
        }
        String message = "";
        String title = SDbPlugin.getResourceString("SYMPTOMDB_MESSAGE");
        if (inconsistentFiles.size() == 1) {
            Object file = inconsistentFiles.get(0);
            String fileString = null;
            fileString = file instanceof Resource ? ((Resource)file).getURI().devicePath() : file.toString();
            message = SDbPlugin.getResourceString("STR_INCONSISTENT_FILE_INFO_");
            message = TString.change(message, "%1", fileString);
        } else {
            message = SDbPlugin.getResourceString("STR_INCONSISTENT_FILES_INFO_");
            Iterator iterator = inconsistentFiles.iterator();
            while (iterator.hasNext()) {
                message = message + "    ";
                Object file = iterator.next();
                message = file instanceof Resource ? message + ((Resource)file).getURI().devicePath() : message + file.toString();
                if (iterator.hasNext()) {
                    message = message + ",";
                }
                message = message + "\n";
            }
        }
        message = message + SDbPlugin.getResourceString("STR_FILEOVERWRITE_INFO_");
        return MessageDialog.openQuestion((Shell)this.getShell(), (String)title, (String)message);
    }

    protected boolean checkReadOnly() {
        this.fHasReadOnlyFiles = this.fValidator.checkReadOnly();
        return this.fHasReadOnlyFiles;
    }

    public boolean hasReadOnlyFiles() {
        if (this.firstReadOnlyFileAttempt) {
            this.checkReadOnly();
            this.firstReadOnlyFileAttempt = false;
        }
        return this.fHasReadOnlyFiles;
    }

    protected void updatePartReadOnly() {
        if (!this.getNeedsStateValidation()) {
            this.checkReadOnly();
            this.setNeedsStateValidation(true);
        }
    }

    public boolean checkSave() throws CoreException {
        if (!this.validateState().isOK()) {
            return false;
        }
        return this.getValidator().checkSave(this);
    }

    public void setShell(Shell aShell) {
        this.fShell = aShell;
    }

    protected IWorkbenchPart getWorkbenchPart() {
        return this.fPart;
    }
}

