/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.collection.threadanalyzer;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.hyades.collection.threadanalyzer.DirectedGraph;
import org.eclipse.hyades.collection.threadanalyzer.DumpData;
import org.eclipse.hyades.collection.threadanalyzer.Monitor;
import org.eclipse.hyades.collection.threadanalyzer.ParseIdents;
import org.eclipse.hyades.collection.threadanalyzer.ParseMonitorOwner;
import org.eclipse.hyades.collection.threadanalyzer.ParseSystemMonitor;
import org.eclipse.hyades.collection.threadanalyzer.ParseTID;
import org.eclipse.hyades.collection.threadanalyzer.ThreadDump;

public class DeadLockDetect {
    private DirectedGraph theGraph = null;
    private Hashtable _threads = null;
    private Hashtable _ownedMonitors = null;
    private Hashtable _sysMon = null;
    private Hashtable _tid = null;
    private Hashtable _monitors = null;
    private Hashtable _idents = null;
    private ThreadDump _threadDump = null;
    private Vector _threadDumpLines = null;
    private DumpData _dumpData = null;
    private boolean doesDeadlockExist = false;
    private Vector deadlockResult = null;
    private int _logLevel = -1;

    public DeadLockDetect(DumpData dd) {
        this._dumpData = dd;
        this._monitors = dd.getMonitors();
        this._threads = dd.getThreads();
        this._threadDump = dd.getThreadDump();
        this._threadDumpLines = this._dumpData.getThreadDump().getThreadDumpVector();
        this._idents = null;
        this._ownedMonitors = null;
        this._sysMon = null;
        this.theGraph = new DirectedGraph(this._threads);
    }

    public DeadLockDetect(DumpData dd, String _logLevel) {
        this(dd);
        if (_logLevel.equalsIgnoreCase("DEBUG")) {
            this.setLogLevel(4);
        } else {
            this.setLogLevel(3);
        }
    }

    protected void collectData() {
        int monIndex = DeadLockDetect.getLocation(this._threadDumpLines, 0, "Monitor Pool Dump (");
        this.logDebug("MonitorPoolDump@" + monIndex);
        int sysMonIndex = DeadLockDetect.getLocation(this._threadDumpLines, monIndex, "JVM System Monitor Dump (registered monitors):");
        this.logDebug("JVMSysMon@" + sysMonIndex);
        int identIndex = DeadLockDetect.getLocation(this._threadDumpLines, sysMonIndex, "Thread identifiers (as used in flat monitors):");
        this.logDebug("identIndex@" + identIndex);
        this.logDebug("Populating Idents");
        ParseIdents pi = new ParseIdents(this._threadDump, this._threads);
        pi.populate(identIndex);
        this._idents = pi.getIdents();
        this.logDebug("idents Populated");
        this.logDebug("Populating TID");
        ParseTID ptid = new ParseTID(this._threadDumpLines);
        ptid.doIt();
        this._tid = ptid.getTIDMap();
        this.theGraph.putReversedTid(ptid.getReversedTIDMap());
        this.logDebug("TID populated");
        this.logDebug("Populating Monitor Owner");
        ParseMonitorOwner pmo = new ParseMonitorOwner(this._idents, this._threads, this._monitors, this._tid, this._threadDump);
        pmo.doIt(monIndex);
        this.logDebug("Monitor owner populated");
        this.logDebug("Populating system monitors");
        ParseSystemMonitor psm = new ParseSystemMonitor(this._threads, this._idents, this._threadDumpLines);
        psm.doIt(sysMonIndex, identIndex);
        this.logDebug("system monitors populated");
        this._ownedMonitors = pmo.getOwnedMonitors();
        this._sysMon = psm.getSysMon();
        this.logDebug("building directed graph for deadlock detection");
        this.buildDirectedGraph();
        this.logDebug("directed graph built");
    }

    protected void buildDirectedGraph() {
        int k;
        Iterator i = this._threads.keySet().iterator();
        while (i.hasNext()) {
            this.theGraph.addVertex(this._threads.get(i.next()));
        }
        i = this._ownedMonitors.keySet().iterator();
        Monitor m = null;
        while (i.hasNext()) {
            m = (Monitor)this._ownedMonitors.get(i.next());
            for (k = 0; k < m._waiters.size(); ++k) {
                this.theGraph.addEdge(m, m._owner, m._waiters.get(k));
            }
        }
        i = this._sysMon.keySet().iterator();
        while (i.hasNext()) {
            m = (Monitor)this._sysMon.get(i.next());
            for (k = 0; k < m._waiters.size(); ++k) {
                this.theGraph.addEdge(m, m._owner, m._waiters.get(k));
            }
        }
    }

    public void doIt() {
        this.collectData();
        this.theGraph.findCircularPattern();
        this.logDebug("finding/looking for circular pattern");
        this.deadlockResult = this.theGraph.getNotNullPairs();
        this.doesDeadlockExist = this.theGraph.getDeadlockExists();
    }

    public Vector getResults() {
        return this.deadlockResult;
    }

    public void copyIt(String from, String to) {
        Vector _lines = this._threadDump.getThreadDumpVector();
        this.deadlockResult = new Vector(100);
        String line = null;
        block0: for (int i = 0; i < _lines.size(); ++i) {
            line = (String)_lines.get(i);
            if (line.indexOf(from) == -1) continue;
            this.doesDeadlockExist = true;
            for (int j = i; j < _lines.size(); ++j) {
                line = (String)_lines.get(j);
                if ((line = line.substring(line.indexOf(":") + 1, line.length())).indexOf(to) != -1) break block0;
                this.deadlockResult.add(line);
            }
            break;
        }
        if (!this.doesDeadlockExist) {
            this.deadlockResult = null;
        }
    }

    public static final int getLocation(Vector vector, int startIndex, String lookForData) {
        int index = 0;
        int size = vector.size();
        for (index = startIndex; index < size && ((String)vector.elementAt(index)).indexOf(lookForData) < 0; ++index) {
        }
        return index;
    }

    public boolean getDeadlockExists() {
        return this.doesDeadlockExist;
    }

    public void setLogLevel(int logLevel) {
        this._logLevel = logLevel;
    }

    public void logDebug(String msg) {
        if (this._logLevel >= 4) {
            System.err.println("DEBUG: " + msg);
        }
    }
}

