/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.collection.threadanalyzer;

import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.hyades.collection.threadanalyzer.DumpData;
import org.eclipse.hyades.collection.threadanalyzer.TAUtils;
import org.eclipse.hyades.collection.threadanalyzer.TaGridElement;
import org.eclipse.hyades.collection.threadanalyzer.TaTosNameGridElement;
import org.eclipse.hyades.collection.threadanalyzer.TaTosPctPoolGridElement;
import org.eclipse.hyades.collection.threadanalyzer.TaTosThdCountGridElement;
import org.eclipse.hyades.collection.threadanalyzer.TaTosWeightGridElement;
import org.eclipse.hyades.collection.threadanalyzer.Thd;

public class OrbThreadPool {
    private DumpData _d = null;

    public OrbThreadPool(DumpData d) {
        this._d = d;
    }

    private OrbThreadPool() {
    }

    public Object[] getTosGridHeaders() {
        return new Object[]{TAUtils.getNLSValue("ta.string.Method", "Method"), TAUtils.getNLSValue("ta.string.Same", "#Same"), TAUtils.getNLSValue("ta.string.PctOfPool", "Pct Of Pool"), TAUtils.getNLSValue("ta.string.Weight", "Weight")};
    }

    public TaGridElement[][] getTosGrid() {
        TaGridElement[][] ga = null;
        if (this._d._threadsByTOS != null) {
            int poolSize = 0;
            Enumeration e = this._d._threadsByTOS.keys();
            Vector<TaGridElement[]> gridElements = new Vector<TaGridElement[]>();
            while (e.hasMoreElements()) {
                String tosKey = (String)e.nextElement();
                Vector v = (Vector)this._d._threadsByTOS.get(tosKey);
                int sameTos = 0;
                int weightFactor = 0;
                TaGridElement[] ge = null;
                for (int i = 0; i < v.size(); ++i) {
                    Thd thd = (Thd)v.elementAt(i);
                    if (!thd.isOrbThread()) continue;
                    ++sameTos;
                    ++poolSize;
                    weightFactor += thd.waitingForOrbWork() ? 0 : 1;
                }
                if (sameTos <= 0) continue;
                String tosInfo = null;
                try {
                    this._d._tosTrans.getString(tosKey);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                ge = new TaGridElement[]{new TaTosNameGridElement(tosKey, tosInfo != null ? tosInfo : TAUtils.getNLSValue("ta.msg.NoMoreInfo", "no additional information")), new TaTosThdCountGridElement(sameTos, tosInfo != null ? tosInfo : TAUtils.getNLSValue("ta.msg.NoMoreInfo", "no additional information")), new TaTosPctPoolGridElement(0, tosInfo != null ? tosInfo : TAUtils.getNLSValue("ta.msg.NoMoreInfo", "no additional information")), new TaTosWeightGridElement(weightFactor, TAUtils.getNLSValue("ta.msg.HigherWeightFactors", "Higher weight factors may indicate a need to review the code path and/or resource utilization."))};
                gridElements.add(ge);
            }
            if (gridElements.size() > 0) {
                ga = new TaGridElement[gridElements.size()][4];
                for (int i = 0; i < gridElements.size(); ++i) {
                    TaGridElement[] gea = null;
                    gea = (TaGridElement[])gridElements.elementAt(i);
                    for (int j = 0; j < gea.length; ++j) {
                        ga[i][j] = gea[j];
                    }
                }
                int totPct = 0;
                TaTosPctPoolGridElement greatestElem = null;
                int greatestPct = 0;
                for (int i = 0; i < ga.length; ++i) {
                    TaTosPctPoolGridElement tmp = (TaTosPctPoolGridElement)ga[i][2];
                    TaTosThdCountGridElement thdCountElem = (TaTosThdCountGridElement)ga[i][1];
                    int pct = (int)((double)thdCountElem.getThdCount() / (double)poolSize * 100.0);
                    totPct += pct;
                    tmp.setPctOfPool(pct);
                    if (pct <= greatestPct) continue;
                    greatestPct = pct;
                    greatestElem = tmp;
                }
                this.sort(ga, 2);
                int errPct = totPct - 100;
                int loopCt = 10;
                block7: while (errPct != 0 && loopCt > 0) {
                    for (int i = 0; i < ga.length; ++i) {
                        TaTosPctPoolGridElement tmp = (TaTosPctPoolGridElement)ga[i][2];
                        if (errPct == 0) continue block7;
                        if (errPct > 0 && tmp.getPctOfPool() > 1) {
                            tmp.setPctOfPool(tmp.getPctOfPool() - 1);
                            --errPct;
                            continue;
                        }
                        if (errPct >= 0) continue;
                        tmp.setPctOfPool(tmp.getPctOfPool() + 1);
                        ++errPct;
                    }
                }
                this.sort(ga, 3);
            }
        }
        return ga;
    }

    protected void sort(TaGridElement[][] gea, int sortCol) {
        int elements = gea.length;
        if (elements > 0) {
            int width = gea[0].length;
            for (int i = 0; i < elements; ++i) {
                for (int j = 0; j < elements - 1; ++j) {
                    TaGridElement e1 = gea[j][sortCol];
                    TaGridElement e2 = gea[j + 1][sortCol];
                    if (e1.compareTo(e2) <= 0) continue;
                    TaGridElement[] tmp = gea[j];
                    gea[j] = gea[j + 1];
                    gea[j + 1] = tmp;
                }
            }
        }
    }
}

