/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.collection.correlation;

import org.eclipse.hyades.collection.correlation.IApplication;
import org.eclipse.hyades.collection.correlation.Stack;

public class ServiceRegistry
extends Stack {
    private static final int INITIAL_REGISTRY_SIZE = 5;
    private static final int INCREMENT_REGISTRY_SIZE = 5;
    private static ServiceRegistry registry;

    private ServiceRegistry() {
        super(5, 5);
    }

    public static synchronized ServiceRegistry getRegistry() {
        if (registry == null) {
            registry = new ServiceRegistry();
        }
        return registry;
    }

    public synchronized IApplication[] getApplications() {
        return (IApplication[])this.stack;
    }

    public synchronized IApplication getApplicationById(int id) {
        for (int i = 0; i <= this.top; ++i) {
            IApplication registered = (IApplication)this.stack[i];
            if (registered.getId() != id) continue;
            return registered;
        }
        return null;
    }

    public synchronized boolean registerApplication(IApplication application) {
        if (this.getApplicationById(application.getId()) == null) {
            this.push(application);
            return true;
        }
        return false;
    }

    public synchronized boolean deregisterApplication(IApplication application) {
        for (int i = 0; i <= this.top; ++i) {
            IApplication registered = (IApplication)this.stack[i];
            if (registered != application) continue;
            this.stack[i] = this.stack[this.top--];
            return true;
        }
        return false;
    }
}

