/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.impl;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.hyades.logging.adapter.AdapterException;
import org.eclipse.hyades.logging.adapter.AdapterInvalidConfig;
import org.eclipse.hyades.logging.adapter.AdapterPlugin;
import org.eclipse.hyades.logging.adapter.IComponent;
import org.eclipse.hyades.logging.adapter.IContext;
import org.eclipse.hyades.logging.adapter.IContextListener;
import org.eclipse.hyades.logging.adapter.IProcessUnit;
import org.eclipse.hyades.logging.adapter.impl.AdapterContext;
import org.eclipse.hyades.logging.adapter.impl.Component;
import org.eclipse.hyades.logging.adapter.impl.ComponentFactory;
import org.eclipse.hyades.logging.adapter.impl.Context;
import org.eclipse.hyades.logging.adapter.impl.ContextFactory;
import org.eclipse.hyades.logging.adapter.parsers.PreparationException;
import org.eclipse.hyades.logging.adapter.util.AdapterUtilities;
import org.eclipse.hyades.logging.adapter.util.Messages;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Controller
implements Runnable {
    private boolean singleFileInputMode = false;
    private IContext[] contexts;
    private Thread[] contextThreads;
    private String contextConfigurationFile = Messages.getString("HyadesGADefaultContextConfigurationFile");
    private String componentConfigurationFile = Messages.getString("HyadesGADefaultComponentConfigurationsFile");
    private DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
    private InputStream inContextParams = null;
    private InputStream inAppParams = null;
    private boolean running = false;
    private long sleepTime = 500L;

    public boolean isRunning() {
        return this.running;
    }

    public void start() {
        for (int i = 1; i < this.contextThreads.length; ++i) {
            if (this.contexts[i] == null) continue;
            this.contextThreads[i] = new Thread(this.contexts[i]);
            this.contextThreads[i].setName(this.contexts[i].getName() + Messages.getString("HyadesGA") + this.contexts[i].getUniqueID());
            this.contextThreads[i].setDaemon(true);
            this.contextThreads[i].start();
        }
        this.running = true;
    }

    public void stop() {
        if (this.contexts != null) {
            for (int i = this.contexts.length - 1; i >= 0; --i) {
                if (this.contexts[i] == null) continue;
                this.contexts[i].stop();
            }
        }
        this.running = false;
    }

    public void hardStop() {
        if (this.contexts != null) {
            for (int i = this.contexts.length - 1; i >= 0; --i) {
                if (this.contexts[i] == null) continue;
                ((Context)this.contexts[i]).setHardStop();
                this.contexts[i].stop();
            }
        }
        this.running = false;
    }

    public IContext[] getContexts() {
        return this.contexts;
    }

    public void setContextConfigPath(String config) {
        this.contextConfigurationFile = config;
    }

    public void setComponentConfigPath(String config) {
        this.componentConfigurationFile = config;
    }

    /*
     * Loose catch block
     */
    public void prepareAdapter() throws AdapterException {
        block20: {
            this.inContextParams = new FileInputStream(this.contextConfigurationFile);
            this.contexts = this.createContextsAndComponents(this.inContextParams);
            this.inAppParams = this.singleFileInputMode ? new FileInputStream(this.contextConfigurationFile) : new FileInputStream(this.componentConfigurationFile);
            this.setComponentConfigurations(this.inAppParams);
            try {
                List contextListeners = AdapterPlugin.getContextListeners();
                if (contextListeners != null) {
                    Iterator listenerIterator = contextListeners.iterator();
                    while (listenerIterator.hasNext()) {
                        IContextListener listener = (IContextListener)listenerIterator.next();
                        String[] targetContexts = listener.getTargetContextUniqueIds();
                        for (int j = 0; j < targetContexts.length; ++j) {
                            for (int k = 0; k < this.contexts.length; ++k) {
                                if (!this.contexts[k].getUniqueID().equals(targetContexts[j])) continue;
                                this.contexts[k].setContextListener(listener);
                            }
                        }
                    }
                }
            }
            catch (Throwable e) {
                // empty catch block
            }
            IProcessUnit logger = this.startInternalLoggingContext();
            for (int i = 1; i < this.contexts.length; ++i) {
                if (this.contexts[i] == null) continue;
                this.contexts[i].setLogger(logger);
                this.contexts[i].init();
                try {
                    this.contexts[i].update();
                    continue;
                }
                catch (AdapterException e) {
                    this.contexts[i] = null;
                    this.log(Messages.getString("HyadesGAContextFatal_ERROR_"));
                    throw e;
                }
            }
            Object var8_11 = null;
            try {
                if (this.inAppParams != null) {
                    this.inAppParams.close();
                }
                if (this.inContextParams != null) {
                    this.inContextParams.close();
                }
                break block20;
            }
            catch (IOException e) {
                this.log(e.toString());
            }
            break block20;
            {
                catch (Exception e) {
                    this.log(Messages.getString("HyadesGAAdapterFatal_ERROR_"));
                    this.log(e.getMessage());
                    throw new AdapterException(e.getMessage());
                }
            }
            catch (Throwable throwable) {
                Object var8_12 = null;
                try {
                    if (this.inAppParams != null) {
                        this.inAppParams.close();
                    }
                    if (this.inContextParams != null) {
                        this.inContextParams.close();
                    }
                }
                catch (IOException e) {
                    this.log(e.toString());
                }
                throw throwable;
            }
        }
    }

    public void update(Element temp) {
    }

    private Context[] createContextsAndComponents(InputStream inContextStream) throws PreparationException {
        Document doc = null;
        Context[] contexts = null;
        try {
            int i;
            NodeList children;
            Node contextsElement;
            doc = this.docFactory.newDocumentBuilder().parse(inContextStream);
            Element loggingContext = doc.createElement(Messages.getString("HyadesGAContextElementTagName"));
            loggingContext.setAttribute(Messages.getString("HyadesGADescriptionAttributeName"), "Context instance for the current component");
            loggingContext.setAttribute(Messages.getString("HyadesGAExecutableClassAttributeName"), "org.eclipse.hyades.logging.adapter.impl.AdapterContext");
            loggingContext.setAttribute(Messages.getString("HyadesGAImplemenationCreationDateAttributeName"), "Fri Jan 09 15:27:17 EST 2004");
            loggingContext.setAttribute(Messages.getString("HyadesGALoggingLevelAttributeName"), "60");
            loggingContext.setAttribute(Messages.getString("HyadesGANameAttributeName"), "AdaptorContext");
            loggingContext.setAttribute(Messages.getString("HyadesGARoleAttributeName"), "context");
            loggingContext.setAttribute(Messages.getString("HyadesGARoleCreationDateAttributeName"), "Fri Jan 09 15:27:17 EST 2004");
            loggingContext.setAttribute(Messages.getString("HyadesGAUniqueIDAttributeName"), "NB1F4ED002DA11D8A519FBE7C98C2F53");
            Element loggingSensor = doc.createElement(Messages.getString("HyadesGAComponentElementTagName"));
            loggingSensor.setAttribute(Messages.getString("HyadesGADescriptionAttributeName"), "Adapter logging sensor");
            loggingSensor.setAttribute(Messages.getString("HyadesGAExecutableClassAttributeName"), "org.eclipse.hyades.logging.adapter.internal.util.AdapterSensor");
            loggingSensor.setAttribute(Messages.getString("HyadesGAImplemenationCreationDateAttributeName"), "Fri Jan 09 15:27:17 EST 2004");
            loggingSensor.setAttribute(Messages.getString("HyadesGALoggingLevelAttributeName"), "0");
            loggingSensor.setAttribute(Messages.getString("HyadesGANameAttributeName"), "AdapterSensor");
            loggingSensor.setAttribute(Messages.getString("HyadesGARoleAttributeName"), "sensor");
            loggingSensor.setAttribute(Messages.getString("HyadesGARoleCreationDateAttributeName"), "Fri Jan 09 15:27:17 EST 2004");
            loggingSensor.setAttribute(Messages.getString("HyadesGAUniqueIDAttributeName"), "NF991E0004FF11D8930381B6A308BEB5");
            loggingContext.appendChild(loggingSensor);
            Element loggingOutputter = doc.createElement(Messages.getString("HyadesGAComponentElementTagName"));
            loggingOutputter.setAttribute(Messages.getString("HyadesGADescriptionAttributeName"), "Adapter logging outputter");
            loggingOutputter.setAttribute(Messages.getString("HyadesGAImplemenationCreationDateAttributeName"), "Fri Jan 09 15:27:17 EST 2004");
            loggingOutputter.setAttribute(Messages.getString("HyadesGAImplementationVersionAttributeName"), "");
            loggingOutputter.setAttribute(Messages.getString("HyadesGAImplemenationVersionDescriptionAttributeName"), "");
            loggingOutputter.setAttribute(Messages.getString("HyadesGARoleAttributeName"), "outputter");
            loggingOutputter.setAttribute(Messages.getString("HyadesGARoleCreationDateAttributeName"), "Fri Jan 09 15:27:17 EST 2004");
            loggingOutputter.setAttribute(Messages.getString("HyadesGAUniqueIDAttributeName"), "N5F286A002DA11D8BC799C6AF4352915");
            if (AdapterUtilities.isWorkbench()) {
                loggingOutputter.setAttribute(Messages.getString("HyadesGALoggingLevelAttributeName"), "10");
                loggingOutputter.setAttribute(Messages.getString("HyadesGAExecutableClassAttributeName"), "org.eclipse.hyades.logging.adapter.internal.util.GlaTaskOutputter");
                loggingOutputter.setAttribute(Messages.getString("HyadesGANameAttributeName"), "CBEEclipseErrorDialogOutputter");
            } else {
                loggingOutputter.setAttribute(Messages.getString("HyadesGALoggingLevelAttributeName"), "30");
                loggingOutputter.setAttribute(Messages.getString("HyadesGAExecutableClassAttributeName"), "org.eclipse.hyades.logging.adapter.outputters.CBEFileOutputter");
                loggingOutputter.setAttribute(Messages.getString("HyadesGANameAttributeName"), "CBEFileOutputter");
            }
            loggingContext.appendChild(loggingOutputter);
            NodeList contextsNodeList = doc.getElementsByTagName(Messages.getString("HyadesGAContextsElementTagName"));
            if (contextsNodeList.getLength() == 0) {
                contextsElement = doc.createElement(Messages.getString("HyadesGAContextsElementTagName"));
                children = contextsElement.getChildNodes();
                for (i = 0; i < children.getLength(); ++i) {
                    if (children.item(i).getNodeType() != 1) continue;
                    contextsElement.insertBefore(loggingContext, children.item(i));
                    break;
                }
                doc.getDocumentElement().appendChild(contextsElement);
            } else {
                contextsElement = contextsNodeList.item(0);
                children = contextsElement.getChildNodes();
                for (i = 0; i < children.getLength(); ++i) {
                    if (children.item(i).getNodeType() != 1) continue;
                    contextsElement.insertBefore(loggingContext, children.item(i));
                    break;
                }
                doc.getDocumentElement().appendChild(contextsElement);
            }
            try {
                NodeList contextList = doc.getElementsByTagName(Messages.getString("HyadesGAContextElementTagName"));
                NodeList tempInstanceList = doc.getElementsByTagName(Messages.getString("HyadesGAContextInstanceElementTagName"));
                this.singleFileInputMode = tempInstanceList.getLength() > 0;
                int count = contextList.getLength();
                contexts = new Context[count];
                int j = 0;
                Element element = null;
                Context context = null;
                Component component = null;
                for (int i2 = 0; i2 < count; ++i2) {
                    element = (Element)contextList.item(i2);
                    context = ContextFactory.buildContext(element.getAttribute(Messages.getString("HyadesGAExecutableClassAttributeName")), element.getAttribute(Messages.getString("HyadesGAUniqueIDAttributeName")), element.getAttribute(Messages.getString("HyadesGANameAttributeName")));
                    context.setContextConfiguration(element);
                    NodeList componentList = element.getElementsByTagName(Messages.getString("HyadesGAComponentElementTagName"));
                    IComponent[] compArray = null;
                    int componentCount = componentList.getLength();
                    compArray = new IComponent[componentCount];
                    int l = 0;
                    for (int k = 0; k < componentCount; ++k) {
                        element = (Element)componentList.item(k);
                        String executableClass1 = element.getAttribute(Messages.getString("HyadesGAExecutableClassAttributeName"));
                        String componentName1 = element.getAttribute(Messages.getString("HyadesGANameAttributeName"));
                        component = ComponentFactory.buildComponent(element.getAttribute(Messages.getString("HyadesGAExecutableClassAttributeName")), element.getAttribute(Messages.getString("HyadesGAUniqueIDAttributeName")), element.getAttribute(Messages.getString("HyadesGANameAttributeName")));
                        component.setContextConfiguration(element);
                        compArray[l++] = component;
                    }
                    context.setComponents(compArray);
                    contexts[j++] = context;
                }
            }
            catch (Exception e) {
                this.log(e.toString());
                throw new PreparationException(e.getMessage());
            }
        }
        catch (SAXException e) {
            this.log(e.toString());
        }
        catch (ParserConfigurationException e) {
            this.log(e.toString());
        }
        catch (IOException e) {
            this.log(e.toString());
        }
        return contexts;
    }

    private void setComponentConfigurations(InputStream inAppStream) throws AdapterInvalidConfig {
        Document doc = null;
        try {
            Node loggerConfigurationInstance;
            Element loggingOutputterInstance;
            doc = this.docFactory.newDocumentBuilder().parse(inAppStream);
            Element loggingSensorInstance = doc.createElement(Messages.getString("HyadesGASensorTagName"));
            loggingSensorInstance.setAttribute(Messages.getString("HyadesGADescriptionAttributeName"), "An adapter CBE sensor");
            loggingSensorInstance.setAttribute(Messages.getString("HyadesGAmaximumBlockingAttributeName"), "5");
            loggingSensorInstance.setAttribute(Messages.getString("HyadesGAUniqueIDAttributeName"), "NF991E0004FF11D8930381B6A308BEB5");
            Element loggerContextInstance = doc.createElement(Messages.getString("HyadesGAContextInstanceElementTagName"));
            loggerContextInstance.setAttribute(Messages.getString("HyadesGADescriptionAttributeName"), "Context instance for the current component");
            loggerContextInstance.setAttribute(Messages.getString("HyadesGAcontinuousOperationAttributeName"), "true");
            loggerContextInstance.setAttribute(Messages.getString("HyadesGAmaximumIdleTimeAttributeName"), "600000");
            loggerContextInstance.setAttribute(Messages.getString("HyadesGApauseIntervalAttributeName"), "10");
            loggerContextInstance.setAttribute(Messages.getString("HyadesGAUniqueIDAttributeName"), "NB1F4ED002DA11D8A519FBE7C98C2F53");
            loggerContextInstance.appendChild(loggingSensorInstance);
            if (AdapterUtilities.isWorkbench()) {
                loggingOutputterInstance = doc.createElement(Messages.getString("HyadesGAOutputterTagName"));
                loggingOutputterInstance.setAttribute(Messages.getString("HyadesGADescriptionAttributeName"), "Eclipse error dialog outputter");
                loggingOutputterInstance.setAttribute(Messages.getString("HyadesGAUniqueIDAttributeName"), "N5F286A002DA11D8BC799C6AF4352915");
                Element resourcePathProperty = doc.createElement(Messages.getString("HyadesGAPropertyElementTagName"));
                resourcePathProperty.setAttribute(Messages.getString("HyadesGAPropertyNameAttributeName"), "resourceName");
                resourcePathProperty.setAttribute(Messages.getString("HyadesGAPropertyValueAttributeName"), this.contextConfigurationFile);
                loggingOutputterInstance.appendChild(resourcePathProperty);
                loggerContextInstance.appendChild(loggingOutputterInstance);
            } else {
                loggingOutputterInstance = doc.createElement(Messages.getString("HyadesGAOutputterTagName"));
                loggingOutputterInstance.setAttribute(Messages.getString("HyadesGADescriptionAttributeName"), "Single file outputter");
                loggingOutputterInstance.setAttribute(Messages.getString("HyadesGAUniqueIDAttributeName"), "N5F286A002DA11D8BC799C6AF4352915");
                Element outputterProperty = doc.createElement(Messages.getString("HyadesGAPropertyElementTagName"));
                outputterProperty.setAttribute(Messages.getString("HyadesGAPropertyValueAttributeName"), ".");
                outputterProperty.setAttribute(Messages.getString("HyadesGAPropertyNameAttributeName"), Messages.getString("HyadesGAdirectoryAttributeName"));
                loggingOutputterInstance.appendChild(outputterProperty);
                outputterProperty = doc.createElement(Messages.getString("HyadesGAPropertyElementTagName"));
                outputterProperty.setAttribute(Messages.getString("HyadesGAPropertyValueAttributeName"), "hgla.log");
                outputterProperty.setAttribute(Messages.getString("HyadesGAPropertyNameAttributeName"), Messages.getString("HyadesGAfileNameAttributeName"));
                loggingOutputterInstance.appendChild(outputterProperty);
                loggerContextInstance.appendChild(loggingOutputterInstance);
            }
            NodeList configurationNodeList = doc.getElementsByTagName(Messages.getString("HyadesGAConfigurationTagName"));
            if (configurationNodeList.getLength() == 0) {
                loggerConfigurationInstance = doc.createElement(Messages.getString("HyadesGAConfigurationTagName"));
                loggerConfigurationInstance.setAttribute(Messages.getString("HyadesGADescriptionAttributeName"), "The component level configurations for this adapter");
                loggerConfigurationInstance.setAttribute(Messages.getString("HyadesGAUniqueIDAttributeName"), "N06FBD3004FF11D8BCF4CFA9EA8F31E7");
                loggerConfigurationInstance.appendChild(loggerContextInstance);
                doc.getDocumentElement().appendChild(loggerConfigurationInstance);
            } else {
                loggerConfigurationInstance = configurationNodeList.item(0);
                loggerConfigurationInstance.appendChild(loggerContextInstance);
                doc.getDocumentElement().appendChild(loggerConfigurationInstance);
            }
            try {
                NodeList contextInstanceList = doc.getElementsByTagName(Messages.getString("HyadesGAContextInstanceElementTagName"));
                int contextInstanceCount = contextInstanceList.getLength();
                for (int i = 0; i < contextInstanceCount; ++i) {
                    try {
                        Element contextElement = (Element)contextInstanceList.item(i);
                        String contextInstanceID = contextElement.getAttribute(Messages.getString("HyadesGAUniqueIDAttributeName"));
                        int contextCount = this.contexts.length;
                        if (contextInstanceCount != contextCount) {
                            throw new AdapterInvalidConfig(Messages.getString("HyadesGAContextConfigurationErrorContextCountMismatchFatal_ERROR_"));
                        }
                        boolean contextFound = false;
                        for (int j = 0; j < contextCount; ++j) {
                            if (!this.contexts[j].getUniqueID().equals(contextInstanceID)) continue;
                            this.contexts[j].setConfiguration(contextElement);
                            contextFound = true;
                            NodeList componentInstanceList = contextElement.getChildNodes();
                            int numberOfComponentInstances = componentInstanceList.getLength();
                            IComponent[] components = this.contexts[j].getComponents();
                            int componentCount = components.length;
                            int componentInstanceCount = 0;
                            for (int k = 0; k < numberOfComponentInstances; ++k) {
                                if (componentInstanceList.item(k).getNodeType() != 1) continue;
                                Element componentElement = (Element)componentInstanceList.item(k);
                                String componentInstanceID = componentElement.getAttribute(Messages.getString("HyadesGAUniqueIDAttributeName"));
                                boolean componentFound = false;
                                ++componentInstanceCount;
                                for (int l = 0; l < componentCount; ++l) {
                                    if (!components[l].getUniqueID().equals(componentInstanceID)) continue;
                                    components[l].setConfiguration(componentElement);
                                    componentFound = true;
                                    break;
                                }
                                if (componentFound) continue;
                                throw new AdapterInvalidConfig(Messages.getString("HyadesGAContextInstanceConfigurationErrorComponentIdNotFoundFatal_ERROR_", componentInstanceID, this.contexts[j].getUniqueID()));
                            }
                            if (componentInstanceCount == componentCount) break;
                            throw new AdapterInvalidConfig(Messages.getString("HyadesGAContextInstanceConfigurationErrorComponentMismatchFatal_ERROR_", this.contexts[j].getUniqueID()));
                        }
                        if (contextFound) continue;
                        throw new AdapterInvalidConfig(Messages.getString("HyadesGAContextInstanceConfigurationErrorContextIdNotFoundFatal_ERROR_", contextInstanceID));
                    }
                    catch (AdapterInvalidConfig e) {
                        throw e;
                    }
                    catch (Exception e) {
                        this.log(e.toString());
                    }
                }
            }
            catch (AdapterInvalidConfig e) {
                throw e;
            }
            catch (Exception e) {
                this.log(e.toString());
                return;
            }
        }
        catch (SAXException e) {
            this.log(e.toString());
        }
        catch (ParserConfigurationException e) {
            this.log(e.toString());
        }
        catch (IOException e) {
            this.log(e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.start();
        while (this.isRunning()) {
            Controller controller = this;
            synchronized (controller) {
                try {
                    this.wait(this.sleepTime);
                }
                catch (Exception e) {
                    this.log(e.toString());
                }
                if (this.areContextsDone()) {
                    this.stop();
                }
            }
        }
    }

    private boolean areContextsDone() {
        if (this.contextThreads != null) {
            for (int i = 1; i < this.contextThreads.length; ++i) {
                if (this.contextThreads[i] == null || !this.contextThreads[i].isAlive() || this.contexts[i] instanceof AdapterContext) continue;
                return false;
            }
        }
        return true;
    }

    private void clean() {
        if (this.contexts != null) {
            for (int i = 0; i < this.contexts.length; ++i) {
                this.contexts[i] = null;
            }
        }
        this.contexts = null;
    }

    private IProcessUnit startInternalLoggingContext() {
        this.contexts[0].init();
        this.contextThreads = new Thread[this.contexts.length];
        try {
            this.contexts[0].update();
            this.contextThreads[0] = new Thread(this.contexts[0]);
            this.contextThreads[0].setName(this.contexts[0].getName() + Messages.getString("HyadesGA") + this.contexts[0].getUniqueID());
            this.contextThreads[0].setDaemon(true);
            this.contextThreads[0].start();
            return (IProcessUnit)this.contexts[0].getComponents()[0];
        }
        catch (AdapterException adapterException) {
            return null;
        }
    }

    public void log(String logRecord) {
        if (!AdapterUtilities.isWorkbench()) {
            System.err.println(logRecord);
        }
    }
}

