/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.internal.util;

import java.util.Hashtable;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.hyades.logging.adapter.AdapterInvalidConfig;
import org.eclipse.hyades.logging.adapter.IOutputter;
import org.eclipse.hyades.logging.adapter.impl.Outputter;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;

public class GlaTaskOutputter
extends Outputter
implements IOutputter {
    IFile resource;

    public Object[] processEventItems(Object[] msgs) {
        if (msgs == null) {
            return msgs;
        }
        return this.processCBEs((CommonBaseEvent[])msgs);
    }

    public void update() throws AdapterInvalidConfig {
        String resourcePath;
        super.update();
        Hashtable outputterProperties = this.getProperties();
        if (outputterProperties != null && !outputterProperties.isEmpty() && (resourcePath = (String)outputterProperties.get("resourceName")) != null && !resourcePath.equals("")) {
            IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            this.resource = workspaceRoot.getFileForLocation((IPath)new Path(resourcePath));
        }
    }

    private CommonBaseEvent[] processCBEs(CommonBaseEvent[] events) {
        short currentLoggingLevel = this.getLoggingLevel();
        if (this.resource != null) {
            for (int i = 0; i < events.length; ++i) {
                IMarker marker;
                CommonBaseEvent event = events[i];
                short severity = event.getSeverity();
                if (events[i] == null || severity < currentLoggingLevel || !(marker = this.createProblemMarker((IResource)this.resource)).exists()) continue;
                try {
                    marker.setAttribute("message", (Object)events[i].getMsg());
                    if (events[i].getSeverity() >= 50) {
                        marker.setAttribute("severity", 2);
                    } else if (events[i].getSeverity() >= 20) {
                        marker.setAttribute("severity", 1);
                    } else if (events[i].getSeverity() > 0) {
                        marker.setAttribute("severity", 0);
                    }
                    marker.setAttribute("userEditable", true);
                    continue;
                }
                catch (CoreException e) {
                    // empty catch block
                }
            }
        }
        return events;
    }

    public Object[] testEventInterface(Object[] msgs) throws AdapterInvalidConfig {
        return this.testProcessCBEs((CommonBaseEvent[])msgs);
    }

    private CommonBaseEvent[] testProcessCBEs(CommonBaseEvent[] events) {
        return events;
    }

    private IMarker createProblemMarker(IResource resource) {
        try {
            IMarker marker = resource.createMarker("org.eclipse.hyades.logging.adapter.glaproblemmarker");
            return marker;
        }
        catch (CoreException e) {
            return null;
        }
    }
}

