/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.trace;

import org.eclipse.hyades.collection.correlation.BaseCorrelatorDataImpl;
import org.eclipse.hyades.collection.correlation.exceptions.InsufficientBufferLengthException;

public class TraceCorrelator
extends BaseCorrelatorDataImpl {
    private Class clazz;
    private int object;
    private String method;
    private Class[] parmClasses;
    private Object[] parmValues;
    private String[] parmNames;
    private Class returnClass;
    private Object returnValue;
    private String agentIdRef;
    private String processIdRef;
    private String nodeIdRef;
    private int threadIdRef;

    public int readBinary(byte[] buffer, int offset, int length) throws InsufficientBufferLengthException {
        offset = super.readBinary(buffer, offset, length);
        int stringLength = (int)this.convertBytesToInteger(buffer, offset);
        this.agentIdRef = new String(buffer, offset += 4, stringLength);
        offset += stringLength;
        stringLength = (int)this.convertBytesToInteger(buffer, offset);
        this.processIdRef = new String(buffer, offset += 4, stringLength);
        offset += stringLength;
        stringLength = (int)this.convertBytesToInteger(buffer, offset);
        this.nodeIdRef = new String(buffer, offset += 4, stringLength);
        this.threadIdRef = (int)this.convertBytesToInteger(buffer, offset += stringLength);
        return offset += 4;
    }

    public int writeBinary(byte[] buffer, int offset, int length) throws InsufficientBufferLengthException {
        byte[] byteNodeIdRef;
        byte[] byteProcessIdRef;
        offset = super.writeBinary(buffer, offset, length);
        byte[] byteAgentIdRef = this.agentIdRef.getBytes();
        int totalLength = byteAgentIdRef.length + (byteProcessIdRef = this.processIdRef.getBytes()).length + (byteNodeIdRef = this.nodeIdRef.getBytes()).length + 16;
        if (totalLength > length - offset) {
            throw new InsufficientBufferLengthException(offset + totalLength);
        }
        this.convertIntegerToBytes(byteAgentIdRef.length, buffer, offset);
        System.arraycopy(byteAgentIdRef, 0, buffer, offset += 4, byteAgentIdRef.length);
        this.convertIntegerToBytes(byteProcessIdRef.length, buffer, offset += byteAgentIdRef.length);
        System.arraycopy(byteProcessIdRef, 0, buffer, offset += 4, byteProcessIdRef.length);
        this.convertIntegerToBytes(byteNodeIdRef.length, buffer, offset += byteProcessIdRef.length);
        System.arraycopy(byteNodeIdRef, 0, buffer, offset += 4, byteNodeIdRef.length);
        this.convertIntegerToBytes(this.threadIdRef, buffer, offset += byteNodeIdRef.length);
        return offset += 4;
    }

    public void invalidate() {
        super.invalidate();
        this.clazz = null;
        this.object = 0;
        this.method = null;
        this.parmClasses = null;
        this.parmValues = null;
        this.parmNames = null;
        this.returnClass = null;
        this.returnValue = null;
        this.agentIdRef = null;
        this.processIdRef = null;
        this.nodeIdRef = null;
        this.threadIdRef = 0;
    }

    public void setInvocation(int object, Class clazz, String method, Class[] parmClasses, Object[] parmValues, Class returnClass) {
        this.clazz = clazz;
        this.object = object;
        this.method = method;
        this.parmClasses = parmClasses;
        this.parmValues = parmValues;
        if (returnClass != null) {
            this.returnClass = returnClass;
        }
    }

    public String getInvokedMethod() {
        return this.method;
    }

    public String getAgentIdRef() {
        return this.agentIdRef;
    }

    public String getProcessIdRef() {
        return this.processIdRef;
    }

    public void setAgentIdRef(String agentIdRef) {
        this.agentIdRef = agentIdRef;
    }

    public void setProcessIdRef(String processIdRef) {
        this.processIdRef = processIdRef;
    }

    public int getThreadIdRef() {
        return this.threadIdRef;
    }

    public void setThreadIdRef(int threadIdRef) {
        this.threadIdRef = threadIdRef;
    }

    public Class getClazz() {
        return this.clazz;
    }

    public String getMethod() {
        return this.method;
    }

    public String[] getParmNames() {
        return this.parmNames;
    }

    public Object[] getParmValues() {
        return this.parmValues;
    }

    public void setClazz(Class clazz) {
        this.clazz = clazz;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setParmNames(String[] parmNames) {
        this.parmNames = parmNames;
    }

    public void setParmValues(Object[] parmValues) {
        this.parmValues = parmValues;
    }

    public Class getReturnClass() {
        return this.returnClass;
    }

    public Object getReturnValue() {
        return this.returnValue;
    }

    public void setReturnValue(Object returnValue) {
        this.returnValue = returnValue;
    }

    public int getObject() {
        return this.object;
    }

    public Class[] getParmClasses() {
        return this.parmClasses;
    }

    public void setObject(int object) {
        this.object = object;
    }

    public void setParmClasses(Class[] parmClasses) {
        this.parmClasses = parmClasses;
    }

    public void setReturnClass(Class returnType) {
        this.returnClass = returnType;
    }

    public String getNodeIdRef() {
        return this.nodeIdRef;
    }

    public void setNodeIdRef(String nodeIdRef) {
        this.nodeIdRef = nodeIdRef;
    }
}

