/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.views;

import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.util.IRecordPaneViewerListener;
import org.eclipse.hyades.log.ui.internal.util.RecordChangeEvent;
import org.eclipse.hyades.log.ui.internal.views.LogAnalysisPageBook;
import org.eclipse.hyades.log.ui.internal.views.LogRecordPaneViewer;
import org.eclipse.hyades.log.ui.internal.views.PCDataPane;
import org.eclipse.hyades.log.ui.internal.views.RecordPaneContentProvider;
import org.eclipse.hyades.log.ui.internal.views.RecordPaneLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.part.PageBook;

public class LogRecordPageBook
extends PageBook
implements ISelectionChangedListener,
ISelectionProvider,
IRecordPaneViewerListener {
    private LogRecordPaneViewer fTableViewer;
    private PCDataPane aPCDataPane;
    private LogAnalysisPageBook page;
    private ISelection selection;
    private int selIndex;

    public LogRecordPageBook(Composite parent, int style) {
        super(parent, style);
        this.populateUI();
    }

    private void createColumns() {
        Table fTable = (Table)this.fTableViewer.getControl();
        TableLayout layout = new TableLayout();
        fTable.setLayout((Layout)layout);
        fTable.setHeaderVisible(true);
        String[] headers = new String[]{LogUIPlugin.getResourceString("RecordPaneHeader1"), LogUIPlugin.getResourceString("RecordPaneHeader2")};
        ColumnLayoutData[] layouts = new ColumnLayoutData[]{new ColumnPixelData(150, true), new ColumnPixelData(300, true)};
        TableColumn[] columns = new TableColumn[headers.length];
        boolean ncolumns = false;
        for (int i = 0; i < headers.length; ++i) {
            layout.addColumnData(layouts[i]);
            TableColumn tc = new TableColumn(fTable, 0, i);
            tc.setResizable(layouts[i].resizable);
            tc.setText(headers[i]);
            columns[i] = tc;
        }
    }

    public TableViewer getTableControl() {
        return this.fTableViewer;
    }

    protected void populateUI() {
        this.fTableViewer = new LogRecordPaneViewer((Composite)this);
        this.fTableViewer.setContentProvider((IContentProvider)new RecordPaneContentProvider());
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new RecordPaneLabelProvider());
        this.createColumns();
        LogUIPlugin.getDefault().addRecordPaneViewerListener(this);
        this.aPCDataPane = new PCDataPane((Composite)this, 0);
        this.showPage(this.fTableViewer.getControl());
    }

    public void selectionChanged(SelectionChangedEvent event) {
        try {
            Object singleSelection = null;
            ISelection selection = event.getSelection();
            if (!(selection instanceof IStructuredSelection)) {
                return;
            }
            singleSelection = ((IStructuredSelection)selection).getFirstElement();
            this.selIndex = ((Table)this.fTableViewer.getControl()).getSelectionIndex();
            this.fTableViewer.setInput(singleSelection);
            this.showPage(this.fTableViewer.getControl());
            this.setSelection();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setSelection() {
        Object[] elem = ((RecordPaneContentProvider)this.fTableViewer.getContentProvider()).getElements(this.fTableViewer.getInput());
        Object newSel = null;
        if (elem.length > 0) {
            if (this.selIndex > -1 && this.selIndex < elem.length) {
                newSel = elem[this.selIndex];
            } else {
                this.selIndex = 0;
                newSel = elem[0];
            }
        } else {
            this.selIndex = -1;
            newSel = new Object[]{null};
        }
        if (this.selIndex > -1) {
            ((Table)this.fTableViewer.getControl()).setSelection(this.selIndex);
        }
        this.selection = new StructuredSelection(newSel);
        SelectionChangedEvent e = new SelectionChangedEvent((ISelectionProvider)this, this.selection);
        this.page.selectionChanged(e);
    }

    public ISelection getSelection() {
        return this.selection;
    }

    public void handleRecordChangeEvent(RecordChangeEvent event) {
        if (event.getType() == 1 || event.getType() == 3) {
            this.fTableViewer.getControl().setRedraw(false);
            this.fTableViewer.refresh();
            this.fTableViewer.getControl().setRedraw(true);
            this.setSelection();
        }
    }

    public void setSelection(ISelection selection) {
        this.selection = selection;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.fTableViewer.addSelectionChangedListener(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.fTableViewer.removeSelectionChangedListener(listener);
    }

    public void setAnalysisPageBook(LogAnalysisPageBook page) {
        this.page = page;
    }

    public void dispose() {
        LogUIPlugin.getDefault().removeRecordPaneViewerListener(this);
        super.dispose();
    }
}

