/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.events.cbe.impl.tests;

import junit.framework.Assert;
import junit.framework.TestCase;
import org.eclipse.hyades.logging.events.cbe.ConnectSituation;
import org.eclipse.hyades.logging.events.cbe.EventFactory;
import org.eclipse.hyades.logging.events.cbe.SituationType;
import org.eclipse.hyades.logging.events.cbe.ValidationException;
import org.eclipse.hyades.logging.events.cbe.impl.tests.Util;

public class ConnectSituationImplTest
extends TestCase {
    private ConnectSituation sit;

    public ConnectSituationImplTest(String string) {
        super(string);
    }

    public void testToString() {
        Assert.assertNotNull((Object)this.sit.toString());
    }

    public void testInterface() {
        this.sit.getReasoningScope();
        this.sit.getSituationDisposition();
        this.sit.getSuccessDisposition();
        Assert.assertTrue((boolean)(this.sit instanceof SituationType));
    }

    public void testSerialization() throws Exception {
        Util.testEObjectSerialization(this.sit);
    }

    public void testEquals() {
        ConnectSituation connectSituation = (ConnectSituation)Util.clone(this.sit);
        Assert.assertEquals((Object)this.sit, (Object)connectSituation);
        this.sit.setReasoningScope("r");
        this.sit.setSituationDisposition("s");
        this.sit.setSuccessDisposition("d");
        connectSituation = (ConnectSituation)Util.clone(this.sit);
        Assert.assertEquals((Object)this.sit, (Object)connectSituation);
        connectSituation.setSuccessDisposition("difference");
        Assert.assertFalse((boolean)this.sit.equals(connectSituation));
    }

    public void testValidationMissingAttributes() throws ValidationException {
        Util.assertMissingAttributes(this.sit, "all");
        this.sit.setReasoningScope("r");
        this.sit.setSituationDisposition("s");
        this.sit.setSuccessDisposition("d");
        this.sit.validate();
        this.sit.setReasoningScope(null);
        Util.assertMissingAttributes(this.sit, "reasoningScope");
        this.sit.setReasoningScope("r");
        this.sit.setSituationDisposition(null);
        this.sit.setSuccessDisposition("d");
        Util.assertMissingAttributes(this.sit, "situationDisposition");
        this.sit.setReasoningScope("r");
        this.sit.setSituationDisposition("s");
        this.sit.setSuccessDisposition(null);
        Util.assertMissingAttributes(this.sit, "successDisposition");
    }

    public void testValidationInvalidLengths() {
        this.sit.setReasoningScope(Util.getPaddedString(64));
        this.sit.setSituationDisposition(Util.getPaddedString(64));
        this.sit.setSuccessDisposition(Util.getPaddedString(64));
        try {
            this.sit.validate();
        }
        catch (ValidationException validationException) {
            Assert.fail((String)"Strings have correct length");
        }
        this.sit.setReasoningScope(Util.getPaddedString(65));
        this.sit.setSituationDisposition(Util.getPaddedString(64));
        this.sit.setSuccessDisposition(Util.getPaddedString(64));
        Util.assertInvalidBoundaries(this.sit, "reasoningScope");
        this.sit.setReasoningScope(Util.getPaddedString(64));
        this.sit.setSituationDisposition(Util.getPaddedString(65));
        this.sit.setSuccessDisposition(Util.getPaddedString(64));
        Util.assertInvalidBoundaries(this.sit, "situationDisposition");
        this.sit.setReasoningScope(Util.getPaddedString(64));
        this.sit.setSituationDisposition(Util.getPaddedString(64));
        this.sit.setSuccessDisposition(Util.getPaddedString(65));
        Util.assertInvalidBoundaries(this.sit, "successDisposition");
    }

    public void testAdapter() {
        Util.assertAdapterNotification(this.sit);
    }

    public void testUnsupportedFeature() {
        Util.assertUnsupportedFeature(this.sit);
    }

    protected void setUp() throws Exception {
        super.setUp();
        EventFactory eventFactory = EventFactory.eINSTANCE;
        this.sit = eventFactory.createConnectSituation();
    }
}

