/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.events.cbe.impl.tests;

import junit.framework.Assert;
import junit.framework.TestCase;
import org.eclipse.hyades.logging.events.cbe.ContextDataElement;
import org.eclipse.hyades.logging.events.cbe.EventFactory;
import org.eclipse.hyades.logging.events.cbe.ValidationException;
import org.eclipse.hyades.logging.events.cbe.impl.tests.Util;

public class ContextDataElementImplTest
extends TestCase {
    ContextDataElement cde = null;

    public ContextDataElementImplTest(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.cde = EventFactory.eINSTANCE.createContextDataElement();
    }

    public void testValidate1() throws ValidationException {
        this.cde = EventFactory.eINSTANCE.createContextDataElement();
        this.cde.setName("CDE test");
        this.cde.setType("Type");
        this.cde.setContextValue("Value");
        this.cde.validate();
        this.cde = EventFactory.eINSTANCE.createContextDataElement();
        this.cde.setName("CDE test");
        this.cde.setType("Type");
        this.cde.setContextId(Util.getAlphaString(32));
        this.cde.validate();
    }

    public void testRequiredAttributes() throws ValidationException {
        this.cde = EventFactory.eINSTANCE.createContextDataElement();
        Util.assertMissingAttributes(this.cde, "all attributes missing");
        this.cde.setName("CDE test");
        this.cde.setType("Type");
        try {
            this.cde.validate();
            Assert.fail((String)("Missing required value contextId or contextValue " + this.cde.getClass().getName()));
        }
        catch (ValidationException validationException) {
            Util.assertExceptionId("IWAT0204E", validationException);
        }
        this.cde.setContextValue("Value");
        this.cde.setContextId(Util.getAlphaString(32));
        try {
            this.cde.validate();
            Assert.fail((String)("Mutually exclusive attributes contextId and contextValue " + this.cde.getClass().getName()));
        }
        catch (ValidationException validationException) {
            Util.assertExceptionId("IWAT0204E", validationException);
        }
    }

    public void testInvalidAttributes() throws ValidationException {
        this.cde = EventFactory.eINSTANCE.createContextDataElement();
        this.cde.setName(Util.getAlphaString(65));
        this.cde.setType("Type");
        this.cde.setContextValue("Value");
        Util.assertInvalidBoundaries(this.cde, "name");
        this.cde.setName("CDE test");
        this.cde.setType(Util.getAlphaString(65));
        Util.assertInvalidBoundaries(this.cde, "type");
        this.cde.setType("Type");
        this.cde.setContextValue(Util.getAlphaString(1025));
        Util.assertInvalidBoundaries(this.cde, "value");
        this.cde = EventFactory.eINSTANCE.createContextDataElement();
        this.cde.setName("CDE test");
        this.cde.setType("Type");
        this.cde.setContextId(Util.getAlphaString(15));
        try {
            this.cde.validate();
            Assert.fail((String)("id is too short in " + this.cde.getClass().getName()));
        }
        catch (ValidationException validationException) {
            Util.assertExceptionId("IWAT0208E", validationException);
        }
        this.cde.setContextId(Util.getAlphaString(65));
        try {
            this.cde.validate();
            Assert.fail((String)("id is too long in " + this.cde.getClass().getName()));
        }
        catch (ValidationException validationException) {
            Util.assertExceptionId("IWAT0208E", validationException);
        }
    }

    public void testToString() throws ValidationException {
        String string = "my name";
        String string2 = "my type";
        String string3 = "my value";
        String string4 = "my id";
        this.cde = EventFactory.eINSTANCE.createContextDataElement();
        Assert.assertNotNull((String)"empty cde", (Object)this.cde.toString());
        this.cde.setName(string);
        this.cde.setType(string2);
        this.cde.setContextValue(string3);
        this.cde.setContextId(string4);
        Assert.assertNotNull((String)"cde with soma data filled in", (Object)this.cde.toString());
    }

    public void testGetSet() throws ValidationException {
        String string = "my name";
        String string2 = "my type";
        String string3 = "my value";
        String string4 = "my id";
        this.cde = EventFactory.eINSTANCE.createContextDataElement();
        this.cde.setName(string);
        this.cde.setType(string2);
        this.cde.setContextValue(string3);
        this.cde.setContextId(string4);
        Assert.assertEquals((String)string, (String)this.cde.getName());
        Assert.assertEquals((String)string2, (String)this.cde.getType());
        Assert.assertEquals((String)string3, (String)this.cde.getContextValue());
        Assert.assertEquals((String)string4, (String)this.cde.getContextId());
    }

    public void testEquals() {
        ContextDataElement contextDataElement = EventFactory.eINSTANCE.createContextDataElement();
        contextDataElement.setName("cde test");
        contextDataElement.setType("Type");
        contextDataElement.setContextId("my id");
        ContextDataElement contextDataElement2 = EventFactory.eINSTANCE.createContextDataElement();
        contextDataElement2.setName("cde test");
        contextDataElement2.setType("Type");
        contextDataElement2.setContextId("my other id");
        ContextDataElement contextDataElement3 = (ContextDataElement)Util.clone(contextDataElement);
        Assert.assertEquals((Object)contextDataElement, (Object)contextDataElement3);
        ContextDataElement contextDataElement4 = (ContextDataElement)Util.clone(contextDataElement2);
        Assert.assertEquals((Object)contextDataElement2, (Object)contextDataElement4);
        Assert.assertFalse((boolean)contextDataElement.equals(contextDataElement2));
    }
}

