/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.events.cbe.impl.tests;

import junit.framework.Assert;
import junit.framework.TestCase;
import org.eclipse.hyades.logging.events.cbe.DestroySituation;
import org.eclipse.hyades.logging.events.cbe.EventFactory;
import org.eclipse.hyades.logging.events.cbe.SituationType;
import org.eclipse.hyades.logging.events.cbe.ValidationException;
import org.eclipse.hyades.logging.events.cbe.impl.tests.Util;

public class DestroySituationImplTest
extends TestCase {
    private DestroySituation sit;

    public DestroySituationImplTest(String string) {
        super(string);
    }

    public void testToString() {
        Assert.assertNotNull((Object)this.sit.toString());
    }

    public void testInterface() {
        this.sit.getSuccessDisposition();
        this.sit.getReasoningScope();
        Assert.assertTrue((boolean)(this.sit instanceof SituationType));
    }

    public void testSerialization() {
        Util.testEObjectSerialization(this.sit);
    }

    public void testEquals() {
        DestroySituation destroySituation = (DestroySituation)Util.clone(this.sit);
        Assert.assertEquals((Object)this.sit, (Object)destroySituation);
        this.sit.setSuccessDisposition("s");
        this.sit.setReasoningScope("r");
        destroySituation = (DestroySituation)Util.clone(this.sit);
        Assert.assertEquals((Object)this.sit, (Object)destroySituation);
        destroySituation.setSuccessDisposition("difference");
        Assert.assertFalse((boolean)this.sit.equals(destroySituation));
    }

    public void testValidationMissingAttributes() throws ValidationException {
        Util.assertMissingAttributes(this.sit, "all");
        this.sit.setSuccessDisposition("d");
        this.sit.setReasoningScope("r");
        this.sit.validate();
        this.sit.setSuccessDisposition(null);
        Util.assertMissingAttributes(this.sit, "setSuccessDisposition");
        this.sit.setSuccessDisposition("d");
        this.sit.setReasoningScope(null);
        Util.assertMissingAttributes(this.sit, "reasoningScope");
    }

    public void testValidationInvalidLengths() {
        this.sit.setSuccessDisposition(Util.getPaddedString(64));
        this.sit.setReasoningScope(Util.getPaddedString(64));
        try {
            this.sit.validate();
        }
        catch (ValidationException validationException) {
            Assert.fail((String)"Strings have correct length");
        }
        this.sit.setSuccessDisposition(Util.getPaddedString(65));
        this.sit.setReasoningScope(Util.getPaddedString(64));
        Util.assertInvalidBoundaries(this.sit, "setSuccessDisposition");
        this.sit.setSuccessDisposition(Util.getPaddedString(64));
        this.sit.setReasoningScope(Util.getPaddedString(65));
        Util.assertInvalidBoundaries(this.sit, "reasoningScope");
    }

    public void testAdapter() {
        Util.assertAdapterNotification(this.sit);
    }

    public void testUnsupportedFeature() {
        Util.assertUnsupportedFeature(this.sit);
    }

    protected void setUp() throws Exception {
        super.setUp();
        EventFactory eventFactory = EventFactory.eINSTANCE;
        this.sit = eventFactory.createDestroySituation();
    }
}

