/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.events.cbe.impl.tests;

import junit.framework.Assert;
import junit.framework.TestCase;
import org.eclipse.hyades.logging.events.cbe.EventFactory;
import org.eclipse.hyades.logging.events.cbe.MsgCatalogToken;
import org.eclipse.hyades.logging.events.cbe.ValidationException;
import org.eclipse.hyades.logging.events.cbe.impl.tests.Util;

public class MsgCatalogTokenImplTest
extends TestCase {
    private MsgCatalogToken mct;

    public MsgCatalogTokenImplTest(String string) {
        super(string);
    }

    public void testInterface() {
        this.mct.getValue();
    }

    public void testSerialization() {
        Util.testEObjectSerialization(this.mct);
    }

    public void testEquals() {
        MsgCatalogToken msgCatalogToken = (MsgCatalogToken)Util.clone(this.mct);
        Assert.assertEquals((Object)this.mct, (Object)msgCatalogToken);
        msgCatalogToken.setValue("difference");
        Assert.assertFalse((boolean)this.mct.equals(msgCatalogToken));
    }

    public void testToString() {
        Assert.assertNotNull((Object)this.mct.toString());
    }

    public void testValidationMissingAttributes() throws ValidationException {
        Util.assertMissingAttributes(this.mct, "all");
        this.mct.setValue("value");
        this.mct.validate();
        this.mct.setValue(null);
        Util.assertMissingAttributes(this.mct, "value");
    }

    public void testValidationInvalidLengths() {
        this.mct.setValue(Util.getPaddedString(256));
        Util.assertValidBoundaries(this.mct);
        this.mct.setValue(Util.getPaddedString(257));
        Util.assertInvalidBoundaries(this.mct, "value");
    }

    protected void setUp() throws Exception {
        super.setUp();
        EventFactory eventFactory = EventFactory.eINSTANCE;
        this.mct = eventFactory.createMsgCatalogToken();
    }
}

