/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.events.cbe.impl.tests;

import junit.framework.Assert;
import junit.framework.TestCase;
import org.eclipse.hyades.logging.events.cbe.EventFactory;
import org.eclipse.hyades.logging.events.cbe.SituationType;
import org.eclipse.hyades.logging.events.cbe.StopSituation;
import org.eclipse.hyades.logging.events.cbe.ValidationException;
import org.eclipse.hyades.logging.events.cbe.impl.tests.Util;

public class StopSituationImplTest
extends TestCase {
    private StopSituation sit;

    public StopSituationImplTest(String string) {
        super(string);
    }

    public void testToString() {
        Assert.assertNotNull((Object)this.sit.toString());
    }

    public void testInterface() {
        this.sit.getSituationQualifier();
        this.sit.getSuccessDisposition();
        this.sit.getReasoningScope();
        Assert.assertTrue((boolean)(this.sit instanceof SituationType));
    }

    public void testSerialization() {
        Util.testEObjectSerialization(this.sit);
    }

    public void testEquals() {
        StopSituation stopSituation = (StopSituation)Util.clone(this.sit);
        Assert.assertEquals((Object)this.sit, (Object)stopSituation);
        this.sit.setSituationQualifier("q");
        this.sit.setSuccessDisposition("s");
        this.sit.setReasoningScope("r");
        stopSituation = (StopSituation)Util.clone(this.sit);
        Assert.assertEquals((Object)this.sit, (Object)stopSituation);
        stopSituation.setSuccessDisposition("difference");
        Assert.assertFalse((boolean)this.sit.equals(stopSituation));
    }

    public void testValidationMissingAttributes() throws ValidationException {
        Util.assertMissingAttributes(this.sit, "all");
        this.sit.setSuccessDisposition("s");
        this.sit.setSituationQualifier("q");
        this.sit.setReasoningScope("r");
        this.sit.validate();
        this.sit.setSuccessDisposition(null);
        Util.assertMissingAttributes(this.sit, "successDisposition");
        this.sit.setSuccessDisposition("s");
        this.sit.setSituationQualifier(null);
        this.sit.setReasoningScope("r");
        Util.assertMissingAttributes(this.sit, "situationQualifier");
        this.sit.setSuccessDisposition("s");
        this.sit.setSituationQualifier("q");
        this.sit.setReasoningScope(null);
        Util.assertMissingAttributes(this.sit, "reasoningScope");
    }

    public void testValidationInvalidLengths() {
        this.sit.setSituationQualifier(Util.getPaddedString(64));
        this.sit.setSuccessDisposition(Util.getPaddedString(64));
        this.sit.setReasoningScope(Util.getPaddedString(64));
        try {
            this.sit.validate();
        }
        catch (ValidationException validationException) {
            Assert.fail((String)"Strings have correct length");
        }
        this.sit.setSituationQualifier(Util.getPaddedString(65));
        this.sit.setSuccessDisposition(Util.getPaddedString(64));
        this.sit.setReasoningScope(Util.getPaddedString(64));
        Util.assertInvalidBoundaries(this.sit, "situationQualifier");
        this.sit.setSituationQualifier(Util.getPaddedString(64));
        this.sit.setSuccessDisposition(Util.getPaddedString(65));
        this.sit.setReasoningScope(Util.getPaddedString(64));
        Util.assertInvalidBoundaries(this.sit, "successDisposition");
        this.sit.setSituationQualifier(Util.getPaddedString(64));
        this.sit.setSuccessDisposition(Util.getPaddedString(64));
        this.sit.setReasoningScope(Util.getPaddedString(65));
        Util.assertInvalidBoundaries(this.sit, "reasoningScope");
    }

    public void testAdapter() {
        Util.assertAdapterNotification(this.sit);
    }

    public void testUnsupportedFeature() {
        Util.assertUnsupportedFeature(this.sit);
    }

    protected void setUp() throws Exception {
        super.setUp();
        EventFactory eventFactory = EventFactory.eINSTANCE;
        this.sit = eventFactory.createStopSituation();
    }
}

