/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.events.cbe.tests;

import java.io.Serializable;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.events.cbe.CompletionException;
import org.eclipse.hyades.logging.events.cbe.ContentHandler;
import org.eclipse.hyades.logging.events.cbe.EventException;
import org.eclipse.hyades.logging.events.cbe.EventFactory;
import org.eclipse.hyades.logging.events.cbe.EventFactoryFactory;

public class EventFactoryFactoryTest
extends TestCase {
    public EventFactoryFactoryTest(String string) {
        super(string);
    }

    public void testCreateEventFactory() {
        EventFactory eventFactory = EventFactoryFactory.createEventFactory();
        eventFactory.createCommonBaseEvent();
    }

    public void testCreateEventFactoryWithHandler() throws EventException {
        MockHandler mockHandler = new MockHandler("Example");
        EventFactory eventFactory = EventFactoryFactory.createEventFactory(mockHandler);
        CommonBaseEvent commonBaseEvent = eventFactory.createCommonBaseEvent();
        commonBaseEvent.complete();
        Assert.assertNotNull((Object)commonBaseEvent.getExtensionName());
        Assert.assertEquals((String)"Example", (String)commonBaseEvent.getExtensionName());
    }

    public class MockHandler
    implements ContentHandler,
    Serializable {
        private String extensionName;

        public MockHandler(String string) {
            this.extensionName = string;
        }

        public void completeEvent(CommonBaseEvent commonBaseEvent) throws CompletionException {
            commonBaseEvent.setExtensionName(this.extensionName);
        }
    }
}

