/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.uml2sd.trace;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class TraceSDPlugin
extends AbstractUIPlugin {
    private static TraceSDPlugin plugin;
    private ResourceBundle resourceBundle;
    private static URL BASIC_URL;
    private static Hashtable images;
    public static boolean debugMatch;
    public static boolean debugLoader;
    public static boolean debugEvents;
    public static boolean debugPlugin;

    public TraceSDPlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        plugin = this;
        try {
            this.resourceBundle = descriptor.getResourceBundle();
        }
        catch (MissingResourceException x) {
            this.resourceBundle = null;
        }
    }

    public static TraceSDPlugin getDefault() {
        return plugin;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    protected void initializeDefaultPreferences(IPreferenceStore store) {
        store.setDefault("page_size", 131072);
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = TraceSDPlugin.getDefault().getResourceBundle();
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException e) {
            return key;
        }
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public static String getPluginId() {
        return TraceSDPlugin.getDefault().getDescriptor().getUniqueIdentifier();
    }

    public static Image getResourceImage(String _name) {
        ImageDescriptor imgd;
        Image img;
        if (TraceSDPlugin.getDefault() == null) {
            return null;
        }
        if (images != null && (img = (Image)images.get(_name)) != null && !img.isDisposed()) {
            TraceSDPlugin.debugTracePlugin("Optimizing for image " + _name);
            return img;
        }
        if (BASIC_URL == null) {
            try {
                BASIC_URL = new URL(TraceSDPlugin.getDefault().getDescriptor().getInstallURL(), "icons/");
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
                return null;
            }
            images = new Hashtable();
        }
        try {
            URL url = new URL(BASIC_URL, _name);
            imgd = ImageDescriptor.createFromURL((URL)url);
            TraceSDPlugin.debugTracePlugin("Getting image " + url);
        }
        catch (MalformedURLException e) {
            imgd = ImageDescriptor.getMissingImageDescriptor();
            TraceSDPlugin.debugTracePlugin("Missing image " + BASIC_URL + _name);
        }
        Image img2 = imgd.createImage();
        images.put(_name, img2);
        return img2;
    }

    public void startup() throws CoreException {
        TraceSDPlugin.debugTracePlugin("Startup called");
        super.startup();
    }

    public void shutdown() throws CoreException {
        if (images == null) {
            return;
        }
        Iterator e = images.values().iterator();
        while (e.hasNext()) {
            Object next = e.next();
            if (!(next instanceof Image) || ((Image)next).isDisposed()) continue;
            ((Image)next).dispose();
        }
        images.clear();
        images = null;
        super.shutdown();
        TraceSDPlugin.debugTracePlugin("Shutdown finished");
    }

    private static boolean checkForDebugTrace(String option) {
        String value = Platform.getDebugOption((String)option);
        return value != null && value.equalsIgnoreCase("true");
    }

    public static void debugTraceMatch(String msg) {
        if (debugMatch) {
            System.out.println(msg);
        }
    }

    public static void debugTraceLoader(String msg) {
        if (debugLoader) {
            System.out.println(msg);
        }
    }

    public static void debugTraceEvents(String msg) {
        if (debugEvents) {
            System.out.println(msg);
        }
    }

    public static void debugTracePlugin(String msg) {
        if (debugPlugin) {
            System.out.println(msg);
        }
    }

    static {
        BASIC_URL = null;
        images = null;
        debugMatch = TraceSDPlugin.checkForDebugTrace("org.eclipse.hyades.uml2sd.trace/match");
        debugLoader = TraceSDPlugin.checkForDebugTrace("org.eclipse.hyades.uml2sd.trace/loader");
        debugEvents = TraceSDPlugin.checkForDebugTrace("org.eclipse.hyades.uml2sd.trace/events");
        debugPlugin = TraceSDPlugin.checkForDebugTrace("org.eclipse.hyades.uml2sd.trace/plugin");
    }
}

