/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.resources.database.internal.extensions;

import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import org.eclipse.hyades.loaders.util.HyadesResourceExtensions;
import org.eclipse.hyades.resources.database.internal.DBCollectedExceptions;
import org.eclipse.hyades.resources.database.internal.extensions.DatabaseType;
import org.eclipse.hyades.resources.database.internal.impl.SQLStatement;

public abstract class JDBCHelper {
    protected boolean debug = false;
    protected boolean toFileOnly = false;
    protected String protocol;
    protected String driver;
    protected Connection connection;
    protected DatabaseType type;
    protected String urlString;
    protected Driver driverInstance;
    protected Writer file;

    public JDBCHelper(DatabaseType type) {
        String s;
        this.type = type;
        try {
            s = System.getProperties().getProperty("JDBCHelper.debug");
            this.debug = Boolean.valueOf(s);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            s = System.getProperties().getProperty("JDBCHelper.toFileOnly");
            this.toFileOnly = Boolean.valueOf(s);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Driver loadJDBCDriver() throws Exception {
        if (this.driverInstance != null) {
            return this.driverInstance;
        }
        return this.loadJDBCDriverSpecial();
    }

    protected Driver loadJDBCDriverSpecial() throws Exception {
        if (this.driverInstance != null) {
            return this.driverInstance;
        }
        DriverClassLoader cl = new DriverClassLoader(new URL[]{new URL(this.urlString)}, this.getClass().getClassLoader());
        Class<?> driverClass = Class.forName(this.driver, true, cl);
        Enumeration<Driver> enumeration = DriverManager.getDrivers();
        while (enumeration.hasMoreElements()) {
            Driver element = enumeration.nextElement();
            if (element.getClass() != driverClass) continue;
            this.driverInstance = element;
        }
        if (this.driverInstance == null) {
            this.driverInstance = (Driver)driverClass.newInstance();
            DriverManager.registerDriver(this.driverInstance);
        }
        return this.driverInstance;
    }

    public void openForExistingDB(String name, Properties properties) throws Exception {
        this.loadJDBCDriver();
        this.connection = this.driverInstance.connect(this.protocol + this.getLocation(properties) + name, properties);
    }

    protected String getLocation(Properties properties) {
        String location = properties.getProperty("location");
        location = location == null || location.length() == 0 ? "" : "//" + location + "/";
        return location;
    }

    public void openForNewDB(String name, Properties properties) throws Exception {
        this.loadJDBCDriver();
        this.connection = this.driverInstance.connect(this.protocol + this.getLocation(properties) + name + ";create=true", properties);
    }

    public void close() throws SQLException {
        if (!this.getConnection().getAutoCommit()) {
            this.getConnection().commit();
        }
        this.getConnection().close();
    }

    public boolean shutdown() {
        boolean exceptionThrown = false;
        try {
            DriverManager.getConnection(this.protocol + ";shutdown=true");
        }
        catch (SQLException exception) {
            exceptionThrown = true;
        }
        return exceptionThrown;
    }

    public synchronized void executeStatement(String statement) throws Exception {
        Statement s = this.getConnection().createStatement();
        this.execute(s, statement);
        s.close();
    }

    public synchronized void executeUpdateStatement(String statement) throws Exception {
        Statement s = this.getConnection().createStatement();
        this.executeUpdate(s, statement);
        s.close();
    }

    public synchronized void executeUpdate(Statement statement, String sqlString) throws Exception {
        if (this.debug) {
            System.out.println(sqlString);
        }
        if (this.toFileOnly) {
            this.writeToFile(sqlString);
        } else {
            statement.executeUpdate(sqlString);
        }
    }

    protected void writeToFile(String sqlString) {
        try {
            if (this.file == null) {
                this.file = new FileWriter("D:/temp/log_" + new Date().getTime() + ".sql");
            }
            this.file.write(sqlString + "\n");
            this.file.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public void executeUpdateStatements(String[] statements) throws Exception {
        for (int i = 0; i < statements.length; ++i) {
            this.executeUpdateStatement(statements[i]);
        }
    }

    public void executeUpdateStatements(List statements) throws Exception {
        int l = statements.size();
        for (int i = 0; i < l; ++i) {
            SQLStatement statement = (SQLStatement)statements.get(i);
            this.executeUpdateStatement(statement.getStatement());
        }
    }

    public PreparedStatement createPreparedStatement(String statement) throws Exception {
        return this.getConnection().prepareStatement(statement);
    }

    public Statement createStatement() throws Exception {
        return this.getConnection().createStatement();
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws Exception {
        return this.getConnection().createStatement(resultSetType, resultSetConcurrency);
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws Exception {
        return this.getConnection().createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    public void setAutoCommit(boolean value) throws Exception {
        this.getConnection().setAutoCommit(value);
    }

    public synchronized void execute(Statement statement, String sqlString) throws Exception {
        if (this.debug) {
            System.out.println(sqlString);
        }
        if (this.toFileOnly) {
            this.writeToFile(sqlString);
        } else {
            statement.execute(sqlString);
        }
    }

    public synchronized ResultSet executeQuery(Statement statement, String sqlString) throws Exception {
        if (this.debug) {
            System.out.println(sqlString);
        }
        ResultSet res = null;
        try {
            res = statement.executeQuery(sqlString);
        }
        catch (Exception e) {
            System.err.println("------------ JDBCHelper.executeQuery sqlString=" + sqlString);
            e.printStackTrace();
            throw e;
        }
        return res;
    }

    public DatabaseType getDatabaseType() {
        return this.type;
    }

    public Connection getConnection() {
        try {
            if (this.connection == null || this.connection.isClosed()) {
                Properties properties = HyadesResourceExtensions.getInstance().getProperties();
                this.openForExistingDB("Hyades", properties);
            }
        }
        catch (Exception e) {
            throw new DBCollectedExceptions(e);
        }
        return this.connection;
    }

    public synchronized boolean executePreparedStatemet(PreparedStatement ps) throws Exception {
        if (this.debug) {
            System.out.println(ps);
        }
        if (this.toFileOnly) {
            this.writeToFile(this.printPreparedStatementParameters(ps));
            return true;
        }
        return ps.execute();
    }

    public synchronized int[] executeBatchedPreparedStatement(PreparedStatement ps) throws Exception {
        if (this.debug) {
            System.out.println(ps);
        }
        if (this.toFileOnly) {
            this.writeToFile(this.printPreparedStatementParameters(ps));
            return new int[0];
        }
        int[] res = null;
        try {
            res = ps.executeBatch();
        }
        catch (BatchUpdateException e) {
            System.err.println("------------ JDBCHelper.executeBatchedPreparedStatement");
            e.printStackTrace();
            SQLException e1 = null;
            int i = 1;
            while ((e1 = e.getNextException()) != null) {
                System.err.println("------------ " + i++ + "-------------");
                e1.printStackTrace();
            }
            throw e;
        }
        return res;
    }

    private String printPreparedStatementParameters(PreparedStatement ps) throws Exception {
        String res = ps.toString();
        boolean first = true;
        try {
            res = res + ": PreparedStatement.resultSetMetaData=";
            ResultSetMetaData metaData = ps.getMetaData();
            if (metaData == null) {
                res = res + metaData;
            } else {
                for (int i = 0; i < metaData.getColumnCount(); ++i) {
                    if (first) {
                        first = false;
                    } else {
                        res = res + ", ";
                    }
                    res = res + "col" + i + "=" + metaData.getTableName(i) + "." + metaData.getColumnLabel(i);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return res;
    }

    public void commitTransaction() throws Exception {
        if (!this.getConnection().getAutoCommit()) {
            this.getConnection().commit();
        }
    }

    public void rollbackTransaction() throws Exception {
        if (!this.getConnection().getAutoCommit()) {
            this.getConnection().rollback();
        }
    }

    public class DriverClassLoader
    extends URLClassLoader {
        public DriverClassLoader(URL[] urls, ClassLoader parent) {
            super(urls, parent);
        }

        protected Class findClass(String name) throws ClassNotFoundException {
            return super.findClass(name);
        }
    }
}

