/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.resources.database.internal.impl;

import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.hyades.resources.database.internal.DBMap;
import org.eclipse.hyades.resources.database.internal.extensions.DatabaseType;
import org.eclipse.hyades.resources.database.internal.extensions.JDBCHelper;
import org.eclipse.hyades.resources.database.internal.impl.DBCommand;
import org.eclipse.hyades.resources.database.internal.impl.QueryStatement;
import org.eclipse.hyades.resources.database.internal.impl.StatementFactory;

public class GetIdsOfMatches
extends DBCommand {
    protected DatabaseType type;
    protected EClass eClass;
    protected Map values;

    public GetIdsOfMatches(JDBCHelper helper, DBMap map, DatabaseType dbType, EClass eClass, Map values) {
        super(helper, map);
        this.type = dbType;
        this.eClass = eClass;
        this.values = values;
    }

    public Object execute() throws Exception {
        List valuesForClass;
        Map.Entry entry;
        EClass eClass;
        Map classesToValues = this.computeClassesToValues();
        List ids = new ArrayList();
        Iterator entries = classesToValues.entrySet().iterator();
        while (entries.hasNext() && !(ids = this.getIds(eClass = (EClass)(entry = entries.next()).getKey(), valuesForClass = (List)entry.getValue(), ids)).isEmpty()) {
        }
        return ids;
    }

    protected Map computeClassesToValues() {
        HashMap classesToValues = new HashMap();
        Iterator entries = this.values.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            EAttribute attribute = (EAttribute)entry.getKey();
            Object value = entry.getValue();
            this.addValueToMap(classesToValues, attribute, value);
        }
        return classesToValues;
    }

    protected void addValueToMap(Map map, EAttribute attribute, Object value) {
        EClass eClass = attribute.getEContainingClass();
        ArrayList<EAttribute> valuesForClass = (ArrayList<EAttribute>)map.get(eClass);
        if (valuesForClass == null) {
            valuesForClass = new ArrayList<EAttribute>();
            map.put(eClass, valuesForClass);
        }
        valuesForClass.add(attribute);
        valuesForClass.add((EAttribute)value);
    }

    protected List getIds(EClass eClass, List valuesForClass, List ids) throws Exception {
        ArrayList<Integer> newIds = new ArrayList<Integer>();
        Statement statement = this.helper.createStatement();
        ResultSet result = this.helper.executeQuery(statement, this.getQuery(eClass, valuesForClass, ids));
        while (result.next()) {
            newIds.add(new Integer(result.getInt(1)));
        }
        result.close();
        statement.close();
        return newIds;
    }

    protected String getQuery(EClass eClass, List valuesForClass, List ids) {
        StatementFactory factory = StatementFactory.INSTANCE;
        QueryStatement query = factory.createAttributeValueQuery(this.type, this.dbMap, eClass, valuesForClass, ids);
        return query.getStatement();
    }
}

