/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.security;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.hyades.security.SecurityImages;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class SecurityPlugin
extends AbstractUIPlugin {
    private static final String KEYSTORE = "keystore.dat";
    private static SecurityPlugin inst;
    private static ResourceBundle aResourceBundle;

    public SecurityPlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        if (inst == null) {
            inst = this;
        }
        aResourceBundle = this.getDescriptor().getResourceBundle();
    }

    public static SecurityPlugin getDefault() {
        return inst;
    }

    public static String getPluginId() {
        return SecurityPlugin.getDefault().getDescriptor().getUniqueIdentifier();
    }

    public static ResourceBundle getResourceBundle() {
        return aResourceBundle;
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = SecurityPlugin.getResourceBundle();
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException e) {
            return key;
        }
    }

    public static String getKeyStoreLocation() {
        return Platform.getPluginStateLocation((Plugin)inst).append(KEYSTORE).toOSString();
    }

    public static String getWorkspaceName() {
        IPath workspace = Platform.getLocation();
        int nr = workspace.segmentCount();
        String workspaceName = workspace.segment(nr - 1);
        return workspaceName;
    }

    public void shutdown() throws CoreException {
        SecurityImages.shutdown();
        super.shutdown();
    }

    public static Shell getActiveWorkbenchShell() {
        return SecurityPlugin.getActiveWorkbenchWindow().getShell();
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return SecurityPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }
}

