/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.statistical.ui.editor.internal;

import org.eclipse.hyades.statistical.ui.EditorPlugin;
import org.eclipse.hyades.statistical.ui.widgets.internal.GData;
import org.eclipse.hyades.statistical.ui.widgets.spinner.internal.DateSpinner;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ExportTimeDialog
extends Dialog {
    boolean DEBUG = true;
    Shell shell;
    Composite main_panel;
    Text avg_panel;
    DateSpinner start_panel;
    DateSpinner finish_panel;
    Composite button_panel;
    Button cancel_button;
    Button ok_button;
    long avg_period_ms;
    long start_t;
    long finish_t;
    public static final int OK = 0;
    public static final int CANCEL = 1;
    boolean ok = false;

    public ExportTimeDialog(Shell shell, long avg_period_ms, long start_t, long finish_t) {
        super(shell);
        this.avg_period_ms = avg_period_ms;
        this.start_t = start_t;
        this.finish_t = finish_t;
        this.setText(EditorPlugin.getString("EXPORT_TITLE"));
    }

    public int open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 67680);
        this.shell.setText(this.getText());
        this.shell.setLayout((Layout)new FillLayout());
        this.shell.setBounds(0, 0, 500, 220);
        this.initGraphics();
        this.shell.pack();
        Rectangle r = parent.getBounds();
        Rectangle z = this.shell.getBounds();
        if (z.width < 500) {
            z.width = 500;
        }
        if (z.height < 220) {
            z.height = 220;
        }
        this.shell.setBounds(r.x + r.width / 2 - z.width / 2, r.y + r.height / 2 - z.height / 2, z.width, z.height);
        this.shell.open();
        Display display = parent.getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        if (this.ok) {
            return 0;
        }
        return 1;
    }

    public long getAveragePeriodMS() {
        return this.avg_period_ms;
    }

    public long getStartTime() {
        return this.start_t;
    }

    public long getMaxTime() {
        return this.finish_t;
    }

    private void initGraphics() {
        this.main_panel = new Composite((Composite)this.shell, 0);
        GridLayout glayout = new GridLayout();
        glayout.numColumns = 2;
        this.main_panel.setLayout((Layout)glayout);
        new Label(this.main_panel, 0).setText(EditorPlugin.getString("EXPORT_AVERAGE_OVER"));
        this.avg_panel = new Text(this.main_panel, 2048);
        this.avg_panel.setLayoutData((Object)GData.getGridData(true, false, -1, -1, 1, 1, 4, 4));
        new Label(this.main_panel, 0).setText(EditorPlugin.getString("EXPORT_START_AT"));
        this.start_panel = new DateSpinner(this.main_panel, 0, false);
        this.start_panel.setLayoutData(GData.getGridData(true, false, -1, -1, 1, 1, 4, 4));
        new Label(this.main_panel, 0).setText(EditorPlugin.getString("EXPORT_FINISH_AT"));
        this.finish_panel = new DateSpinner(this.main_panel, 0, false);
        this.finish_panel.setLayoutData(GData.getGridData(true, false, -1, -1, 1, 1, 4, 4));
        this.button_panel = new Composite(this.main_panel, 0);
        this.button_panel.setLayoutData((Object)GData.getGridData(false, false, -1, -1, 2, 1, 2, 3));
        glayout = new GridLayout();
        glayout.numColumns = 2;
        this.button_panel.setLayout((Layout)glayout);
        this.ok_button = new Button(this.button_panel, 0);
        this.ok_button.setLayoutData((Object)GData.getGridData(false, false, -1, -1, 1, 1, 2, 3));
        this.ok_button.setText(EditorPlugin.getString("OK"));
        this.cancel_button = new Button(this.button_panel, 0);
        this.cancel_button.setLayoutData((Object)GData.getGridData(false, false, -1, -1, 1, 1, 2, 3));
        this.cancel_button.setText(EditorPlugin.getString("CANCEL"));
        ButtonListener blist = new ButtonListener();
        this.ok_button.addSelectionListener((SelectionListener)blist);
        this.cancel_button.addSelectionListener((SelectionListener)blist);
        this.avg_panel.setText("" + this.avg_period_ms / 1000L);
        this.start_panel.setDate(this.start_t);
        this.finish_panel.setDate(this.finish_t);
    }

    class ButtonListener
    implements SelectionListener {
        ButtonListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            if (e.getSource() == ExportTimeDialog.this.cancel_button) {
                ExportTimeDialog.this.ok = false;
                ExportTimeDialog.this.shell.dispose();
            } else if (e.getSource() == ExportTimeDialog.this.ok_button) {
                ExportTimeDialog.this.ok = true;
                try {
                    ExportTimeDialog.this.avg_period_ms = 1000L * Long.parseLong(ExportTimeDialog.this.avg_panel.getText());
                    ExportTimeDialog.this.start_t = ExportTimeDialog.this.start_panel.getDate();
                    ExportTimeDialog.this.finish_t = ExportTimeDialog.this.finish_panel.getDate();
                    ExportTimeDialog.this.shell.dispose();
                }
                catch (NumberFormatException x) {
                    MessageBox mbox = new MessageBox(ExportTimeDialog.this.shell, 33);
                    mbox.setText(EditorPlugin.getString("EXPORT_INVALID_PERIOD"));
                    mbox.setMessage(ExportTimeDialog.this.avg_panel.getText() + " " + EditorPlugin.getString("EXPORT_INVALID_PERIOD_MSG"));
                }
            }
        }
    }
}

